<?php if(!defined('ClassCms')) {exit();}?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8"/>
<title>{if isset($title)}{$title}{/if}</title>{br}
{if isset($keywords)}<meta name="keywords" content="{$keywords}">{br}{/if}
{if isset($description)}<meta name="description" content="{$description}">{br}{/if}
<meta name="viewport" content="width=device-width"/>
<link rel="stylesheet" type="text/css" href="{template}css/style.css" />
</head>
<body>
{file header}
<div class="main warp">
    <div class="main_left">
        <div class="page_content">
            <h1 class="domain_title">{$title}</h1>
            <div class="domain_content">
                <table class="domain_table">
                <tr>
                    <td class="bold" width=100px>出售价格:</td>
                    <td class="price">{this:price($price)}
                    {if $issold}(已售){/if}
                    </td>
                </tr>
                <tr>
                    <td class="bold">注册时间:</td>
                    <td>{date('Y-m-d',$regtime)}</td>
                </tr>
                <tr>
                    <td class="bold">到期时间:</td>
                    <td>{date('Y-m-d',$overtime)}</td>
                </tr>
                <tr>
                    <td class="bold">域名含义:</td>
                    <td>{$mean}</td>
                </tr>
                {if $content}
                <tr>
                    <td class="bold">详细介绍:</td>
                    <td>{$content}</td>
                </tr>
                {/if}
                </table>
            </div>
        
        </div>

        <div class="channel ny_recommend">
            <p>推荐域名</p>
            <ul class="recommend">
            {loop a('modulehash','domain','pagesize','8','where.ishide',0,'where.isrecommend',1) as $domain}
            <a href="{$domain.link}" target="_blank"> <div class="domain">{$domain.title}</div> <div class="desc">{$domain.mean}</div> <div class="price">{this:price($domain.price)}</div> </a>
            {/loop}
            </ul>
        </div>

    </div>
    <div class="main_right">
        {file right_contact}
        {file right_article}
        {file right_ad}
    </div>
</div>
{file footer}
</body>
</html>