<!-- ## Design Principles -->

### Private Data

Every business now accumulates knowledge by having all kinds of documents saved electronically within their IT infrastructure.
The challenge is how to discover insight from them in order to help businesses gain competitive edge, while avoiding any pitfalls for data security and privacy and/or addressing regulatory concerns.

This is the type of data Docq is designed to work with.

### Secure Access

With private, organisation data, accessing it securely becomes paramount.

In the age of AI/LLMs, there are many emerging 3rd-party vendors to choose from; However, it is also very easy to unknowingly leak data to these vendors without careful planning on how to adopt these technologies.

Docq is designed to encapsulate the best practices in data security, based on our experience in both AI/LLMs and IT/Cloud infrastructure to aid businesses in their adoption. It is secure by default when using Docq.

### Ease of Onboarding & Operating

It is important for any business to justify costs and benefits for the use of any new software. Docq is no exception and we put in great effort to design

- How a business could get started with Docq within minutes;
- How a business could continue operating Docq with minimal maintenance;
- And how any Docq user at a business could benefit from it instantly without lengthy training.

All of these are reflected in Docq's user interface and user experience design.

### Commercially-friendly Licensing & Support

Last but not least, we release Docq under a licensing structure where any business could use it as-is free-of-charge. For situations where a business wants to have a commercial agreement with both licensing and support for Docq, we can make the arrangements accordingly.
