const github = `<svg focusable="false" viewBox="0 0 51.8 50.4" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em">
<path
  d="M25.9,0.2C11.8,0.2,0.3,11.7,0.3,25.8c0,11.3,7.3,20.9,17.5,24.3c1.3,0.2,1.7-0.6,1.7-1.2c0-0.6,0-2.6,0-4.8c-7.1,1.5-8.6-3-8.6-3c-1.2-3-2.8-3.7-2.8-3.7c-2.3-1.6,0.2-1.6,0.2-1.6c2.6,0.2,3.9,2.6,3.9,2.6c2.3,3.9,6,2.8,7.5,2.1c0.2-1.7,0.9-2.8,1.6-3.4c-5.7-0.6-11.7-2.8-11.7-12.7c0-2.8,1-5.1,2.6-6.9c-0.3-0.7-1.1-3.3,0.3-6.8c0,0,2.1-0.7,7,2.6c2-0.6,4.2-0.9,6.4-0.9c2.2,0,4.4,0.3,6.4,0.9c4.9-3.3,7-2.6,7-2.6c1.4,3.5,0.5,6.1,0.3,6.8c1.6,1.8,2.6,4.1,2.6,6.9c0,9.8-6,12-11.7,12.6c0.9,0.8,1.7,2.4,1.7,4.7c0,3.4,0,6.2,0,7c0,0.7,0.5,1.5,1.8,1.2c10.2-3.4,17.5-13,17.5-24.3C51.5,11.7,40.1,0.2,25.9,0.2z"
></path>
</svg>`;

const code = `<svg
viewBox="0 0 16 16"
xmlns="http://www.w3.org/2000/svg"
fit=""
height="1em"
width="1em"
preserveAspectRatio="xMidYMid meet"
focusable="false"
>
<g fill-rule="evenodd">
  <path d="M.003 8.306l4.302 4.304.849-.848L.852 7.458z"></path>
  <path d="M0 8.308l.847.85 4.31-4.296-.847-.85zM10.8 4.861l4.309 4.296.848-.85-4.309-4.296z"></path>
  <path d="M10.804 11.762l.849.848 4.302-4.304-.85-.848zM8.526 4L6.1 12.582l1.241.006 2.435-8.565z"></path>
</g>
</svg>`;

const external = `<svg
fit=""
focusable="false"
height="100%"
preserveAspectRatio="xMidYMid meet"
viewBox="0 0 24 24"
width="100%"
xmlns="http://www.w3.org/2000/svg"
>
<path d="M0 0h24v24H0z" fill="none"></path>
<path
  d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z"
></path>
</svg>`;

const copy = `<svg
viewBox="0 0 16 16"
xmlns="http://www.w3.org/2000/svg"
fit=""
height="1em"
width="1em"
preserveAspectRatio="xMidYMid meet"
focusable="false"
>
<path
  d="M7.6 8.2V7h4.174v1.2H7.6zm0 3V10h4.174v1.2H7.6zm-4.4-10v10.074H2L2.003 2c0-1.088.895-2 1.997-2h7.585v1.2H3.2zM5 2h9a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1zm.2 1.2v11.6h8.6V3.2H5.2z"
></path>
</svg>`;

const check = `
<svg
  viewBox="0 0 16 16"
  xmlns="http://www.w3.org/2000/svg"
  fit=""
  height="1em"
  width="1em"
  preserveAspectRatio="xMidYMid meet"
  focusable="false"
>
  <path d="M6.012 11.201L1.313 6.832l-.817.879 5.54 5.15 9.304-9.163-.842-.855z"></path>
</svg>`;

const list = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" id="align-justify">
<g id="ageditor/align-justify" stroke-width="1" fill-rule="evenodd">
  <path d="M0 1h16v1.2H0V1zm0 6.4h16v1.2H0V7.4zm0 6.4h16V15H0v-1.2z" id="ag合并形状"></path>
</g>
</svg>`;
const arrowLeft = `<svg width="1em" height="1em" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 55.2 (78181) - https://sketchapp.com -->
    <title>navigation/arrow-left</title>
    <desc>Created with Sketch.</desc>
    <g id="navigation/arrow-left" stroke="none" stroke-width="1"  fill-rule="evenodd">
        <path d="M7.4,4.14955232 L4.4383,7.3151 C4.2123,7.5571 3.8323,7.5691 3.5903,7.3431 C3.3483,7.1161 3.3353,6.7371 3.5623,6.4951 L7.53151194,2.2516372 C7.55538364,2.21814642 7.58305703,2.18659454 7.6145,2.1576 C7.8585,1.9336 8.2375,1.9496 8.4615,2.1946 L12.4315,6.5176 C12.6565,6.7616 12.6395,7.1416 12.3955,7.3656 C12.1515,7.5896 11.7725,7.5736 11.5475,7.3296 L8.6,4.11846621 L8.6,13.2666667 C8.6,13.6712222 8.331,14 8,14 C7.668,14 7.4,13.6712222 7.4,13.2666667 L7.4,4.14955232 Z" id="形状结合"  transform="translate(7.995013, 7.999832) rotate(-90.000000) translate(-7.995013, -7.999832) "></path>
    </g>
</svg>`;
const arrowRight = `<svg width="1em" height="1em" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 55.2 (78181) - https://sketchapp.com -->
    <title>navigation/arrow-right</title>
    <desc>Created with Sketch.</desc>
    <g id="navigation/arrow-right" stroke="none" stroke-width="1"  fill-rule="evenodd">
        <path d="M7.4,4.14955232 L4.4383,7.3151 C4.2123,7.5571 3.8323,7.5691 3.5903,7.3431 C3.3483,7.1161 3.3353,6.7371 3.5623,6.4951 L7.53151194,2.2516372 C7.55538364,2.21814642 7.58305703,2.18659454 7.6145,2.1576 C7.8585,1.9336 8.2375,1.9496 8.4615,2.1946 L12.4315,6.5176 C12.6565,6.7616 12.6395,7.1416 12.3955,7.3656 C12.1515,7.5896 11.7725,7.5736 11.5475,7.3296 L8.6,4.11846621 L8.6,13.2666667 C8.6,13.6712222 8.331,14 8,14 C7.668,14 7.4,13.6712222 7.4,13.2666667 L7.4,4.14955232 Z" id="形状结合"  transform="translate(7.995013, 7.999832) rotate(90.000000) translate(-7.995013, -7.999832) "></path>
    </g>
</svg>`;
const angleRight = `<svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 55.2 (78181) - https://sketchapp.com -->
    <title>navigation/angle-right</title>
    <desc>Created with Sketch.</desc>
    <g id="navigation/angle-right" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <path d="M7.97815,11.49765 L7.9728,11.503 L2.2998,5.831 L3.1298,5 L7.97807731,9.84827731 L12.8255,5 L13.6565,5.831 L7.9835,11.503 L7.97815,11.49765 Z" id="形状结合" fill="#888888" transform="translate(7.978150, 8.251500) scale(-1, -1) rotate(-270.000000) translate(-7.978150, -8.251500) "></path>
    </g>
</svg>`;
const search = `<svg viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" fit="" height="1em" width="1em" preserveAspectRatio="xMidYMid meet" focusable="false"><g id="oonormal/search" stroke-width="1" fill-rule="evenodd"><path d="M6.751 12.303A5.557 5.557 0 0 1 1.2 6.751C1.2 3.691 3.69 1.2 6.751 1.2a5.558 5.558 0 0 1 5.551 5.551 5.557 5.557 0 0 1-5.551 5.552M6.751 0a6.751 6.751 0 1 0 4.309 11.949l3.855 3.855a.6.6 0 1 0 .849-.849l-3.854-3.853A6.751 6.751 0 0 0 6.751 0" id="ooFill-1"></path></g></svg>`;
const empty = `<svg width="148px" height="134px" viewBox="0 0 148 134" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" class="ng-star-inserted"><defs><filter x="0.0%" y="0.0%" width="100.0%" height="100.0%" filterUnits="objectBoundingBox" id="filter-1"><feGaussianBlur stdDeviation="0" in="SourceGraphic"></feGaussianBlur></filter></defs><g id="148x134" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g id="编组-6" transform="translate(1.000000, 1.000000)"><ellipse id="椭圆形" fill="#EDEEF2" opacity="0.3" filter="url(#filter-1)" cx="73.0800017" cy="115.920003" rx="73.0800017" ry="16.8000004"></ellipse><g id="编组-5" transform="translate(15.120000, 0.000000)"><polygon id="矩形" fill="#E2E4E9" points="19.2789848 49.5600011 99.1200023 48.7200011 117.600003 75.9297673 117.600003 92.313049 0 92.313049 0 75.0356267"></polygon><path d="M23.5200005,0 L94.0800002,0 C97.7913538,2.06413823e-16 100.8,3.00864655 100.8,6.72000015 L100.8,99.1200023 L100.8,99.1200023 L16.8000004,99.1200023 L16.8000004,6.72000015 C16.8000004,3.00864655 19.8086469,1.56994302e-15 23.5200005,0 Z" id="矩形" fill="#F9FAFB"></path><path d="M30.9200007,12.4400003 L86.6800019,12.4400003 C88.5356787,12.4400003 90.040002,13.9443236 90.040002,15.8000004 L90.040002,42.000001 C90.040002,43.8556778 88.5356787,45.360001 86.6800019,45.360001 L30.9200007,45.360001 C29.0643239,45.360001 27.5600006,43.8556778 27.5600006,42.000001 L27.5600006,15.8000004 C27.5600006,13.9443236 29.0643239,12.4400003 30.9200007,12.4400003 Z" id="矩形" fill="#E8EAEE"></path><text id="</null>" font-family="PingFangSC-Medium, PingFang SC" font-size="15.1200003" font-weight="400" fill="#BCBECD"><tspan x="33.6000008" y="32.8000004">&lt;/null&gt;</tspan></text><rect id="矩形" fill="#E8EAEE" x="27.5600006" y="52.0800012" width="61.4800014" height="5.04000011" rx="2.52000006"></rect><rect id="矩形备份" fill="#E8EAEE" x="27.5600006" y="63.8400014" width="61.4800014" height="5.04000011" rx="2.52000006"></rect><path d="M0,75.6000017 L29.280235,75.6000017 C32.0637502,75.6000017 34.3202352,77.8564866 34.3202352,80.6400018 L34.3202352,86.2591426 C34.3202352,89.0426578 36.5767201,91.2991427 39.3602353,91.2991427 L78.4136737,91.2991427 C81.1971889,91.2991427 83.4536738,89.0426578 83.4536738,86.2591426 L83.4536738,80.6400018 C83.4536738,77.8564866 85.7101587,75.6000017 88.4936739,75.6000017 L117.600003,75.6000017 L117.600003,75.6000017 L117.600003,110.880003 C117.600003,115.519195 113.839194,119.280003 109.200002,119.280003 L8.40000019,119.280003 C3.76080819,119.280003 -6.53729019e-15,115.519195 0,110.880003 L0,75.6000017 L0,75.6000017 Z" id="矩形" fill="#EDEFF2"></path></g></g></g></svg>`;
const stackBlitz = `<svg viewBox="0 0 28 28" aria-hidden="true" class="StackBlitzLogo-module-boltIcon-3IWaX" width="28" height="28"><path d="M12.747 16.273h-7.46L18.925 1.5l-3.671 10.227h7.46L9.075 26.5l3.671-10.227z"></path></svg>`;

const lightTheme = `<svg xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-width="4" viewBox="0 0 48 48" aria-hidden="true" focusable="false"><circle cx="24" cy="24" r="9" fill="currentColor" stroke="none"/><path fill="currentColor" stroke="none" d="M21 5.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 .5.5v5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-5ZM21 37.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 .5.5v5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-5ZM42.5 21a.5.5 0 0 1 .5.5v5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-5a.5.5 0 0 1 .5-.5h5ZM10.5 21a.5.5 0 0 1 .5.5v5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-5a.5.5 0 0 1 .5-.5h5ZM39.203 34.96a.5.5 0 0 1 0 .707l-3.536 3.536a.5.5 0 0 1-.707 0l-3.535-3.536a.5.5 0 0 1 0-.707l3.535-3.535a.5.5 0 0 1 .707 0l3.536 3.535ZM16.575 12.333a.5.5 0 0 1 0 .707l-3.535 3.535a.5.5 0 0 1-.707 0L8.797 13.04a.5.5 0 0 1 0-.707l3.536-3.536a.5.5 0 0 1 .707 0l3.535 3.536ZM13.04 39.203a.5.5 0 0 1-.707 0l-3.536-3.536a.5.5 0 0 1 0-.707l3.536-3.535a.5.5 0 0 1 .707 0l3.536 3.535a.5.5 0 0 1 0 .707l-3.536 3.536ZM35.668 16.575a.5.5 0 0 1-.708 0l-3.535-3.535a.5.5 0 0 1 0-.707l3.535-3.536a.5.5 0 0 1 .708 0l3.535 3.536a.5.5 0 0 1 0 .707l-3.535 3.535Z"/></svg>`;
const darkTheme = `<svg xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-width="4" viewBox="0 0 48 48" aria-hidden="true" focusable="false"><path fill="currentColor" stroke="none" d="M42.108 29.769c.124-.387-.258-.736-.645-.613A17.99 17.99 0 0 1 36 30c-9.941 0-18-8.059-18-18 0-1.904.296-3.74.844-5.463.123-.387-.226-.768-.613-.645C10.558 8.334 5 15.518 5 24c0 10.493 8.507 19 19 19 8.482 0 15.666-5.558 18.108-13.231Z"/></svg>`;
const systemTheme = `<svg fill="none" stroke="currentColor" stroke-width="4" viewBox="0 0 48 48" width="1em" height="1em"><path d="M24 32v8m0 0h-9m9 0h9M7 32h34a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v22a1 1 0 0 0 1 1Z"></path></svg>`;

const locale = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M2 5C2 3.34315 3.34315 2 5 2H7C8.65685 2 10 3.34315 10 5V11H8V8.5H4V11H2V5ZM4 6.5H8V5C8 4.44772 7.55228 4 7 4H5C4.44772 4 4 4.44772 4 5V6.5ZM12 3.5H18C19.6569 3.5 21 4.84315 21 6.5V9H19V6.5C19 5.94772 18.5523 5.5 18 5.5H12V3.5ZM18 11.5V13H22V15H20.9381C20.7182 16.7638 19.9241 18.3492 18.7488 19.5634C19.4441 19.845 20.2041 20 21 20H22V22H21C19.5425 22 18.1765 21.6102 17.0001 20.9297C15.8234 21.6104 14.4572 22 13 22H12V20H13C13.7962 20 14.5562 19.8449 15.2514 19.5633C14.6487 18.9407 14.1463 18.2205 13.7704 17.4291L13.3413 16.5258L15.1478 15.6676L15.5769 16.5709C15.9219 17.2971 16.4081 17.9427 16.9999 18.4723C17.9921 17.5843 18.687 16.371 18.917 15H12V13H16V11.5H18ZM6 13V19C6 19.5523 6.44772 20 7 20H9.5V22H7C5.34315 22 4 20.6569 4 19V13H6Z" fill="currentColor"/>
</svg>`;

export const BUILTIN_SVGS: Record<string, string> = {
    github,
    code,
    external,
    copy,
    check,
    list,
    arrowLeft,
    arrowRight,
    angleRight,
    search,
    empty,
    stackBlitz,
    locale,
    lightTheme,
    darkTheme,
    systemTheme,
};
