---
title: Customize Site
order: 20
---

# Customize public dir
Docgeni will generate a documentation site in the `.docgeni/site` directory by default. This site is entirely an Angular project. The directory structure is as follows:
```
.docgeni
└── site
    ├── src
    │   ├── app
    │   │   └── app.module.ts
    │   ├── assets
    │   │   ├── favicon.ico
    │   │   └── images
    │   │       └── cli-init.png
    │   ├── environments
    │   │   ├── environment.prod.ts
    │   │   └── environment.ts
    │   ├── favicon.ico
    │   ├── index.html
    │   ├── main.ts
    │   ├── polyfills.ts
    │   └── styles.scss
    ├── angular.json
    ├── .browserslistrc
    ├── karma.conf.js
    └── tsconfig.app.json
```

For document sites, some configuration is often required, such as: `favicon.ico`, `assets`, `styles`, `scripts`, etc.

 In Docgeni, it does not provide many parameter configurations like other document site generation tools, but it provides a new way with flexible and powerful customization capabilities — file overwrite. Some built-in files and folders under the `publicDir` folder will be copied to the site to overwrite the default files. The default directory of `publicDir` is `.docgeni/public`. The following is a description of the customized files and folders:

- `index.html`: The entry HTML file of the site, you can modify the HTML to configure any element, such as `title`, `favicon.ico`, `heads`, `styles`,`scripts`, etc. You need to ensure that there is `<dg-root> </dg-root>` node under the body for document rendering
- `assets`: The resource files of the site can be directly accessed in the document through `assets/path/to.png` and avoid using the `content` keyword, the resource files generated by Docgeni will be stored in the `assets/content` directory
- `.browserslistrc`: Supported browsers and their versions, see [browserslist](https://github.com/browserslist/browserslist) for more configuration
- `styles.scss`: The document site uses `styles.scss` as the entry style file by default. You can overwrite `styles.scss` to write some custom styles, and need to add `@import'@docgeni/template/styles/index.scss';` to avoid that the built-in styles do not be loaded
- `tsconfig.json`: The customized TS configuration file can be overwritten to achieve a high degree of configuration. It is generally used to configure the `compilerOptions.paths`, so that we can use `import 'mylib';` in the example directly

The complete public example is as follows:
```
.docgeni/public
├── assets
│   ├── favicon.ico
│   └── images
│       └── cli-init.png
│── favicon.ico
│── .browserslistrc
├── index.html
├── styles.scss
└── tsconfig.json
```

# Custom AppModule Metadata <label>2.0+</label>
Sometimes it is necessary to import a third-party module and providers in the automatically generated `AppModule`. Docgeni allows user to define a `module.ts` under the `.docgeni/app` folder, and then customize some metadata through the`export default { imports: [], providers: [] }` syntax.

```ts
import { FormsModule } from '@angular/forms';
import { SomeService } from './some.service.ts';

export default {
    imports: [FormsModule],
    providers: [SomeService]
};

```
In this way, `SomeService` can be injected into all example components.

# Customize site
If the custom public capabilities are not enough to meet the needs of customization, Docgeni also supports a completely customize site mode, which means that the document site is created and controlled by the user.
## Step 1
An ng site can be generated through `ng g application site`, it is recommended to choose scss, and then modify the `siteProjectName:'site'` in the `.docgenirc.js` configuration file (site is the name of the Angular project, any name can be given)

## Step 2
Remove the components under `site/src/app`, modify `app.module.ts`, and enter the following code:

```ts
import { NgModule } from '@angular/core';
import { RouterModule } from '@angular/router';
import { BrowserModule } from '@angular/platform-browser';
import { DocgeniTemplateModule } from '@docgeni/template';
import { DOCGENI_SITE_PROVIDERS, RootComponent } from './content/index';

@NgModule({
    declarations: [],
    imports: [BrowserModule, DocgeniTemplateModule, RouterModule.forRoot([])],
    providers: [...DOCGENI_SITE_PROVIDERS],
    bootstrap: [RootComponent]
})
export class AppModule {
    constructor() {}
}
```
## Step 3
Docgeni will generate component and document-related code and resource files, which are stored in the `site/src/app/content` and `site/src/assets/content` folders by default. In order to avoid conflicts, you need to add these two folders to `.gitignore`, create a new `.gitignore` file under the `site/src` folder, and enter the following code:
```
app/content
assets/content
```

## Step 4
We need to modify the entry `index.html` and `styles.scss`,change the `app-root` to `dg-root`in `index.html`，import `@docgeni/template/styles/index.scss` to `style.scss`。
Note: If some typescript errors occurred when `npm run start:docs`, you may need to modify the entry `tsconfig.app.json`, add `"strict": false` to `compilerOptions`.

```html
// index.html
<!DOCTYPE html>
<html lang="zh-cn">
  <head>
    <meta charset="utf-8" />
    <title>Docgeni</title>
    <base href="/" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="assets/favicon.ico" />
  </head>
  <body>
    <dg-root></dg-root>
  </body>
</html>
```

```scss
// styles.scss
@import '@docgeni/template/styles/index.scss';
```

Finally, you can execute command `docgeni serve --port 4600` to visit the site.
