---
title: Library Configuration
path: 'lib'
order: 20
toc: menu
---

## name

- Type: `string`
- Default: `null`

The name of the component library.

## abbrName

- Type: `string`
- Default: `{name}`

The abbreviation of the component library. Angular component library generally has an abbreviation. For example, the abbreviation of [Material](https://material.angular.io/components) component library is `mat`, and the abbreviation of [NG-ZORRO](https://ng.ant.design/components/overview/en) component library is `nz`. Assuming that the abbreviation of our library is `thy`, general modules and components will use this prefix, such as: `ThyButtonModule`, `thyButton`, then Docgeni will automatically generate a unique component identification and sample code based on this abbreviation.

```html
<thy-button></thy-button>
<example name="thy-button-basic-example" />
```

## rootDir

- Type: `string`
- Default: `null`

The root path of the component library, make sure that the `package.json` of the library is in this directory. `Docgeni` will scan the folders under this configuration, all the first-level folders will be treated as a component, and the documents, APIs and examples under the component will be automatically searched. The default documents, APIs, and examples are stored in `doc`, `api` and `examples`.

## include

- Type: `string | Array<string>`
- Default: `[]`

By default, `Docgeni` will only scan the first-level folders under `rootDir` as components. If your component library is special, a certain deep folder also needs to generate component documents, which can be configured separately through include.

Such as configuration: `include:'common'`, `Docgeni` will find all first-level folders under the common folder, and match documents, APIs and examples according to the rules of the component.

> We recommend that the component library `rootDir` folder directly store the components, but the library project generated by Angular CLI will have a `src/lib` directory structure. If you want to use this directory structure, you need to configure `include: ['src','src/lib ']`, `rootDir` remains at the same level as `package.json`.

## exclude

- Type: `string | Array<string>`
- Default: `[]`

`Docgeni` will scan all folders under rootDir as components by default. If some folders are not components, you can manually set exclusions and support `glob` format.

## labels <label>1.1.0+</label>
- Type：`{[id: string]: { text: string; color: string }} | Array<LabelDef>`
- Default：`[{ id: 'new', ... }, { id: 'deprecated', ... }, { id: 'experimental', ... }]`

Labels of library configuration, default contains `new`、`deprecated` and `experimental`, you can override or customize the labels through it, and then set the corresponding ID in the component document FrontMatter, The default labels is as follows:
```json
{
  "new": { "text": "New", "color": "#73D897" },
  "deprecated": { "text": "Deprecated", "color": "#AAAAAA" },
  "experimental": { "text": "Experimental", "color": "#F6C659" }
}
```
## docDir

- Type: `string`
- Default: `doc`

The document directory of the component, `Docgeni` will look for the `{localeKey}.md` file according to the configured `locales`, which will be displayed in the overview of the component as the document of the component.
```
├── doc
│   ├── zh-cn.md
│   ├── en-us.md
```

## apiDir

- Type: `string`
- Default: `api`

In the API directory of the component, `Docgeni` will search for the `{localeKey}.suffix` file according to the configured `locales`. Currently, it supports five suffixes of `.json`, `.yaml`, `.yml`, `.js`, and `.config.js`, and three formats of `json`, `yaml`, and `js`, the following takes `js` as an example:

```js
module.exports = [
  {
    type: 'directive',
    name: 'alibButton',
    description: 'Button component, supports two forms: alibButton instruction and alib-button component', // Optional
    properties: [
        {
            name: 'alibType',
            type: 'string',
            default: 'primary',
            description: 'The type of button, support primary | info | warning | danger' 
        },
        {
            name: 'alibSize',
            type: 'string',
            default: 'null', 
            description: 'The size of the button, support sm | md | lg'
        }
    ]
  }
];

```
To automatically generate API, please configure [apiMode](/configuration/lib#apimode-<label>1-2-0+</label>)。


## examplesDir

- Type: `string`
- Default: `examples`

Component example root directory, `Docgeni` will treat each first-level folder in this directory as an example.
```
├── examples
│   ├── basic
│   │   ├── basic.component.html
│   │   ├── basic.component.scss
│   │   └── basic.component.ts
│   ├── advance
│   │   ├── advance.component.html
│   │   ├── advance.component.scss
│   │   └── advance.component.ts
```

## categories

- Type: `Array<Category>`
- Default: `null`

Component category, `Docgeni` will put the components of the same category together in the left menu, which is convenient for unified management and viewing. Contains the `id`, `title`, and `locales` attributes. `id` is the unique identifier of the current category. The component overview document will use FrontMatter named `category` for configuration, and `title` is the title of the category.
```json
[
    {
        "name": "alib",
        "rootDir": "./packages/a-lib",
        "categories": [
            {
                "id": "general",
                "title": "general",
                "locales": {
                    "en-us": {
                        "title": "General"
                    }
                }
            },
            {
                "id": "layout",
                "title": "layout",
                "locales": {
                    "en-us": {
                        "title": "Layout"
                    }
                }
            }
        ]
    }
]
```

## apiMode <label>2.0+</label>

- Type: `'compatible' | 'manual' | 'automatic'`
- Default: `manual`

Component API generation mode:
- `manual`: Manual mode, defining component API in the json of configuration file, default mode
- `automatic`: Automatic generation mode, the API is automatically generated through the comments of the component, directive and service
- `compatible`: Compatibility mode. when there is [API configuration file](configuration/lib#apidir) takes precedence. otherwise, it is automatically generated through comments
