Ddoc

$(DIV_CLASS preface,

$(DERS_BOLUMU_CLASS preface, Preface)

$(P
D is a multi-paradigm system programming language that combines a wide range of powerful programming concepts from the lowest to the highest levels. It emphasizes memory safety, program correctness, and pragmatism.
)

$(P
The main aim of this book is to teach D to readers who are new to computer programming. Although having experience in other programming languages is certainly helpful, this book starts from the basics.
)

$(P
In order for this book to be useful, you will need an environment to write, compile, and run your D programs. This $(I development environment) must include at least a D compiler and a text editor. We will learn how to install a compiler and how to compile programs in the next chapter.
)

$(P
Each chapter is based on the contents of the previous ones, introducing as few new concepts as possible. I recommend that you read the book in linear fashion, without skipping chapters. Although this book was written with beginners in mind, it covers almost all features of D. More experienced programmers can use the book as a D language reference by starting from the index section.
)

$(P
Some chapters include exercises and their solutions so that you can write small programs and compare your methods to mine.
)

$(P
Computer programming is a satisfying craft that involves continuously discovering and learning new tools, techniques, and concepts. I am sure you will enjoy programming in D at least as much as I do. Learning to program is easier and more fun when shared with others. Take advantage of $(LINK2 http://forum.dlang.org/group/digitalmars.D.learn/, the D.learn newsgroup) to follow discussions and to ask and answer questions.
)

$(P
This book is available in $(LINK2 http://ddili.org/ders/d/, Turkish) as well.
)

$(H5_FRONTMATTER Acknowledgments)

$(P
I am indebted to the following people who have been instrumental during the evolution of this book:
)

$(P
Mert Ataol, Zafer Çelenk, Salih Dinçer, Can Alpay Çiftçi, Faruk Erdem Öncel, Muhammet Aydın (aka Mengü Kağan), Ergin Güney, Jordi Sayol, David Herberth, Andre Tampubolon, Gour-Gadadhara Dasa, Raphaël Jakse, Andrej Mitrović, Johannes Pfau, Jerome Sniatecki, Jason Adams, Ali H. Çalışkan, Paul Jurczak, Brian Rogoff, Михаил Страшун (Mihails Strasuns), Joseph Rushton Wakeling, Tove, Hugo Florentino, Satya Pothamsetti, Luís Marques, Christoph Wendler, Daniel Nielsen, Ketmar Dark, Pavel Lukin, Jonas Fiala, Norman Hardy, Rich Morin, Douglas Foster, Paul Robinson, Sean Garratt, Stéphane Goujet, Shammah Chancellor, Steven Schveighoffer, Robbin Carlson, Bubnenkov Dmitry Ivanovich, Bastiaan Veelo, Olivier Pisano, Dave Yost, Tomasz Miazek-Mioduszewski, Gerard Vreeswijk, Justin Whear, Gerald Jansen, Sylvain Gault, Shriramana Sharma, Jay Norwood, Henri Menke, Chen Lejia, Vladimir Panteleev, Martin Tschierschke, ag0aep6g, Andrew Edwards, Steve White, Mark Schwarzmann, Thibaut Charles, Richard Palme, Don Grant, Goksan Kadir, Aleksandr Treyger, Michael Siegel, and Quirin Schroll.
)

$(P
Thanks especially to Luís Marques and Steven Schveighoffer who, through their hard work, improved every chapter of the book. If you find any part of this book useful, it is likely due to their diligent editing.
)

$(P
Thanks to Luís Marques, Steven Schveighoffer, Andrej Mitrović, Robbin Carlson, Ergin Güney, and Andrew Edwards for their suggestions that elevated this book from my Inglish to English.
)

$(P
I am grateful to the entire D community for keeping my enthusiasm and motivation high. D has an amazing community of tireless individuals like bearophile and Kenji Hara.
)

$(P
Ebru, Damla, and Derin, thank you for being so patient and supportive while I was lost writing these chapters.
$(BR)
$(BR)
Ali Çehreli$(BR)
Mountain View, $(I May 2017)
)

$(P
$(BR)
$(BR)
This revision of the book contains many $(LINK2 https://bitbucket.org/acehreli/ddili/commits/all, corrections, improvements), and a new chapter: $(LINK2 static_foreach.html, $(C static foreach)).
$(BR)
$(BR)
Ali Çehreli$(BR)
Mountain View, $(I February 2019)
)

)

Macros:
    TITLE= Preface
    DESCRIPTION=
    KEYWORDS=
