Ddoc

$(DIV_CLASS foreword,

$(DERS_BOLUMU_CLASS foreword, Foreword<span class="foreword_by"> by Andrei Alexandrescu</span>)

$(P
Those of us who know Ali might notice his book on D is imbued with its author's personality: straightforward, patient, and nice without being pandering.
)

$(P
There is purpose in every sentence, and with each, a step forward is being made; not too fast, and not too slow. "Note that $(C opApply()) itself is implemented by a $(C foreach) loop. As a result, the $(C foreach) inside $(C main()) ends up making indirect use of a $(C foreach) over the $(C points) member." And so it goes, in just as many words as needed. And in the right order, too; Ali does an admirable job at presenting language concepts – which especially to a beginner overwhelmingly come "in parallel" – in a sequential manner.
)

$(P
But there's another thing I like most about "Programming in D": it's a good book for learning programming $(I in general). See, a good introductory book on Haskell implicitly teaches functional programming along the way; one on C would come with systems programming notions in tow; one on Python with scripting, and so on. What would, then, a good introductory text to D teach in subtext? At best, Programming with a capital P.
)

$(P
D fosters a "use the right tool for the job" attitude, and allows its user to tap into a wide range of programming techniques, without throwing too many idiosyncrasies in the way. The most fun way to approach coding in D is with an open mind, because for each design that starts to get stilted there is opportunity to mold it into the right design choosing a different implementation, approach, or paradigm altogether. To best choose what's most fitting, the engineer must know the gamut of what's possible – and "Programming in D" is a great way to equip one's intellect with that knowledge. Internalizing it helps not only writing good code in D, but writing good code, period.
)

$(P
There's good tactical advice, too, to complement the teaching of programming and language concepts. Timeless teaching on avoiding code duplication, choosing good names, aiming for good decomposition, and more – it's all there, quick-and-dirty hacks iteratively annealed into robust solutions, just as they should in normal practice. Instead of falling for getting things done quickly, "Programming in D" focuses on getting things done properly, to the lasting benefit of its reader.
)

$(P
I've long suspected D is a good first programming language to learn. It exposes its user to a variety of concepts – systems, functional, object oriented, generic, generative – candidly and without pretense. And so does Ali's book, which seems to me an excellent realization of that opportunity.
$(BR)
$(BR)
Andrei Alexandrescu$(BR)
San Francisco, $(I May 2015)
)

)

Macros:
    TITLE= Foreword by Andrei Alexandrescu
    DESCRIPTION=
    KEYWORDS=
