
#include "HT_SSD1306Wire.h"
#include "display.h"

extern SSD1306Wire            display;    // Defined in LoRaWan_APP.cpp

// cppcheck-suppress unusedFunction
void setup_display() {
  display.init();
  //displayLogoAndMsg("Tracker", 1000);
  //digitalWrite(Vext,LOW);
}

void sleep_display() {
  display.sleep();
}

void wakeup_display() {
  display.wakeup();
}

void stop_display() {
  display.stop();
}



void displayLogoAndMsg(String msg, uint32_t wait_ms)
{
  const uint8_t lora_logo_bmp[] PROGMEM = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x7f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf8, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x0f, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x80,
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x8e, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xfb,
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x3f, 0xf0, 0xff, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0xff,
    0xf8, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0f, 0x60, 0xe0, 0xf8, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0xf8, 0xff, 0x03, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x3f,
    0xf8, 0xe0, 0xc7, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0f, 0xc0, 0xff, 0xf8, 0xc1, 0xe7, 0x7f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0xff, 0xf9, 0xe1, 0xe7, 0x7f,
    0x00, 0x30, 0xf8, 0xc7, 0x3f, 0xf0, 0x01, 0x00, 0x00, 0x0f, 0xf0, 0xf3,
    0xf9, 0xf1, 0xf3, 0xf9, 0x00, 0x38, 0xf8, 0xcf, 0x7f, 0xf8, 0x03, 0x00,
    0x00, 0x0f, 0xf0, 0xe1, 0xf9, 0xff, 0xf3, 0xf8, 0x00, 0x3c, 0x18, 0xcc,
    0x60, 0x0c, 0x03, 0x00, 0x00, 0x0f, 0xf0, 0xe0, 0xfb, 0xff, 0x81, 0xff,
    0x00, 0x3c, 0x18, 0xcc, 0x60, 0x0c, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0xc0,
    0xfb, 0xff, 0xe0, 0xff, 0x00, 0x6e, 0x18, 0xce, 0x70, 0x1c, 0x00, 0x00,
    0x00, 0x0f, 0xf0, 0xe0, 0xfb, 0xff, 0xf0, 0xff, 0x00, 0x66, 0xfc, 0xe7,
    0x3f, 0xf8, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0xe1, 0xfb, 0xf8, 0xf1, 0xf9,
    0x00, 0x63, 0xfc, 0xe3, 0x1f, 0xe0, 0x03, 0x00, 0x00, 0xff, 0xf7, 0xf1,
    0xf9, 0xf1, 0xf1, 0xf8, 0x00, 0x7f, 0x0c, 0x60, 0x0c, 0x00, 0x03, 0x00,
    0x00, 0xff, 0xf7, 0xff, 0xf9, 0xf1, 0xf3, 0xff, 0x80, 0xff, 0x0c, 0x60,
    0x0c, 0x07, 0x03, 0x00, 0x00, 0xff, 0xe7, 0xff, 0xf8, 0xe1, 0xf3, 0xff,
    0xc0, 0xc1, 0x0c, 0x60, 0x18, 0x86, 0x03, 0x00, 0x00, 0xff, 0xc7, 0x7f,
    0xf8, 0xe1, 0xe7, 0xff, 0xc0, 0xc0, 0x0c, 0x60, 0x38, 0xfe, 0x01, 0x00,
    0x00, 0xff, 0x07, 0x1f, 0xf0, 0xc0, 0xc7, 0xf3, 0x60, 0xc0, 0x06, 0x30,
    0x30, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xf3,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc0, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x1f, 0x02, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x80,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf8, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x04,
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xc0, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0x07, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff,
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };

  display.clear();
  display.drawXbm(0, 0, 128, 41, lora_logo_bmp);
  //displayBatteryLevel();
  display.setTextAlignment(TEXT_ALIGN_CENTER);
  display.setFont(ArialMT_Plain_16);
  display.drawString(64, 54-16/2, msg);
  #ifdef DEBUG
  Serial.println(msg);
  #endif
  display.display();

  if (wait_ms)
  {
    delay(wait_ms);
  }    
}

// cppcheck-suppress unusedFunction
void show_display(String header, int wait) {
  display.clear();
  display.setFont(ArialMT_Plain_16);
  display.setTextAlignment(TEXT_ALIGN_LEFT);
  //display.setCursor(0, 0);
  display.println(header);
  //display.ssd1306_command(SSD1306_SETCONTRAST);
  //display.ssd1306_command(1);
  display.display();
  delay(wait);
}

// cppcheck-suppress unusedFunction
void show_display(String header, String line1, int wait) {
  display.clear();
  display.setFont(ArialMT_Plain_16);
  display.setTextAlignment(TEXT_ALIGN_LEFT);
  display.drawString(0,0,header);
  display.setFont(ArialMT_Plain_10);
  display.drawString(0,14,line1);
  display.display();
  delay(wait);
}

// cppcheck-suppress unusedFunction
void show_display(String header, String line1, String line2, int wait) {
  display.clear();
  display.setFont(ArialMT_Plain_16);
  display.setTextAlignment(TEXT_ALIGN_LEFT);
  //display.setCursor(0, 0);
  display.drawString(0,0,header);
  display.setFont(ArialMT_Plain_10);
  //display.setCursor(0, 16);
  display.drawString(0,14,line1);
  //display.setCursor(0, 26);
  display.drawString(0,24,line2);
  //display.ssd1306_command(SSD1306_SETCONTRAST);
  //display.ssd1306_command(1);
  display.display();
  delay(wait);
}

// cppcheck-suppress unusedFunction
void show_display(String header, String line1, String line2, String line3, int wait) {
  display.clear();
  display.setFont(ArialMT_Plain_16);
  display.setTextAlignment(TEXT_ALIGN_LEFT);
  //display.setCursor(0, 0);
  display.drawString(0,0,header);
  display.setFont(ArialMT_Plain_10);
  //display.setCursor(0, 16);
  display.drawString(0,14,line1);
  //display.setCursor(0, 26);
  display.drawString(0,24,line2);
  //display.setCursor(0, 36);
  display.drawString(0,34,line3);

  display.display();
  delay(wait);
}

// cppcheck-suppress unusedFunction
void show_display(String header, String line1, String line2, String line3, String line4, int wait) {
  display.clear();
  display.setFont(ArialMT_Plain_16);
    display.setTextAlignment(TEXT_ALIGN_LEFT);
  //display.setCursor(0, 0);
  display.drawString(0,0,header);
  display.setFont(ArialMT_Plain_10);
  //display.setCursor(0, 16);
  display.drawString(0,14,line1);
  //display.setCursor(0, 26);
  display.drawString(0,24,line2);
  //display.setCursor(0, 36);
  display.drawString(0,34,line3);
  //display.setCursor(0, 46);
  display.drawString(0,44,line4);

  display.display();
  delay(wait);
}

// cppcheck-suppress unusedFunction
void show_display(String header, bool isTxing, String line1, String line2, String line3, String line4, String line5, int wait) {

  const uint8_t send_icon_bmp[] PROGMEM = {
    0xf8, 0xff, 0x0c, 0xc0, 0x14, 0xe0, 0x64, 0x98, 0xc7, 0x8c, 0x04, 0x83,
    0x04, 0x80, 0x1e, 0x80, 0x04, 0x80, 0xf8, 0x7f 
  };

  display.clear();

  if (isTxing){
    display.drawXbm(112, 0, 16, 10, send_icon_bmp);
  }

  display.setFont(ArialMT_Plain_16);
  display.setTextAlignment(TEXT_ALIGN_LEFT);
  display.drawString(0,0,header);
  display.setFont(ArialMT_Plain_10);
  display.drawString(0,14,line1);
  display.drawString(0,24,line2);
  display.drawString(0,34,line3);
  display.drawString(0,44,line4);
  display.drawString(0,54,line5);

  display.display();
  delay(wait);
}

// cppcheck-suppress unusedFunction
void show_display_menu(String header, String line1, String line2, String line3, String line4, int wait) {
  display.clear();
  display.setFont(ArialMT_Plain_16);
  display.setTextAlignment(TEXT_ALIGN_LEFT);
  display.drawString(0,0,header);
  display.setFont(ArialMT_Plain_10);
  display.drawString(0,14,line1);
  display.setFont(ArialMT_Plain_16);
  display.drawString(0,20,line2);
  display.setFont(ArialMT_Plain_10);
  display.drawString(0,40,line3);
  display.setFont(ArialMT_Plain_10);
  display.drawString(0,50,line4);
  display.display();
  delay(wait);
}