export const Privacy = () => (
	<main className="container mt-4">
		<div className="row justify-content-center">
			<section className="col-md-10 col-lg-6">
				<h1>Privacy Policy</h1>
				<p>
					This privacy policy will explain how our organization uses the
					identifying data and group needs we collect from you when you partake
					in our needs assessments .
				</p>
				<h3>Topics:</h3>
				<ul>
					<li>What data do we collect?</li>
					<li>How do we collect your data?</li>
					<li>How will we use your data?</li>
					<li>How do we store your data?</li>
					<li>Marketing</li>
					<li>What are your data protection rights? </li>
					<li>What are cookies?</li>
					<li>How do we use cookies?</li>
					<li>How to manage your cookies</li>
					<li>Privacy policies of other websites</li>
					<li>Changes to our privacy policy</li>
					<li>How to contact us</li>
					<li>How to contact the appropriate authorities </li>
				</ul>
				<h2 className="mt-4">What data do we collect?</h2>
				<p>Distribute Aid collects the following data:</p>
				<ul>
					<li>
						Distribute Aid only collects the data you choose to provide when
						filling out the Needs Assessment form.
					</li>
				</ul>
				<ul>
					<li>
						This includes information such as your email address, organisation
						name, the region you operate in, location (as you choose to share
						it), size and type of storage space, and information about your
						services and needs as you choose to share it.
					</li>
				</ul>
				<ul>
					<li>
						Distribute Aid does not collect any data from its form or website
						visitors through cookies.
					</li>
				</ul>
				<h2 className="mt-4">How do we collect your data?</h2>
				<p>
					You directly provide Distribute Aid with all of the data we collect.
					We collect data and process data when you:
				</p>
				<ul>
					<li>
						Voluntarily fill out a needs assessment form in part or in full.
					</li>
					<li>
						Voluntarily provide us with information through other means such as
						WhatsApp and email, related to your group’s needs.
					</li>
				</ul>
				<h2 className="mt-4">How will we use your data?</h2>
				<p>
					The goal of this project is to make the best possible aid available
					for people who access your services. The results from this survey will
					allow Distribute Aid to understand your region’s and organisation’s
					needs over the next three months so that we can advise collection
					groups on what to collect, figure out which targeted campaigns to run,
					and decide who to reach out to for in-kind donations. In short, this
					assessment helps make sure the aid you receive is better suited to
					your needs.
				</p>
				<p>
					If you agree, Distribute Aid will share your data with our other
					partner groups so you can organise collaboration where relevant. For
					example, where your needs and another group’s overstock or new
					incoming donations align so an aid exchange would be beneficial for
					both parties. We will always contact you and ask for permission in
					each circumstance before sharing any identifying information.
				</p>
				<p>
					Distribute Aid will also use the data provided to update our Customer
					Relationship Management System (CRM) data, which is hosted by Notion.
					This information will then be used to contact you (email address), and
					for the purpose of planning donations of aid (e.g. your storage
					space).
				</p>
				<p>
					You are under no statutory or contractual requirement or obligation to
					provide Distribute Aid with personal data and there are no possible
					legal consequences of failing to provide your personal data.
				</p>
				<h2 className="mt-4">How do we store your data?</h2>
				<p>
					Distribute Aid securely stores your data in Clever Cloud, Google Suite
					(Gmail, Sheets, Docs), Prezi, Qualtrics, Notion, and Contentful.
					Access to these platforms is only available to relevant Distribute Aid
					volunteers who have signed an agreement in line with our privacy
					terms. This access is granted through a two-ste p authentication
					password management system.
				</p>
				<p>
					Distribute Aid will keep your identifying data (any data that would
					link your responses to your group) for a period of 24 months . Once
					this time period has expired, we will delete your data by deleting the
					form submissions containing any personal data in the survey tools (G
					oogle services , Q ualtrics) and removing your compiled responses from
					our google sheets and Notion pages.
				</p>
				<p>
					Distribute Aid will keep regional data containing information about
					overall trends in needs (without being able to link that information
					to a particular group’s responses) indefinitely unless asked to delete
					it within 24 months of providing the data.
				</p>
				<h2 className="mt-4">Marketing</h2>
				<p>
					Distribute Aid will not use any of your information for marketing
					purposes. Nor will we share it with partner companies for marketing
					purposes.
				</p>
				<h2 className="mt-4">What are your data protection rights?</h2>
				<p>
					Distribute Aid would like to make sure you are fully aware of all of
					your data protection rights. Every user is entitled to the following:
				</p>
				<p>
					<strong>The right to access</strong> - You have the right to request
					Distribute Aid for copies of your personal data. We will not charge
					you a fee for this service.
				</p>
				<p>
					<strong>The right to rectification</strong> - You have the right to
					request that Distribute Aid correct any information you believe is
					inaccurate. You also have the right to request Distribute Aid to
					complete information you believe is incomplete.
				</p>
				<p>
					<strong>The right to erasure</strong> - You have the right to request
					that Distribute Aid erase your personal data.
				</p>
				<p>
					<strong>The right to restrict processing</strong> - You have the right
					to request that Distribute Aid restrict the processing of your
					personal data, under certain conditions.
				</p>
				<p>
					<strong>The right to object to processing</strong> - You have the
					right to object to Distribute Aid 's processing of your personal data.
				</p>
				<p>
					<strong>The right to data portability</strong> - You have the right to
					request that Distribute Aid transfer the data that we have collected
					to another organization, or directly to you, under certain conditions.
				</p>
				<p>If you make a request, we have one month to respond to you.</p>
				<p>
					If <strong>you would like to exercise any of these rights</strong>,
					please contact by:
				</p>
				<ul>
					<li>
						Email:{' '}
						<a href="mailto:hello@distributeaid.org">hello@distributeaid.org</a>
					</li>
					<li>
						Call us at: <a href="tel:+15104732754">+1 (510) 473-2754</a>
					</li>
					<li>Or write to us: Stora Södergatan 43C, 22223, Lund, Sweden</li>
				</ul>

				<p>
					If you would like to get in touch with our Data Protection Officer
					directly, you can email Sara Lonegard at{' '}
					<a href="mailto:sara@distributeaid.org">sara@distributeaid.org</a>.
				</p>
				<h2 className="mt-4">What are cookies?</h2>
				<p>
					Cookies are text files placed on your computer to collect standard
					Internet log information and visitor behaviour information. When you
					visit any third party host website, they may collect information from
					you automatically through cookies or similar technology.
				</p>
				<p>
					For further information, visit{' '}
					<a href="https://www.google.com/url?q=https://www.allaboutcookies.org/&amp;sa=D&amp;source=editors&amp;ust=1644276624810178&amp;usg=AOvVaw37ES89XvlrWPzpft2IZ9tM">
						allaboutcookies.org
					</a>
					.
				</p>
				<h2 className="mt-4">How do we use cookies?</h2>
				<p>
					Distribute Aid does not store or access any of the information
					obtained through cookies on our websites.
				</p>
				<h2 className="mt-4">How to manage cookies</h2>
				<p>
					You can set your browser not to accept cookies, and the above website
					tells you how to remove cookies from your browser. However, in a few
					cases, some website features may not function as a result.
				</p>
				<h2 className="mt-4">Privacy policies of other websites</h2>
				<p>
					The Distribute Aid website contains links to other websites. Our
					privacy policy applies only to our website, so if you click on a link
					to another website, you should read their privacy policy.
				</p>
				<h2 className="mt-4">Changes to our privacy policy</h2>
				<p>
					Distribute Aid keeps its privacy policy under regular review. This
					privacy policy was last updated on 15 September 2021 . If you would
					like to be informed of any updates to this pri vacy policy, get in
					touch with us through hello@distributeaid.org
				</p>
				<h2 className="mt-4">How to contact us</h2>
				<p>
					If you have any questions about Distribute Aid 's privacy policy, the
					data we hold on you, or you would like to exercise one of your data
					protection rights, please do not hesitate to contact us.
				</p>
				<ul>
					<li>
						Email:{' '}
						<a href="mailto:hello@distributeaid.org">hello@distributeaid.org</a>
					</li>
					<li>
						Call us at: <a href="tel:+15104732754">+1 (510) 473-2754</a>
					</li>
					<li>Or write to us: Stora Södergatan 43C, 22223, Lund, Sweden</li>
				</ul>
				<p>
					If you would like to get in touch with our Data Protection Officer
					directly, you can email Sara Lonegard at{' '}
					<a href="mailto:sara@distributeaid.org">sara@distributeaid.org</a>.
				</p>
				<h2 className="mt-4">How to contact the appropriate authority</h2>
				<p>
					Should you wish to report a complaint or if you feel that Distribute
					Aid has not addressed your concern in a satisfactory manner, y ou may
					contact the relevant data protection authority:
				</p>
				<h3>For UK citizens</h3>
				<p>
					Information Commissioner’s Office
					<br />
					Wycliffe House
					<br />
					Water Lane
					<br />
					Wilmslow
					<br />
					Cheshire
					<br />
					SK9 5AF
				</p>
				<h3>For EU citizens</h3>
				<p>
					Please see your respective country office{' '}
					<a href="https://www.google.com/url?q=https://edpb.europa.eu/about-edpb/about-edpb/members_en%23member-uk&amp;sa=D&amp;source=editors&amp;ust=1644276624813513&amp;usg=AOvVaw0lNXn76c4hz-BFV4-8u94H">
						here
					</a>
					.
				</p>
			</section>
		</div>
	</main>
)
