---
uid: Guides.Introduction
title: Introduction to Discord.Net
---

# Introduction

## Looking to get started?

Welcome! Before you dive into this library, however, you should have
some decent understanding of the language
you are about to use. This library touches on
[Task-based Asynchronous Pattern] \(TAP), [polymorphism], [interface]
and many more advanced topics extensively. Please make sure that you
understand these topics to some extent before proceeding. With all
that being said, feel free to visit us on Discord at the link below
if you have any questions!

An official collection of samples can be found
in [our GitHub repository].

> [!NOTE]
> Please note that you should *not* try to blindly copy paste
> the code. The examples are meant to be a template or a guide.

[our GitHub repository]: https://github.com/discord-net/Discord.Net/
[Task-based Asynchronous Pattern]: https://docs.microsoft.com/en-us/dotnet/standard/asynchronous-programming-patterns/task-based-asynchronous-pattern-tap
[polymorphism]: https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/polymorphism
[interface]: https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/interfaces/

## New to .NET?

All examples or snippets featured in this guide and all API
documentation will be written in C#.

If you are new to the language, using this wrapper may prove to be
difficult, but don't worry! There are many resources online that can
help you get started in the wonderful world of .NET. Here are some
resources to get you started.

- [C# Programming Guide](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/) (Microsoft, Free)
- [Learn .NET](https://dotnet.microsoft.com/en-us/learn) (Microsoft, Free)
- [C# Path](https://www.pluralsight.com/paths/csharp) (Pluralsight, Paid)

## Still have questions?

Please visit us at our [Discord](https://discord.gg/dnet) server.
Describe the problem in details to us, what you've tried and what you need help with.
