# DingoDB v0.9.0版本特性说明

## 1、新增特性

### 1）License管理机制
提供了 License 管理功能，保障 DingoDB 的知识产权。通过 License 激活和管理工具，用户可以方便地管理和监控软件的使用情况，确保合法合规使用。
### 2）单机Lite版DingoDB
实现了单机 Lite 版 DingoDB，降低用户的使用门槛。该版本无需复杂的分布式部署，即可在单台机器上运行，适用于开发测试和小规模应用场景，帮助用户快速上手和验证 DingoDB 的功能。
### 3）新增C++SDK
提供了新的 C++ SDK，方便开发者进行二次开发和集成。提供了丰富的 API 接口，支持高效的数据操作和管理，提升开发效率。

## 2、优化特性

### 2.1 存储层优化

#### 1）Braft改造
支持 peer 之间的选举优先级控制，解决向量索引 Leader 均衡问题。有助于提高集群的稳定性和性能，避免单点过载。
#### 2）Prefilter性能的提升
调整 ScalarData 的数据结构，提升前置过滤速率。通过优化数据结构，DingoDB 能够更快地处理数据过滤，减少查询延迟。
#### 3）指令集扩展
在向量距离计算函数 FAISS 和 HNSWLIB 默认的 SSE 指令基础上，新增支持 AVX2/AVX512 指令集。通过扩展指令集，提高了向量计算的效率，特别是在高性能计算环境中效果显著。
#### 4）向量距离计算性能的提升
实现运行时的 CPU 指令集加速切换，显著提升向量距离计算性能。根据需要自动切换指令集（如 SSE、AVX2、AVX512），特别是在处理大规模数据集时效果显著。
#### 5）Leader均衡率提升
通过优化算法，提升 Leader 在集群中的均衡率。改进的选举算法确保 Leader 的分布更加均衡，增强了系统的整体性能。
#### 6）向量索引数据插入性能的提升
优化 IVF_FLAT 和 IVF_PQ 向量索引的插入性能。改进的插入算法提高了数据插入的效率，缩短了索引构建时间。
#### 7）同步操作性能优化
优化 BThread 和 PThread 的同步操作性能。通过减少线程同步的开销，提升了多线程环境下的性能表现。
#### 8）向量Search性能提升
调整 Region 大小、Region 数量及线程数等参数，有效提升向量 Search 性能。优化系统资源配置，提升搜索的响应速度和效率。

### 2.2 计算层优化
#### 1）日志系统优化
改造 Executor 层日志系统，提供全链路日志信息，提升日志可追溯性。改进后的日志系统记录更加详细，帮助用户全面监控和分析任务执行过程中的各类事件。
#### 2）可观测Metric
新增Metric 信息统计功能，监测作业在各个阶段的 Metric 信息，提升任务的可观测性。通过实时监测性能指标，用户可以更好地了解任务执行情况和性能瓶颈，提升系统的运维效率。