# DingoDB v0.8.0版本特性说明

## 1. 新增特性
### 1.1 分布式事务

新增分布式事务能力满足数据库ACID核心特性，保证数据库的完整性和可靠性，拓展更多应用场景。 

* Store层/Index层/Executor层添加事务相关接口；
* 提供分布式事务数据的Garbage Collection的能力，清理已经完成且不在需要的事务数据，释放存储空间，减少存储空间占用。
* 事务表创建，建表时指定ENGINE=LSM_TXN完成创建；
* 事务表的提交方式：
    * 显示提交：使用Commit命令完成提交；
    * 隐式提交：使用SQL命令（BEGIN、START TRANSCATION等）间接完成提交；
    * 自动提交：INSERT/UPDATE/DELETE执行后，系统自动完成提交；
* 三种事务隔离级别：Read Committed、Repeatable Read；
* 两种事务模式：乐观事务（Optimistic）、悲观事务（Pessimistic）；
* 事务锁机制：提供表锁、行锁两个级别锁管理，通过对表/行进行锁定，保障事务的一致性和隔离性，有效避免并发事务之间的数据冲突；
* 死锁检测机制 ：支持周期性检查系统中的锁资源和等待关系，用于识别潜在的死锁情况；
### 1.2 计算下推
* 重构计算下推，优化代码执行逻辑，提高数据查询性能；
* 支持表达式计算下推，处理带有表达式语法执行，提高计算效率；
* 支持Vector ScalarData算子下推：执行向量近似最近邻搜索时，对标量数据进行过滤操作，帮助进一步筛选满足特定条件的数据；
* PythonSDK新增Self Query特性，提供对向量数据Scalar Data的Filter能力，满足特定查询向量数据场景。

## 2. 优化特性
### 2.1 数据存储层
#### 1）架构优化
* 增加对google::protobuf::Closure的封装，方便对请求进行统计与日志追踪；
* 重构RawRocksEngine类，通过按照功能拆分多个文件，并支持多列族的模式，解决当前RawRocksEngine冗余的问题；
* 重构StoreService/IndexService模块，统一运行对列内外的逻辑；
* 重构Storage类，将执行对列逻辑抽离出，放在流量控制模块，优化代码结构，提高代码质量，方便未来代码维护。
#### 2）Region管理
* 优化Region分裂策略，在原有分裂策略上新增Region向后分裂；
* Store层/Coordinator层新增Region的Merge功能，实现数据的动态调整，优化存储空间的利用率；
* 支持多CF模式下的Split，在扩展性、性能及可靠性方面有极大的提升；同时采用统一的编码格式，兼容分布式事务的key编码格式；
#### 3）向量索引
* 基于检索速度，新增IVF_FLAT基于倒排索引的向量索引方法，用于高维稀疏向量数据，提供较快的检索速度和较好的检索效果；
* 基于内存，新增IVF_PQ基于倒排索引和乘积量化的向量索引方法，用于高维稠密向量数据，具有较好的搜索速度和较低的存储开销； 
* 基于精度，新增BruteForce索引，用于小规模的向量数据集或搜索精度要求高的场景；
#### 4）存储引擎
* 新增B+Tree引擎，优化数据库查询性能；
* 新增XDP引擎，实现高性能数据处理；
* 存储引擎多样化支持用户根据实际业务需求指定具体的存储引擎；
#### 5）快照能力升级
* VectorIndex升级为多CF存储；
* 快照支持多CF存储模式，并兼容分布式事务的key编码格式；
* 实现Fake Snapshot降低快照的I/O负担；
* 轻量级save / load snapshot，能够方便地存储和恢复系统的状态，支持状态共享和迁移，有效存储临时数据，增强了数据的可靠性和灵活性。
### 2.2 Executor执行层
#### 1）数据类型
* 新增Blob数据类型，用于存储二进制数据，例如：图像、音频、视频等；
#### 2）SQL语法
* SQL层提供批量数据的导入导出；
* 提供向量距离计算函数：
    * 内积距离：ipDistance；
    * 欧几里得距离：l2Distance；
    * 余弦距离：cosineDistance；
* 支持非函数的向量查询，无向量索引时也可以进行向量查询；
* Table表支持中文创建表/插入/查询/更新/删除；
* 分布式事务相关参数：
    * 支持不同级别的事务参数设置：Global/Session；
    * 超时设置，支持设置重试或阻塞的超时时间，时间超时后自动回滚：
```sql
Lock_wait_timeout;
Set [session | global] statement_timeout = timeout;
```
#### 3）重构
* 基于版本新增特性分布式事务对原有Store/Task/Job/Calcite/Client等模块改造；
* 将Client端与SQL执行层进行整合，优化系统架构，减少代码冗余；
### 2.3 SDK层
* 新增C++ SDK，基于C++ SDK实现Dingo-store独立的集成测试执行；
### 2.4 运维监控
* 可视化Web监控界面，实时监控Store、Executor、Coordinator各个组件的健康状态，提供整个集群粒度的监控信息；