# DingoDB简介

## 1、产品介绍
  DingoDB（Data In And Go Processing DataBase）是一款开源的分布式多模态向量数据库，融合了数据湖和向量数据库的特点，为存储和分析多种数据模型提供了可靠的基础保障。旨在满足现代应用中对多种类型数据存储、检索和分析的需求，并结合分布式和实时的数据库技术，提供高效、可靠的多模态数据管理和处理能力。DingoDB专注于提供高效、可靠的多模态数据存储和处理解决方案，广泛适用于风险预测、智能客服、智能推荐、智能助手等领域，帮助用户从多模态数据中发现有价值的信息和洞察。

## 2、产品特性
**1）支持结构化和非结构化混合分析**

提供结构化和非结构化索引混合检索能力，能够同时处理和分析结构化和与非结构化数据，并将其进行整合和综合分析，从而获取更全面、准确的分析结果。为用户提供更广阔的数据视角和更深入的洞察，帮助其做出更准确、更有价值的决策和预测。

**2）一体化SQL计算引擎**
* 兼容Mysql原生语义

DingoDB是以兼容MySQL原生语义为设计准则的数据库系统。它能够准确执行MySQL的语法，并支持连接数据库等常见操作，使用户能够轻松上手使用。这种兼容性大大降低了用户的学习成本和迁移难度。
* 内置Embedding函数

内置Embedding函数为用户提供了一种便捷而高效的方式，允许用户将文本和图像数据转换为向量表示，并在数据库中进行灵活的相似性搜索和分析，从而实现对大规模文本和图像数据的快速分析和检索。

**3）可靠的数据存储**
* 多副本存储策略

DingoDB提供多副本存储策略，以确保在分布式环境中的高可用性，为企业提供可靠的存储解决方案。能够帮助其有效应对数据的高可用性和可靠性需求，减少数据丢失的风险，并提供持续可用的存储解决方案。
* 海量扩展能力

DingoDB基于用户数据规模提供海量扩展能力。DingoDB既可以容纳大规模的数据集，并且具备可扩展性，确保有足够的存储空间可供使用。同时，也具备弹性的资源管理机制，能够根据需要快速调整资源分配，适应不断变化的需求，为您提供可靠、高效的存储解决方案。
* 分布式事务

实现Percolator基于乐观事务的分布式事务处理系统，从而保证数据操作的正确性和完整性，提高系统的可用性和容错性，同时支持大规模数据处理和高并发访问，为用户提供稳定、高效的数据管理和查询服务。

**4）开源开放的生态，对接大模型工具链**

DingoDB本身采用开源的运营模式，同时积极与开源社区互动，不断提升和完善数据库系统的功能性。目前，DingoDB已成功对接大模型工具链，为大模型提供海量记忆体的能力，确保大模型生成结果的准确性和可靠性。这也使得DingoDB能够更好地集成与其他开源工具和技术的协同工作，为用户提供更优质的数据能力。

**5）完善的工具链生态**

* 生产级监控

提供实时的系统状态与性能监测，包括服务器资源利用率、请求响应时间、错误日志等关键指标。通过告警通知反馈给用户，可以及时发现和解决潜在的问题，确保系统的稳定性和可用性。
* 一键化的部署能力

通过简单的操作，能够自动化完成软件的安装、配置和启动，减少繁琐的手动操作和潜在的人为错误。这种自动化的部署流程大大缩减部署时间，极大提升部署效率。
* 完善的运维生态

支持数据导入、导出、迁移、数据恢复及集群弹性扩缩容等功能。为开发人员提供了全面的运维支持。有了这些功能的支持，开发人员可以轻松管理和操作数据库系统。
## 3、应用场景
**1）企业知识库建设**

DingoDB旨在为企业知识库提供向量化存储，并与大规模模型相配合。它的目标是帮助构建智能化的知识库，全面提升知识分享的能力。能够极大地提高员工的工作效率，减少其在搜寻信息方面的时间消耗；支撑政府、传统企业构建企业级的知识库，实现语义的精准搜索与联合分析。

**2）大模型记忆体**

DingoDB通过分布式存储系统提供可靠且高效的存储解决方案。在辅助大模型生成前进行Prompt管理，Prompt负责存储和组织各种用户输入，以便在查询时能快速检索相关Prompt作为输入。通过大模型记忆体的辅助，可以提升查询响应速度、用户体验和答案生成效率，同时满足大模型应用场景下的查询需求。

**3）Vector Ocean数据支撑平台**

DingoDB作为一个功能强大的数据存储平台，它能够存储、分析结构化和非结构化数据，并提供可靠的访问和查询接口，提升查询效率。同时具备多模态数据分析和科学计算的能力，能够处理多模态数据，提供丰富的分析算法探索和挖掘数据中的信息，支持各种复杂数据的分析任务和应用场景。

**4）实时决策指标计算能力**

DingoDB 具备高性能和低延迟的特性，使用户能够在秒级时间内处理和分析大规模数据，并支持实时风控决策。它采用数据复制和故障转移机制，提供高可用性，同时通过持久化技术确保数据不丢失。此外，DingoDB还支持根据业务需求进行计算资源和存储资源的水平扩展，以满足不断增长的数据处理需求。满足信创标准的高频Serving计算能力，支撑实时风控、营销、推荐等要求亚秒级决策的场景。

**5）结构化与非结构化的融合分析**

DingoDB支持处理包括音频、视频、文本等非结构化多种数据类型，并将它们向量化存储，从而更便捷地进行联合分析和科学计算。这种融合分析能力使得用户可以同时利用结构化数据和向量数据，从不同维度和深度挖掘数据中的潜在信息和价值。结构化与非结构化的融合分析可以应用于风险预测、舆情监测、智能客服、智能推荐等多个场景。例如：在金融行业，可以将结构化财务数据与非结构化的新闻报道等进行融合分析，以检测市场动向和风险变化。
