# Docker容器单节点快速部署

首先，在Linux环境中成功部署和安装Docker之后，为了进行Docker容器的单节点快速部署，你需要遵循以下步骤执行部署过程：
## 1、先决条件
 确保你的Linux系统已经成功安装了Docker容器引擎，并且Docker服务正在正常运行。

## 2、环境准备
### 1）环境说明
提前配置好 git docker docker-compose环境；
```shell
#说明: 检查自己的docker-compose版本， 与以下关系相对应, 适当修改2.1下载的配置文件docker-compose.yml version字段
 docker-compose.yml version| Docker Engine version| Docker Compose version
  2.4；                       17.12.0+;              1.21.0+
  2.3；                       17.06.0+;              1.16.0+
  2.2；                       1.13.0+;               1.13.0+
  2.1；                       1.12.0+;               1.9.0+
  2.0；                       1.10.0+ ;              1.6.0+
```
### 2）拉取容器
```shell
# 拉取 dingo-store
docker pull dingodatabase/dingo-store:latest
# 拉取dingo
docker pull dingodatabase/dingo:latest
```
## 3、启动容器
这里需要基于docker-compose启动容器，所以，我们首先去拉取：docker-compose。
### 1）拉取对应的docker-compose配置

```shell
# 方法1 
curl https://github.com/dingodb/dingo-deploy/blob/main/container/docker-compose/docker-compose.single.yml -o docker-compose.yml
# 方法2
git clone https://github.com/dingodb/dingo-deploy.git
cd  dingo-deploy/container/docker-compose
```
**配置文件说明：**
* docker-compose.yml为单节点多服务，其中完整启动包含了3个coordinator、3个store、3个index、1个executor、1个web(proxy);
* docker-compose.single.yml为单节点单服务，其中完整启动包含了1个coordinator、1个store、1个index、1个executor、1个web(proxy);
* coordinator、store、index采用了host网络， executor、web(proxy)使用了net网络
### 2）启动对应容器
```shell
#  修改为自己的ip地址， 不可以使用127.0.0.1(web(proxy)和executor使用了net网络，127.0.0.1不指向主机)
# docker-compose.yml在当前目录下并且名字一致，可以不使用-f参数
DINGO_HOST_IP=x.x.x.x docker-compose -f ./docker-compose.yml up -d
```
## 4、查看集群状态
### 1）查看容器状态
检查yml配置文件中的容器是否全部处于Up状态。
```shell
docker ps
```
### 2）查看进程状态
* 查看coordinator状态
```shell
# 进入容器
docker exec -it coordinator1 bash
cd build/bin/

[root@coordinator1 bin]#  ./dingodb_client --method=GetCoordinatorMap
```

* 查看Store状态
```shell
# 进入容器
docker exec -it coordinator1 bash
cd build/bin/

[root@coordinator1 bin]# ./dingodb_client --method=GetStoreMap
```

* 查看Executor状态
查看executor,通过查看log,确保mysql init是成功状态即可。
```shell
docker logs executor
```

* 查看Proxy状态
Web(Proxy)通过swagger来查看， 需要将URL中的IP替换为自己的IP地址。
  
```
http://localhost:13000/swagger-ui/index.html
```