# 数据类型

## 字符型
|类型|Byte|说明|
|:-:|:-:|:-|
|Char(n)|自定义|定长字符数据，长度为n。不足部分用空格填充。|
|Varchar(n)|自定义|可变长字符数据，最大长度为n。|

## 数值型
|类型|Byte|说明|
|:-:|:-:|:-|
|Int|4|整数值；取值范围通常为-2^31到2^31-1。|
|BigInt|8|大范围的整数值；取值范围通常为-2^63到2^63-1。|
|Float(p)|4|浮点数，p表示精度。取值范围通常为：：-2^128 ~ +2^128。|
|Double|8|双精度浮点数。取值范围通常为：：-2^1024 ~ +2^1024。|

## 二进制类型
|类型|Byte|说明|
|:-:|:-:|:-| 
|Binary(n)|自定义|定长二进制数据，长度为n。|
|VarBinary(n)|自定义|可变长二进制数据，最大长度为n。|
|BLOB|65535|用于存储大二进制数据，用于存储如图像、音频、视频、文档等任意类型的二进制数据。|

## 时间日期类型
|类型|Byte|说明|
|:-:|:-:|:-|
|Time|3|存储时间值（时、分、秒）。格式：'HH:mm:ss.sss'|
|Date|3|存储日期值（年、月、日）。格式：'yyyy-MM-dd'或'yyyymmdd'或'yyyy/MM/dd'或yyyy.MM.dd|
|TIMESTAMP|4|存储日期和时间值。格式：'yyyy-MM-dd HH:mm:ss.sss'|

## 布尔类型
|类型|Byte|说明|
|:-:|:-:|:-|
|Boolean|1|存储布尔值（TRUE、FALSE）。还可以通过强制数值来表示：0 强制为 FALSE，正整数和负整数强制为 TRUE。|

## 集合类型
|类型|Byte|说明|
|:-:|:-:|:-|
|Array|4|有序数据集合。|