# 时间日期函数

## 1、函数清单
|函数|说明|返回类型|
|:-|:-|:-|
|Now( )|返回当前日期时间。|Timestamp|
|CurDate( )|返回当前日期。|Date|
|Current_Date( )|返回当前日期。|Date|
|CurTime( )|返回当前时间。|Time|
|Current_Timestamp( )|返回当前日期时间。|Timestamp|
|From_UnixTime( )|格式化Unix时间戳。|Timestamp|
|Unix_TimeStamp( )|返回Unix时间戳。|Long|
|Timestamp_format( )|格式化时间日期。|Timestamp|
|Date_format( )|格式化日期。|Date|
|Time_Fomat( )|格式化时间。|Time|
|DateDiff( )|求两个日期之差。|Int|

## 2、详细说明
### 1）Now
返回当前日期和时间；返回以“yyyy-MM-dd HH:mm:ss.sss”格式的日期和时间,时间精确到小数点后3位。
* 语法
```sql
Now( )
```
### 2）CurDate
返回当前日期；返回以'yyyy-MM-dd'格式的日期。
* 语法
```sql
CurDate( )
```
### 3）Current_Date()
返回当前日期；返回以'yyyy-MM-dd'格式的日期。
* 语法
```sql
Current_Date（）
```
### 4）CurTime
返回当前时间；返回以'HH:mm:ss.sss'格式的时间，时间精确到小数点后3位。
* 语法
```sql
CurTime（）
```
### 5）Current_Time
返回当前时间；返回以'HH:mm:ss.sss'格式的时间，时间精确到小数点后3位。
* 语法
```sql
Current_Time（）
```
### 6）Current_Timestamp
返回当前日期和时间；返回以“yyyy-MM-dd HH:mm:ss.sss”格式的日期和时间,时间精确到小数点后3位。
* 语法
```sql
Current_Timestamp（）
```
### 7）From_UnixTime
格式化Unix时间戳为日期；将处理后的结果根据Format指定日期格式返回，时间精确到小数点后3位。

Format默认格式为：yyyy-MM-dd HH:mm:ss.sss ；
* 语法
```sql
From_Unixtime(expr)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|expr|Long|时间戳字段。|

### 8）Unix_Timestamp
返回Unix时间戳；如果UNIX_TIMESTAMP()在没有日期参数的情况下被调用,则返回当前时间的时间戳。
* 语法
```sql
Unix_Timestamp([timstamp])
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|timestamp|Timestamp <br> Long|要处理成时间戳的时间日期。 <br> 要处理成时间戳的时间戳。|

### 9）Timestamp_format
格式化日期时间；将处理后的结果根据Format定义的格式返回。

Format：根据说明符去指定日期时间格式，除说明符外支持添加自定义字符；
* 语法
```sql
Timestamp_format(timestamp,[format] )
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|timestamp|Timestamp|要格式化的日期时间; <br> TimeStamp支持到毫秒粒度，保留小数点后3位|
|format|String|根据说明符去指定日期格式，除说明符外支持添加自定义字符；<br> Format参数非必填，默认值为：'yyyy-MM-dd HH:mm:ss.sss'|

### 10）Date_format
格式化日期；将处理后的结果根据Format定义的格式返回。

Format：根据说明符去指定日期格式，除说明符外支持添加自定义字符；
* 语法
```sql
Date_format(date,[format])
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|date|Date|指要格式化的日期;|
|format|String|根据说明符去指定日期格式，除说明符外支持添加自定义字符；<br> Format参数非必填，默认值为：'yyyy-MM-dd' |

### 11）Time_format
格式化时间；将处理后的结果根据Format定义的格式返回。

Format：根据说明符去指定日期格式，除说明符外支持添加自定义字符；
* 语法
```sql
Time_Fomat(time,[format])
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|time|Time|指要格式化的时间; <br> Time支持到毫秒粒度，保留小数点后3位；|
|format|String|根据说明符去指定日期格式，除说明符外支持添加自定义字符；<br> Format参数非必填，默认值为：'HH:mm:ss.sss' |

### 12）DateDiff
计算两个日期之差。
* 语法
```sql
DateDiff(expr1,expr2)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|expr|Date|要做计算的日期;|