# 数值函数

## 1、函数清单
|函数|说明|返回类型|
|:-:|:-|:-|
|Pow( )|求参数X的Y次方。|Decimal|
|Round( )|用于数据的四舍五入。|Int、Double、Float|
|Ceiling( )|返回大于参数X的最大整数值。|Int|
|Floor( )|返回小于参数X的最大整数值。|Int|
|Mod( )|取余，返回X除以Y的的余数。|Decimal|
|Abs( )|返回参数X的绝对值。|Decimal|

## 2、详细说明
### 1）Pow
求参数X的Y次方，当X或Y为null时，返回null。
* 语法
```sql
Pow(X,Y)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|X|Int、Double、Float、Long|要被求方的数值。|
|Y|Int|次方数|

### 2）Round
用于数据的四舍五入；Y参数可忽略，默认为0；

当参数Y为负整数是，X在小数点左边的Y位进行四舍五入(从右往左数)；

如果参数Y是负数缺大于小数点前的数字个数，Round返回0。
* 语法
```sql
Round(X,Y)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|X|Int、Double、Float|表示被处理的数值。|
|Y|Int|指保留小数位数。|

### 3）Ceiling
取大于参数X的最大整数值，如果X为null，返回null；

还可用缩写Ceil(X)来表示。
* 语法
```sql
Ceiling(X)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|X|Double、Float|表示被处理的数值。|

### 4）Floor
取小于参数X的最大整数值，如果X为null，返回null。
* 语法
```sql
Floor(X)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|X|Int、Double、Float|表示被处理的数值。|

### 5）Mod
取余，返回X除以Y的余数，参数X和Y任何一个为null时，返回null。
* 语法
```sql
Mod(X,Y)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|X|Int、Double、Float、Long|表示被除数。|
|Y|Int、Double、Float、Long|表示除数。|

### 6）Abs
绝对值，返回参数X的绝对值；如果参数X为null，返回null。
* 语法
```sql
Abs(X,Y)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|X|Int、BigInt、Double、Float|表示要做绝对值的数值。|