# 字符串函数

## 1、函数清单
|函数|说明|返回类型|
|:-|:-|:-|
|Concat( )|字符串拼接。|String|
|Format( )|返回格式化为指定小数位数的数字。|String|
|Locate( )|返回子字符串第一次出现的位置。|Int|
|Lower( )|将所有字符串转换为小写。|String|
|Lcase( )|将所有字符串转换为小写。|String|
|Upper( )|将所有字符串转换为大写。|String|
|Ucase( )|将所有字符串转换为大写。|String|
|Left( )|返回指定的最左边的字符数。|String|
|Right( )|返回指定的最右边的字符数。|String|
|Repeat( )|将字符串重复多次。|String|
|Replace( )|替换指定字符串的出现。|String|
|Trim( )|字符串移除|String|
|Ltrim( )|移除左边字符串。|String|
|Rtrim( )|移除右边字符串。|String|
|Mid( )|返回从指定位置开始的子字符串。|String|
|SubString( )|返回从指定位置开始的子字符串。|String|
|Reverse( )|反转指定字符串中的字符。|String|

## 2、详细说明
### 1）Concat
字符串拼接；将多个字符串拼接成一个字符串返回。
* 语法
```sql
concat(str1,str2) 
```
或
```sql
Str1||str2||.....||strn
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要拼接的字符串。|
### 2）Format
将字符串格式化为指定小数位数的字符串。
* 语法
```sql
Format(str,n) 
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要操作的字符串。|
|n|Int|保留小数位数。|
### 3）Locate
返回子字符串第一次在字符串中出现的位置。
* 语法
```sql
Locate(substr,str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|substr|String|子字符串。|
|str|String|字符串。|
### 4）Lower
将所有字符串转换为小写。
* 语法
```sql
Lower(str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要操作的字符串。|
### 5）Lcase
将所有字符串转换为小写。
* 语法
```sql
Lcase(str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要操作的字符串。|
### 6）Upper
将所有字符串转换为大写。
* 语法
```sql
Upper(str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要操作的字符串。|
### 7）Ucase
将所有字符串转换为大写。
* 语法
```sql
Ucase(str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要操作的字符串。|
### 8）Left
返回字符串指定字符数最左边的字符。
* 语法
```sql
Left(str,n)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要查找的字符串。|
|n|Int|返回的字符个数。|
### 9）Right
返回字符串指定字符数最右边的字符。
* 语法
```sql
Right(str,n)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要查找的字符串。|
|n|Int|返回的字符个数。|
### 10）Repeat
将字符串重复指定的次数。
* 语法
```sql
Repeat(str,n)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要操作的字符串。|
|n|Int|重复次数。|
### 11）Replace
替换字符串。
* 语法
```sql
Repeat(str,a,b)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指需要操作的字符串。|
|a|String|被替换的字符。|
|b|String|结果字符，指将被替换成的字符。|
### 12）Trim
从字符串的两侧（左边和右边）移除指定的字符（如果不指定，则默认为空格。）
* 语法
```sql
TRIM([{Both | Leading | Trailing} [remstr] FROM] str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|Both| |从字符串的两端移除指定的字符。如果省略，TRIM默认就是BOTH。|
|Leading| |仅从字符串的开始位置移除指定的字符。|
|Traling| |仅从字符串的末尾移除指定的字符。|
|remstr| |要从字符串中移除的字符集。如果省略，则默认为空格。|
|str||要进行处理的原始字符串。|
### 13）Ltrim
用于移除字符串左边的空格（或指定的其他字符）。
* 语法
```sql
LTRIM([remstr FROM] str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|remstr| |要从字符串中移除的字符集。如果省略，则默认为空格。|
|str||要进行处理的原始字符串。|
### 14）Rtrim
用于移除字符串右边的空格（或指定的其他字符）。
* 语法
```sql
RTRIM([remstr FROM] str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|remstr| |要从字符串中移除的字符集。如果省略，则默认为空格。|
|str||要进行处理的原始字符串。|
### 15）Mid
返回从指定位置开始截取后的子字符串。
* 语法
```sql
Mid(str,n,len)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指要被处理的字符串。|
|n|Int|表示字符串下标，从第n位开始截取。|
|len|Int|表示要截取的长度，不填泽截取n之后的所有字符。|

### 16）SubString
返回从指定位置开始截取后的子字符串。
* 语法
```sql
SubString(str,x,len)
```
或
```sql
SubString(str from m for n)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指要被处理的字符串。|
|n|Int|表示字符串下标，从第n位开始截取。|
|len|Int|表示要截取的长度，不填泽截取n之后的所有字符。|

### 17）Reverse
反转字符串的字符。
* 语法
```sql
Reverse(str)
```
* 参数说明

|参数|参数类型|说明|
|:-:|:-|:-|
|str|String|指要被处理的字符串。|