# 向量函数

## 1、函数清单
|函数|说明|返回类型|
|:-|:-|:-|
|txt2vec( )|从文本中提取向量，测量向量为1024维。|Float|
|Img2vec( )|从图片中提取向量，测量向量为512维。|Float|
|distance( )|计算两向量的距离。|Float|
|l2distance( )|欧式距离计算。|Float|
|ipDistance( )|内积距离计算。|Float|
|cosineDistance( )|余弦距离计算。|Float|

## 2、详细说明
### 1）txt2vec
从文本中提取向量，测试向量为1024维。
* 语法
```sql
txt2vec(host,text)
```
* 参数说明

|参数|参数类型|说明|是否必填|
|:-:|:-|:-|:-|
|host|String|表示模型服务具体ip:port，需要’’包含|必填|
|text|String|表示需要提取向量的文本，需要’’包含|必填|

### 2）img2vec
从图片中提取向量，测试向量为512维。
* 语法
```sql
img2vec(host,img_url,local_path)
```
* 参数说明

|参数|参数类型|说明|是否必填|
|:-:|:-|:-|:-|
|host|String|表示模型服务具体ip:port，需要’’包含|必填|
|img_url|String|表示图片的网络地址或者本地地址（服务器），需要’’包含|必填|
|local_path|Boolean|表示是否获取本地图片资源，需要’’包含|非必填，默认为false|

### 3）distance
计算两向量的距离，距离类型为向量表中指定向量列的距离类型，需要保持两向量维度一致。
* 语法
```sql
distance(vecColumn,txt2vec(host,text))
```
* 参数说明

|参数|参数类型|说明||
|:-:|:-|:-|:-|
|vecColumn|string|表示需要求距离的列名，不需要’’包含。|必填|
|txt2vec(host,text)| |表示需要计算的向量函数。|必填|

### 4）ipDistance
内积距离计算函数，计算向量之间相似性的方法。距离越大表示向量越不相似，越小表示向量越相似。
* 语法一
```sql
<*>
```
* 示例
```sql
select  feature <*> array[1.1,1.2,1.3] from table;
```
* 语法二
```sql
ipdistance(vecColumn,array[])
```
* 示例
```sql
select ipDistance(feature,array[1,2......]) from table;
```
* 参数说明

|参数|参数类型|说明||
|:-:|:-|:-|:-|
|vecColumn|string|表示需要求距离的列名，不需要’’包含|必填|
|array[ ]|Float|表示需要计算的距离值|必填|

### 5）l2Distance
度量2点之间的L2距离。即由向量表示的点之间的线的长度；距离越短，源对象在概念上越相似。
* 语法一
```sql
<=>
```
* 示例
```sql
select  feature <=> array[1.1,1.2,1.3] from table;
```
* 语法二
```sql
l2distance(vecColumn,array[])
```
* 示例
```sql
select l2Distance(feature,array[1,2......]) from table;
```
* 参数说明

|参数|参数类型|说明||
|:-:|:-|:-|:-|
|vecColumn|string|表示需要求距离的列名，不需要’’包含。|必填|
|array[ ]|Float|表示需要计算的距离值。|必填|
### 6）cosDistance
度量两个向量之间的角的余弦，即点积除以长度。
* 语法一
```sql
<->
```
* 示例
```sql
select  feature <-> array[1.1,1.2,1.3] from table;
```
* 语法二
```sql
cosdistance(vecColumn,array[])
```
* 示例
```sql
select cosDistance(feature,array[1,2......]) from table;
```
* 参数说明

|参数|参数类型|说明||
|:-:|:-|:-|:-|
|vecColumn|string|表示需要求距离的列名，不需要’’包含。|必填|
|array[ ]|Float|表示需要计算的距离值。|必填|