/*
 * Copyright 2021 DataCanvas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dingodb.test.dsl.builder.checker;

import io.dingodb.test.asserts.ResultSetCheckConfig;
import lombok.Getter;
import lombok.Setter;

public abstract class SqlResultDataChecker extends SqlResultChecker {
    @Setter
    @Getter
    private ResultSetCheckConfig config;

    protected SqlResultDataChecker() {
        config = new ResultSetCheckConfig();
    }

    public SqlResultDataChecker order() {
        config.setCheckOrder(true);
        return this;
    }

    public SqlResultDataChecker timeDeviation(long deviation) {
        config.setTimeDeviation(deviation);
        return this;
    }

    public SqlResultDataChecker timestampDeviation(long deviation) {
        config.setTimestampDeviation(deviation);
        return this;
    }
}
