/*
 * Copyright 2021 DataCanvas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dingodb.store.api.transaction.data;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class TxnResultInfo {
    // Client should backoff or cleanup the lock then retry, this error occurs in get phase.
    private LockInfo locked;
    // Write conflict with key which is locked by another transaction, this error occurs in prewrite phase.
    private WriteConflict writeConflict;
    // Txn not found when checking txn status.
    private TxnNotFound txnNotFound;
    // CheckTxnStatus is sent to a lock that's not the primary.
    private PrimaryMismatch primaryMismatch;
}
