/*
 * Copyright 2021 DataCanvas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dingodb.exec.aggregate;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "fun"
)
@JsonSubTypes({
    @JsonSubTypes.Type(CountAgg.class),
    @JsonSubTypes.Type(CountAllAgg.class),
    @JsonSubTypes.Type(MaxAgg.class),
    @JsonSubTypes.Type(MinAgg.class),
    @JsonSubTypes.Type(Sum0Agg.class),
    @JsonSubTypes.Type(SumAgg.class),
})
public abstract class AbstractAgg implements Agg {
}
