/*
 * Copyright 2021 DataCanvas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dingodb.common.mysql.error;

public class ErrorCode {
    public static int ErrErrorFirst                                            = 1000;
    public static int ErrHashchk                                               = 1000;
    public static int ErrNisamchk                                              = 1001;
    public static int ErrNo                                                    = 1002;
    public static int ErrYes                                                   = 1003;
    public static int ErrCantCreateFile                                        = 1004;
    public static int ErrCantCreateTable                                       = 1005;
    public static int ErrCantCreateDB                                          = 1006;
    public static int ErrDBCreateExists                                        = 1007;
    public static int ErrDBDropExists                                          = 1008;
    public static int ErrDBDropDelete                                          = 1009;
    public static int ErrDBDropRmdir                                           = 1010;
    public static int ErrCantDeleteFile                                        = 1011;
    public static int ErrCantFindSystemRec                                     = 1012;
    public static int ErrCantGetStat                                           = 1013;
    public static int ErrCantGetWd                                             = 1014;
    public static int ErrCantLock                                              = 1015;
    public static int ErrCantOpenFile                                          = 1016;
    public static int ErrFileNotFound                                          = 1017;
    public static int ErrCantReadDir                                           = 1018;
    public static int ErrCantSetWd                                             = 1019;
    public static int ErrCheckread                                             = 1020;
    public static int ErrDiskFull                                              = 1021;
    public static int ErrDupKey                                                = 1022;
    public static int ErrErrorOnClose                                          = 1023;
    public static int ErrErrorOnRead                                           = 1024;
    public static int ErrErrorOnRename                                         = 1025;
    public static int ErrErrorOnWrite                                          = 1026;
    public static int ErrFileUsed                                              = 1027;
    public static int ErrFilsortAbort                                          = 1028;
    public static int ErrFormNotFound                                          = 1029;
    public static int ErrGetErrno                                              = 1030;
    public static int ErrIllegalHa                                             = 1031;
    public static int ErrKeyNotFound                                           = 1032;
    public static int ErrNotFormFile                                           = 1033;
    public static int ErrNotKeyFile                                            = 1034;
    public static int ErrOldKeyFile                                            = 1035;
    public static int ErrOpenAsReadonly                                        = 1036;
    public static int ErrOutofMemory                                           = 1037;
    public static int ErrOutOfSortMemory                                       = 1038;
    public static int ErrUnexpectedEOF                                         = 1039;
    public static int ErrConCount                                              = 1040;
    public static int ErrOutOfResources                                        = 1041;
    public static int ErrBadHost                                               = 1042;
    public static int ErrHandshake                                             = 1043;
    public static int ErrDBaccessDenied                                        = 1044;
    public static int ErrAccessDenied                                          = 1045;
    public static int ErrNoDB                                                  = 1046;
    public static int ErrUnknownCom                                            = 1047;
    public static int ErrBadNull                                               = 1048;
    public static int ErrBadDB                                                 = 1049;
    public static int ErrTableExists                                           = 1050;
    public static int ErrBadTable                                              = 1051;
    public static int ErrNonUniq                                               = 1052;
    public static int ErrServerShutdown                                        = 1053;
    public static int ErrBadField                                              = 1054;
    public static int ErrFieldNotInGroupBy                                     = 1055;
    public static int ErrWrongGroupField                                       = 1056;
    public static int ErrWrongSumSelect                                        = 1057;
    public static int ErrWrongValueCount                                       = 1058;
    public static int ErrTooLongIdent                                          = 1059;
    public static int ErrDupFieldName                                          = 1060;
    public static int ErrDupKeyName                                            = 1061;
    public static int ErrDupEntry                                              = 1062;
    public static int ErrWrongFieldSpec                                        = 1063;
    public static int ErrParse                                                 = 1064;
    public static int ErrEmptyQuery                                            = 1065;
    public static int ErrNonuniqTable                                          = 1066;
    public static int ErrInvalidDefault                                        = 1067;
    public static int ErrMultiplePriKey                                        = 1068;
    public static int ErrTooManyKeys                                           = 1069;
    public static int ErrTooManyKeyParts                                       = 1070;
    public static int ErrTooLongKey                                            = 1071;
    public static int ErrKeyColumnDoesNotExits                                 = 1072;
    public static int ErrBlobUsedAsKey                                         = 1073;
    public static int ErrTooBigFieldlength                                     = 1074;
    public static int ErrWrongAutoKey                                          = 1075;
    public static int ErrReady                                                 = 1076;
    public static int ErrNormalShutdown                                        = 1077;
    public static int ErrGotSignal                                             = 1078;
    public static int ErrShutdownComplete                                      = 1079;
    public static int ErrForcingClose                                          = 1080;
    public static int ErrIpsock                                                = 1081;
    public static int ErrNoSuchIndex                                           = 1082;
    public static int ErrWrongFieldTerminators                                 = 1083;
    public static int ErrBlobsAndNoTerminated                                  = 1084;
    public static int ErrTextFileNotReadable                                   = 1085;
    public static int ErrFileExists                                            = 1086;
    public static int ErrLoadInfo                                              = 1087;
    public static int ErrAlterInfo                                             = 1088;
    public static int ErrWrongSubKey                                           = 1089;
    public static int ErrCantRemoveAllFields                                   = 1090;
    public static int ErrCantDropFieldOrKey                                    = 1091;
    public static int ErrInsertInfo                                            = 1092;
    public static int ErrUpdateTableUsed                                       = 1093;
    public static int ErrNoSuchThread                                          = 1094;
    public static int ErrKillDenied                                            = 1095;
    public static int ErrNoTablesUsed                                          = 1096;
    public static int ErrTooBigSet                                             = 1097;
    public static int ErrNoUniqueLogFile                                       = 1098;
    public static int ErrTableNotLockedForWrite                                = 1099;
    public static int ErrTableNotLocked                                        = 1100;
    public static int ErrBlobCantHaveDefault                                   = 1101;
    public static int ErrWrongDBName                                           = 1102;
    public static int ErrWrongTableName                                        = 1103;
    public static int ErrTooBigSelect                                          = 1104;
    public static int ErrUnknown                                               = 1105;
    public static int ErrUnknownProcedure                                      = 1106;
    public static int ErrWrongParamcountToProcedure                            = 1107;
    public static int ErrWrongParametersToProcedure                            = 1108;
    public static int ErrUnknownTable                                          = 1109;
    public static int ErrFieldSpecifiedTwice                                   = 1110;
    public static int ErrInvalidGroupFuncUse                                   = 1111;
    public static int ErrUnsupportedExtension                                  = 1112;
    public static int ErrTableMustHaveColumns                                  = 1113;
    public static int ErrRecordFileFull                                        = 1114;
    public static int ErrUnknownCharacterSet                                   = 1115;
    public static int ErrTooManyTables                                         = 1116;
    public static int ErrTooManyFields                                         = 1117;
    public static int ErrTooBigRowsize                                         = 1118;
    public static int ErrStackOverrun                                          = 1119;
    public static int ErrWrongOuterJoin                                        = 1120;
    public static int ErrNullColumnInIndex                                     = 1121;
    public static int ErrCantFindUdf                                           = 1122;
    public static int ErrCantInitializeUdf                                     = 1123;
    public static int ErrUdfNoPaths                                            = 1124;
    public static int ErrUdfExists                                             = 1125;
    public static int ErrCantOpenLibrary                                       = 1126;
    public static int ErrCantFindDlEntry                                       = 1127;
    public static int ErrFunctionNotDefined                                    = 1128;
    public static int ErrHostIsBlocked                                         = 1129;
    public static int ErrHostNotPrivileged                                     = 1130;
    public static int ErrPasswordAnonymousUser                                 = 1131;
    public static int ErrPasswordNotAllowed                                    = 1132;
    public static int ErrPasswordNoMatch                                       = 1133;
    public static int ErrUpdateInfo                                            = 1134;
    public static int ErrCantCreateThread                                      = 1135;
    public static int ErrWrongValueCountOnRow                                  = 1136;
    public static int ErrCantReopenTable                                       = 1137;
    public static int ErrInvalidUseOfNull                                      = 1138;
    public static int ErrRegexp                                                = 1139;
    public static int ErrMixOfGroupFuncAndFields                               = 1140;
    public static int ErrNonexistingGrant                                      = 1141;
    public static int ErrTableaccessDenied                                     = 1142;
    public static int ErrColumnaccessDenied                                    = 1143;
    public static int ErrIllegalGrantForTable                                  = 1144;
    public static int ErrGrantWrongHostOrUser                                  = 1145;
    public static int ErrNoSuchTable                                           = 1146;
    public static int ErrNonexistingTableGrant                                 = 1147;
    public static int ErrNotAllowedCommand                                     = 1148;
    public static int ErrSyntax                                                = 1149;
    public static int ErrDelayedCantChangeLock                                 = 1150;
    public static int ErrTooManyDelayedThreads                                 = 1151;
    public static int ErrAbortingConnection                                    = 1152;
    public static int ErrNetPacketTooLarge                                     = 1153;
    public static int ErrNetReadErrorFromPipe                                  = 1154;
    public static int ErrNetFcntl                                              = 1155;
    public static int ErrNetPacketsOutOfOrder                                  = 1156;
    public static int ErrNetUncompress                                         = 1157;
    public static int ErrNetRead                                               = 1158;
    public static int ErrNetReadInterrupted                                    = 1159;
    public static int ErrNetErrorOnWrite                                       = 1160;
    public static int ErrNetWriteInterrupted                                   = 1161;
    public static int ErrTooLongString                                         = 1162;
    public static int ErrTableCantHandleBlob                                   = 1163;
    public static int ErrTableCantHandleAutoIncrement                          = 1164;
    public static int ErrDelayedInsertTableLocked                              = 1165;
    public static int ErrWrongColumnName                                       = 1166;
    public static int ErrWrongKeyColumn                                        = 1167;
    public static int ErrWrongMrgTable                                         = 1168;
    public static int ErrDupUnique                                             = 1169;
    public static int ErrBlobKeyWithoutLength                                  = 1170;
    public static int ErrPrimaryCantHaveNull                                   = 1171;
    public static int ErrTooManyRows                                           = 1172;
    public static int ErrRequiresPrimaryKey                                    = 1173;
    public static int ErrNoRaidCompiled                                        = 1174;
    public static int ErrUpdateWithoutKeyInSafeMode                            = 1175;
    public static int ErrKeyDoesNotExist                                       = 1176;
    public static int ErrCheckNoSuchTable                                      = 1177;
    public static int ErrCheckNotImplemented                                   = 1178;
    public static int ErrCantDoThisDuringAnTransaction                         = 1179;
    public static int ErrErrorDuringCommit                                     = 1180;
    public static int ErrErrorDuringRollback                                   = 1181;
    public static int ErrErrorDuringFlushLogs                                  = 1182;
    public static int ErrErrorDuringCheckpoint                                 = 1183;
    public static int ErrNewAbortingConnection                                 = 1184;
    public static int ErrDumpNotImplemented                                    = 1185;
    public static int ErrFlushMasterBinlogClosed                               = 1186;
    public static int ErrIndexRebuild                                          = 1187;
    public static int ErrMaster                                                = 1188;
    public static int ErrMasterNetRead                                         = 1189;
    public static int ErrMasterNetWrite                                        = 1190;
    public static int ErrFtMatchingKeyNotFound                                 = 1191;
    public static int ErrLockOrActiveTransaction                               = 1192;
    public static int ErrUnknownSystemVariable                                 = 1193;
    public static int ErrCrashedOnUsage                                        = 1194;
    public static int ErrCrashedOnRepair                                       = 1195;
    public static int ErrWarningNotCompleteRollback                            = 1196;
    public static int ErrTransCacheFull                                        = 1197;
    public static int ErrSlaveMustStop                                         = 1198;
    public static int ErrSlaveNotRunning                                       = 1199;
    public static int ErrBadSlave                                              = 1200;
    public static int ErrMasterInfo                                            = 1201;
    public static int ErrSlaveThread                                           = 1202;
    public static int ErrTooManyUserConnections                                = 1203;
    public static int ErrSetConstantsOnly                                      = 1204;
    public static int ErrLockWaitTimeout                                       = 1205;
    public static int ErrLockTableFull                                         = 1206;
    public static int ErrReadOnlyTransaction                                   = 1207;
    public static int ErrDropDBWithReadLock                                    = 1208;
    public static int ErrCreateDBWithReadLock                                  = 1209;
    public static int ErrWrongArguments                                        = 1210;
    public static int ErrNoPermissionToCreateUser                              = 1211;
    public static int ErrUnionTablesInDifferentDir                             = 1212;
    public static int ErrLockDeadlock                                          = 1213;
    public static int ErrTableCantHandleFt                                     = 1214;
    public static int ErrCannotAddForeign                                      = 1215;
    public static int ErrNoReferencedRow                                       = 1216;
    public static int ErrRowIsReferenced                                       = 1217;
    public static int ErrConnectToMaster                                       = 1218;
    public static int ErrQueryOnMaster                                         = 1219;
    public static int ErrErrorWhenExecutingCommand                             = 1220;
    public static int ErrWrongUsage                                            = 1221;
    public static int ErrWrongNumberOfColumnsInSelect                          = 1222;
    public static int ErrCantUpdateWithReadlock                                = 1223;
    public static int ErrMixingNotAllowed                                      = 1224;
    public static int ErrDupArgument                                           = 1225;
    public static int ErrUserLimitReached                                      = 1226;
    public static int ErrSpecificAccessDenied                                  = 1227;
    public static int ErrLocalVariable                                         = 1228;
    public static int ErrGlobalVariable                                        = 1229;
    public static int ErrNoDefault                                             = 1230;
    public static int ErrWrongValueForVar                                      = 1231;
    public static int ErrWrongTypeForVar                                       = 1232;
    public static int ErrVarCantBeRead                                         = 1233;
    public static int ErrCantUseOptionHere                                     = 1234;
    public static int ErrNotSupportedYet                                       = 1235;
    public static int ErrMasterFatalErrorReadingBinlog                         = 1236;
    public static int ErrSlaveIgnoredTable                                     = 1237;
    public static int ErrIncorrectGlobalLocalVar                               = 1238;
    public static int ErrWrongFkDef                                            = 1239;
    public static int ErrKeyRefDoNotMatchTableRef                              = 1240;
    public static int ErrOperandColumns                                        = 1241;
    public static int ErrSubqueryNo1Row                                        = 1242;
    public static int ErrUnknownStmtHandler                                    = 1243;
    public static int ErrCorruptHelpDB                                         = 1244;
    public static int ErrCyclicReference                                       = 1245;
    public static int ErrAutoConvert                                           = 1246;
    public static int ErrIllegalReference                                      = 1247;
    public static int ErrDerivedMustHaveAlias                                  = 1248;
    public static int ErrSelectReduced                                         = 1249;
    public static int ErrTablenameNotAllowedHere                               = 1250;
    public static int ErrNotSupportedAuthMode                                  = 1251;
    public static int ErrSpatialCantHaveNull                                   = 1252;
    public static int ErrCollationCharsetMismatch                              = 1253;
    public static int ErrSlaveWasRunning                                       = 1254;
    public static int ErrSlaveWasNotRunning                                    = 1255;
    public static int ErrTooBigForUncompress                                   = 1256;
    public static int ErrZlibZMem                                              = 1257;
    public static int ErrZlibZBuf                                              = 1258;
    public static int ErrZlibZData                                             = 1259;
    public static int ErrCutValueGroupConcat                                   = 1260;
    public static int ErrWarnTooFewRecords                                     = 1261;
    public static int ErrWarnTooManyRecords                                    = 1262;
    public static int ErrWarnNullToNotnull                                     = 1263;
    public static int ErrWarnDataOutOfRange                                    = 1264;
    public static int WarnDataTruncated                                        = 1265;
    public static int ErrWarnUsingOtherHandler                                 = 1266;
    public static int ErrCantAggregate2collations                              = 1267;
    public static int ErrDropUser                                              = 1268;
    public static int ErrRevokeGrants                                          = 1269;
    public static int ErrCantAggregate3collations                              = 1270;
    public static int ErrCantAggregateNcollations                              = 1271;
    public static int ErrVariableIsNotStruct                                   = 1272;
    public static int ErrUnknownCollation                                      = 1273;
    public static int ErrSlaveIgnoredSslParams                                 = 1274;
    public static int ErrServerIsInSecureAuthMode                              = 1275;
    public static int ErrWarnFieldResolved                                     = 1276;
    public static int ErrBadSlaveUntilCond                                     = 1277;
    public static int ErrMissingSkipSlave                                      = 1278;
    public static int ErrUntilCondIgnored                                      = 1279;
    public static int ErrWrongNameForIndex                                     = 1280;
    public static int ErrWrongNameForCatalog                                   = 1281;
    public static int ErrWarnQcResize                                          = 1282;
    public static int ErrBadFtColumn                                           = 1283;
    public static int ErrUnknownKeyCache                                       = 1284;
    public static int ErrWarnHostnameWontWork                                  = 1285;
    public static int ErrUnknownStorageEngine                                  = 1286;
    public static int ErrWarnDeprecatedSyntax                                  = 1287;
    public static int ErrNonUpdatableTable                                     = 1288;
    public static int ErrFeatureDisabled                                       = 1289;
    public static int ErrOptionPreventsStatement                               = 1290;
    public static int ErrDuplicatedValueInType                                 = 1291;
    public static int ErrTruncatedWrongValue                                   = 1292;
    public static int ErrTooMuchAutoTimestampCols                              = 1293;
    public static int ErrInvalidOnUpdate                                       = 1294;
    public static int ErrUnsupportedPs                                         = 1295;
    public static int ErrGetErrmsg                                             = 1296;
    public static int ErrGetTemporaryErrmsg                                    = 1297;
    public static int ErrUnknownTimeZone                                       = 1298;
    public static int ErrWarnInvalidTimestamp                                  = 1299;
    public static int ErrInvalidCharacterString                                = 1300;
    public static int ErrWarnAllowedPacketOverflowed                           = 1301;
    public static int ErrConflictingDeclarations                               = 1302;
    public static int ErrSpNoRecursiveCreate                                   = 1303;
    public static int ErrSpAlreadyExists                                       = 1304;
    public static int ErrSpDoesNotExist                                        = 1305;
    public static int ErrSpDropFailed                                          = 1306;
    public static int ErrSpStoreFailed                                         = 1307;
    public static int ErrSpLilabelMismatch                                     = 1308;
    public static int ErrSpLabelRedefine                                       = 1309;
    public static int ErrSpLabelMismatch                                       = 1310;
    public static int ErrSpUninitVar                                           = 1311;
    public static int ErrSpBadselect                                           = 1312;
    public static int ErrSpBadreturn                                           = 1313;
    public static int ErrSpBadstatement                                        = 1314;
    public static int ErrUpdateLogDeprecatedIgnored                            = 1315;
    public static int ErrUpdateLogDeprecatedTranslated                         = 1316;
    public static int ErrQueryInterrupted                                      = 1317;
    public static int ErrSpWrongNoOfArgs                                       = 1318;
    public static int ErrSpCondMismatch                                        = 1319;
    public static int ErrSpNoreturn                                            = 1320;
    public static int ErrSpNoreturnend                                         = 1321;
    public static int ErrSpBadCursorQuery                                      = 1322;
    public static int ErrSpBadCursorSelect                                     = 1323;
    public static int ErrSpCursorMismatch                                      = 1324;
    public static int ErrSpCursorAlreadyOpen                                   = 1325;
    public static int ErrSpCursorNotOpen                                       = 1326;
    public static int ErrSpUndeclaredVar                                       = 1327;
    public static int ErrSpWrongNoOfFetchArgs                                  = 1328;
    public static int ErrSpFetchNoData                                         = 1329;
    public static int ErrSpDupParam                                            = 1330;
    public static int ErrSpDupVar                                              = 1331;
    public static int ErrSpDupCond                                             = 1332;
    public static int ErrSpDupCurs                                             = 1333;
    public static int ErrSpCantAlter                                           = 1334;
    public static int ErrSpSubselectNyi                                        = 1335;
    public static int ErrStmtNotAllowedInSfOrTrg                               = 1336;
    public static int ErrSpVarcondAfterCurshndlr                               = 1337;
    public static int ErrSpCursorAfterHandler                                  = 1338;
    public static int ErrSpCaseNotFound                                        = 1339;
    public static int ErrFparserTooBigFile                                     = 1340;
    public static int ErrFparserBadHeader                                      = 1341;
    public static int ErrFparserEOFInComment                                   = 1342;
    public static int ErrFparserErrorInParameter                               = 1343;
    public static int ErrFparserEOFInUnknownParameter                          = 1344;
    public static int ErrViewNoExplain                                         = 1345;
    public static int ErrFrmUnknownType                                        = 1346;
    public static int ErrWrongObject                                           = 1347;
    public static int ErrNonupdateableColumn                                   = 1348;
    public static int ErrViewSelectDerived                                     = 1349;
    public static int ErrViewSelectClause                                      = 1350;
    public static int ErrViewSelectVariable                                    = 1351;
    public static int ErrViewSelectTmptable                                    = 1352;
    public static int ErrViewWrongList                                         = 1353;
    public static int ErrWarnViewMerge                                         = 1354;
    public static int ErrWarnViewWithoutKey                                    = 1355;
    public static int ErrViewInvalid                                           = 1356;
    public static int ErrSpNoDropSp                                            = 1357;
    public static int ErrSpGotoInHndlr                                         = 1358;
    public static int ErrTrgAlreadyExists                                      = 1359;
    public static int ErrTrgDoesNotExist                                       = 1360;
    public static int ErrTrgOnViewOrTempTable                                  = 1361;
    public static int ErrTrgCantChangeRow                                      = 1362;
    public static int ErrTrgNoSuchRowInTrg                                     = 1363;
    public static int ErrNoDefaultForField                                     = 1364;
    public static int ErrDivisionByZero                                        = 1365;
    public static int ErrTruncatedWrongValueForField                           = 1366;
    public static int ErrIllegalValueForType                                   = 1367;
    public static int ErrViewNonupdCheck                                       = 1368;
    public static int ErrViewCheckFailed                                       = 1369;
    public static int ErrProcaccessDenied                                      = 1370;
    public static int ErrRelayLogFail                                          = 1371;
    public static int ErrPasswdLength                                          = 1372;
    public static int ErrUnknownTargetBinlog                                   = 1373;
    public static int ErrIoErrLogIndexRead                                     = 1374;
    public static int ErrBinlogPurgeProhibited                                 = 1375;
    public static int ErrFseekFail                                             = 1376;
    public static int ErrBinlogPurgeFatalErr                                   = 1377;
    public static int ErrLogInUse                                              = 1378;
    public static int ErrLogPurgeUnknownErr                                    = 1379;
    public static int ErrRelayLogInit                                          = 1380;
    public static int ErrNoBinaryLogging                                       = 1381;
    public static int ErrReservedSyntax                                        = 1382;
    public static int ErrWsasFailed                                            = 1383;
    public static int ErrDiffGroupsProc                                        = 1384;
    public static int ErrNoGroupForProc                                        = 1385;
    public static int ErrOrderWithProc                                         = 1386;
    public static int ErrLoggingProhibitChangingOf                             = 1387;
    public static int ErrNoFileMapping                                         = 1388;
    public static int ErrWrongMagic                                            = 1389;
    public static int ErrPsManyParam                                           = 1390;
    public static int ErrKeyPart0                                              = 1391;
    public static int ErrViewChecksum                                          = 1392;
    public static int ErrViewMultiupdate                                       = 1393;
    public static int ErrViewNoInsertFieldList                                 = 1394;
    public static int ErrViewDeleteMergeView                                   = 1395;
    public static int ErrCannotUser                                            = 1396;
    public static int ErrXaerNota                                              = 1397;
    public static int ErrXaerInval                                             = 1398;
    public static int ErrXaerRmfail                                            = 1399;
    public static int ErrXaerOutside                                           = 1400;
    public static int ErrXaerRmerr                                             = 1401;
    public static int ErrXaRbrollback                                          = 1402;
    public static int ErrNonexistingProcGrant                                  = 1403;
    public static int ErrProcAutoGrantFail                                     = 1404;
    public static int ErrProcAutoRevokeFail                                    = 1405;
    public static int ErrDataTooLong                                           = 1406;
    public static int ErrSpBadSQLstate                                         = 1407;
    public static int ErrStartup                                               = 1408;
    public static int ErrLoadFromFixedSizeRowsToVar                            = 1409;
    public static int ErrCantCreateUserWithGrant                               = 1410;
    public static int ErrWrongValueForType                                     = 1411;
    public static int ErrTableDefChanged                                       = 1412;
    public static int ErrSpDupHandler                                          = 1413;
    public static int ErrSpNotVarArg                                           = 1414;
    public static int ErrSpNoRetset                                            = 1415;
    public static int ErrCantCreateGeometryObject                              = 1416;
    public static int ErrFailedRoutineBreakBinlog                              = 1417;
    public static int ErrBinlogUnsafeRoutine                                   = 1418;
    public static int ErrBinlogCreateRoutineNeedSuper                          = 1419;
    public static int ErrExecStmtWithOpenCursor                                = 1420;
    public static int ErrStmtHasNoOpenCursor                                   = 1421;
    public static int ErrCommitNotAllowedInSfOrTrg                             = 1422;
    public static int ErrNoDefaultForViewField                                 = 1423;
    public static int ErrSpNoRecursion                                         = 1424;
    public static int ErrTooBigScale                                           = 1425;
    public static int ErrTooBigPrecision                                       = 1426;
    public static int ErrMBiggerThanD                                          = 1427;
    public static int ErrWrongLockOfSystemTable                                = 1428;
    public static int ErrConnectToForeignDataSource                            = 1429;
    public static int ErrQueryOnForeignDataSource                              = 1430;
    public static int ErrForeignDataSourceDoesntExist                          = 1431;
    public static int ErrForeignDataStringInvalidCantCreate                    = 1432;
    public static int ErrForeignDataStringInvalid                              = 1433;
    public static int ErrCantCreateFederatedTable                              = 1434;
    public static int ErrTrgInWrongSchema                                      = 1435;
    public static int ErrStackOverrunNeedMore                                  = 1436;
    public static int ErrTooLongBody                                           = 1437;
    public static int ErrWarnCantDropDefaultKeycache                           = 1438;
    public static int ErrTooBigDisplaywidth                                    = 1439;
    public static int ErrXaerDupid                                             = 1440;
    public static int ErrDatetimeFunctionOverflow                              = 1441;
    public static int ErrCantUpdateUsedTableInSfOrTrg                          = 1442;
    public static int ErrViewPreventUpdate                                     = 1443;
    public static int ErrPsNoRecursion                                         = 1444;
    public static int ErrSpCantSetAutocommit                                   = 1445;
    public static int ErrMalformedDefiner                                      = 1446;
    public static int ErrViewFrmNoUser                                         = 1447;
    public static int ErrViewOtherUser                                         = 1448;
    public static int ErrNoSuchUser                                            = 1449;
    public static int ErrForbidSchemaChange                                    = 1450;
    public static int ErrRowIsReferenced2                                      = 1451;
    public static int ErrNoReferencedRow2                                      = 1452;
    public static int ErrSpBadVarShadow                                        = 1453;
    public static int ErrTrgNoDefiner                                          = 1454;
    public static int ErrOldFileFormat                                         = 1455;
    public static int ErrSpRecursionLimit                                      = 1456;
    public static int ErrSpProcTableCorrupt                                    = 1457;
    public static int ErrSpWrongName                                           = 1458;
    public static int ErrTableNeedsUpgrade                                     = 1459;
    public static int ErrSpNoAggregate                                         = 1460;
    public static int ErrMaxPreparedStmtCountReached                           = 1461;
    public static int ErrViewRecursive                                         = 1462;
    public static int ErrNonGroupingFieldUsed                                  = 1463;
    public static int ErrTableCantHandleSpkeys                                 = 1464;
    public static int ErrNoTriggersOnSystemSchema                              = 1465;
    public static int ErrRemovedSpaces                                         = 1466;
    public static int ErrAutoincReadFailed                                     = 1467;
    public static int ErrUsername                                              = 1468;
    public static int ErrHostname                                              = 1469;
    public static int ErrWrongStringLength                                     = 1470;
    public static int ErrNonInsertableTable                                    = 1471;
    public static int ErrAdminWrongMrgTable                                    = 1472;
    public static int ErrTooHighLevelOfNestingForSelect                        = 1473;
    public static int ErrNameBecomesEmpty                                      = 1474;
    public static int ErrAmbiguousFieldTerm                                    = 1475;
    public static int ErrForeignServerExists                                   = 1476;
    public static int ErrForeignServerDoesntExist                              = 1477;
    public static int ErrIllegalHaCreateOption                                 = 1478;
    public static int ErrPartitionRequiresValues                               = 1479;
    public static int ErrPartitionWrongValues                                  = 1480;
    public static int ErrPartitionMaxvalue                                     = 1481;
    public static int ErrPartitionSubpartition                                 = 1482;
    public static int ErrPartitionSubpartMix                                   = 1483;
    public static int ErrPartitionWrongNoPart                                  = 1484;
    public static int ErrPartitionWrongNoSubpart                               = 1485;
    public static int ErrWrongExprInPartitionFunc                              = 1486;
    public static int ErrNoConstExprInRangeOrList                              = 1487;
    public static int ErrFieldNotFoundPart                                     = 1488;
    public static int ErrListOfFieldsOnlyInHash                                = 1489;
    public static int ErrInconsistentPartitionInfo                             = 1490;
    public static int ErrPartitionFuncNotAllowed                               = 1491;
    public static int ErrPartitionsMustBeDefined                               = 1492;
    public static int ErrRangeNotIncreasing                                    = 1493;
    public static int ErrInconsistentTypeOfFunctions                           = 1494;
    public static int ErrMultipleDefConstInListPart                            = 1495;
    public static int ErrPartitionEntry                                        = 1496;
    public static int ErrMixHandler                                            = 1497;
    public static int ErrPartitionNotDefined                                   = 1498;
    public static int ErrTooManyPartitions                                     = 1499;
    public static int ErrSubpartition                                          = 1500;
    public static int ErrCantCreateHandlerFile                                 = 1501;
    public static int ErrBlobFieldInPartFunc                                   = 1502;
    public static int ErrUniqueKeyNeedAllFieldsInPf                            = 1503;
    public static int ErrNoParts                                               = 1504;
    public static int ErrPartitionMgmtOnNonpartitioned                         = 1505;
    public static int ErrForeignKeyOnPartitioned                               = 1506;
    public static int ErrDropPartitionNonExistent                              = 1507;
    public static int ErrDropLastPartition                                     = 1508;
    public static int ErrCoalesceOnlyOnHashPartition                           = 1509;
    public static int ErrReorgHashOnlyOnSameNo                                 = 1510;
    public static int ErrReorgNoParam                                          = 1511;
    public static int ErrOnlyOnRangeListPartition                              = 1512;
    public static int ErrAddPartitionSubpart                                   = 1513;
    public static int ErrAddPartitionNoNewPartition                            = 1514;
    public static int ErrCoalescePartitionNoPartition                          = 1515;
    public static int ErrReorgPartitionNotExist                                = 1516;
    public static int ErrSameNamePartition                                     = 1517;
    public static int ErrNoBinlog                                              = 1518;
    public static int ErrConsecutiveReorgPartitions                            = 1519;
    public static int ErrReorgOutsideRange                                     = 1520;
    public static int ErrPartitionFunctionFailure                              = 1521;
    public static int ErrPartState                                             = 1522;
    public static int ErrLimitedPartRange                                      = 1523;
    public static int ErrPluginIsNotLoaded                                     = 1524;
    public static int ErrWrongValue                                            = 1525;
    public static int ErrNoPartitionForGivenValue                              = 1526;
    public static int ErrFilegroupOptionOnlyOnce                               = 1527;
    public static int ErrCreateFilegroupFailed                                 = 1528;
    public static int ErrDropFilegroupFailed                                   = 1529;
    public static int ErrTablespaceAutoExtend                                  = 1530;
    public static int ErrWrongSizeNumber                                       = 1531;
    public static int ErrSizeOverflow                                          = 1532;
    public static int ErrAlterFilegroupFailed                                  = 1533;
    public static int ErrBinlogRowLoggingFailed                                = 1534;
    public static int ErrBinlogRowWrongTableDef                                = 1535;
    public static int ErrBinlogRowRbrToSbr                                     = 1536;
    public static int ErrEventAlreadyExists                                    = 1537;
    public static int ErrEventStoreFailed                                      = 1538;
    public static int ErrEventDoesNotExist                                     = 1539;
    public static int ErrEventCantAlter                                        = 1540;
    public static int ErrEventDropFailed                                       = 1541;
    public static int ErrEventIntervalNotPositiveOrTooBig                      = 1542;
    public static int ErrEventEndsBeforeStarts                                 = 1543;
    public static int ErrEventExecTimeInThePast                                = 1544;
    public static int ErrEventOpenTableFailed                                  = 1545;
    public static int ErrEventNeitherMExprNorMAt                               = 1546;
    public static int ErrObsoleteColCountDoesntMatchCorrupted                  = 1547;
    public static int ErrObsoleteCannotLoadFromTable                           = 1548;
    public static int ErrEventCannotDelete                                     = 1549;
    public static int ErrEventCompile                                          = 1550;
    public static int ErrEventSameName                                         = 1551;
    public static int ErrEventDataTooLong                                      = 1552;
    public static int ErrDropIndexNeededInForeignKey                           = 1553;
    public static int ErrWarnDeprecatedSyntaxWithVer                           = 1554;
    public static int ErrCantWriteLockLogTable                                 = 1555;
    public static int ErrCantLockLogTable                                      = 1556;
    public static int ErrForeignDuplicateKeyOldUnused                          = 1557;
    public static int ErrColCountDoesntMatchPleaseUpdate                       = 1558;
    public static int ErrTempTablePreventsSwitchOutOfRbr                       = 1559;
    public static int ErrStoredFunctionPreventsSwitchBinlogFormat              = 1560;
    public static int ErrNdbCantSwitchBinlogFormat                             = 1561;
    public static int ErrPartitionNoTemporary                                  = 1562;
    public static int ErrPartitionConstDomain                                  = 1563;
    public static int ErrPartitionFunctionIsNotAllowed                         = 1564;
    public static int ErrDdlLog                                                = 1565;
    public static int ErrNullInValuesLessThan                                  = 1566;
    public static int ErrWrongPartitionName                                    = 1567;
    public static int ErrCantChangeTxCharacteristics                           = 1568;
    public static int ErrDupEntryAutoincrementCase                             = 1569;
    public static int ErrEventModifyQueue                                      = 1570;
    public static int ErrEventSetVar                                           = 1571;
    public static int ErrPartitionMerge                                        = 1572;
    public static int ErrCantActivateLog                                       = 1573;
    public static int ErrRbrNotAvailable                                       = 1574;
    public static int ErrBase64Decode                                          = 1575;
    public static int ErrEventRecursionForbidden                               = 1576;
    public static int ErrEventsDB                                              = 1577;
    public static int ErrOnlyIntegersAllowed                                   = 1578;
    public static int ErrUnsuportedLogEngine                                   = 1579;
    public static int ErrBadLogStatement                                       = 1580;
    public static int ErrCantRenameLogTable                                    = 1581;
    public static int ErrWrongParamcountToNativeFct                            = 1582;
    public static int ErrWrongParametersToNativeFct                            = 1583;
    public static int ErrWrongParametersToStoredFct                            = 1584;
    public static int ErrNativeFctNameCollision                                = 1585;
    public static int ErrDupEntryWithKeyName                                   = 1586;
    public static int ErrBinlogPurgeEmFile                                     = 1587;
    public static int ErrEventCannotCreateInThePast                            = 1588;
    public static int ErrEventCannotAlterInThePast                             = 1589;
    public static int ErrSlaveIncident                                         = 1590;
    public static int ErrNoPartitionForGivenValueSilent                        = 1591;
    public static int ErrBinlogUnsafeStatement                                 = 1592;
    public static int ErrSlaveFatal                                            = 1593;
    public static int ErrSlaveRelayLogReadFailure                              = 1594;
    public static int ErrSlaveRelayLogWriteFailure                             = 1595;
    public static int ErrSlaveCreateEventFailure                               = 1596;
    public static int ErrSlaveMasterComFailure                                 = 1597;
    public static int ErrBinlogLoggingImpossible                               = 1598;
    public static int ErrViewNoCreationCtx                                     = 1599;
    public static int ErrViewInvalidCreationCtx                                = 1600;
    public static int ErrSrInvalidCreationCtx                                  = 1601;
    public static int ErrTrgCorruptedFile                                      = 1602;
    public static int ErrTrgNoCreationCtx                                      = 1603;
    public static int ErrTrgInvalidCreationCtx                                 = 1604;
    public static int ErrEventInvalidCreationCtx                               = 1605;
    public static int ErrTrgCantOpenTable                                      = 1606;
    public static int ErrCantCreateSroutine                                    = 1607;
    public static int ErrNeverUsed                                             = 1608;
    public static int ErrNoFormatDescriptionEventBeforeBinlogStatement         = 1609;
    public static int ErrSlaveCorruptEvent                                     = 1610;
    public static int ErrLoadDataInvalidColumn                                 = 1611;
    public static int ErrLogPurgeNoFile                                        = 1612;
    public static int ErrXaRbtimeout                                           = 1613;
    public static int ErrXaRbdeadlock                                          = 1614;
    public static int ErrNeedReprepare                                         = 1615;
    public static int ErrDelayedNotSupported                                   = 1616;
    public static int WarnNoMasterInfo                                         = 1617;
    public static int WarnOptionIgnored                                        = 1618;
    public static int WarnPluginDeleteBuiltin                                  = 1619;
    public static int WarnPluginBusy                                           = 1620;
    public static int ErrVariableIsReadonly                                    = 1621;
    public static int ErrWarnEngineTransactionRollback                         = 1622;
    public static int ErrSlaveHeartbeatFailure                                 = 1623;
    public static int ErrSlaveHeartbeatValueOutOfRange                         = 1624;
    public static int ErrNdbReplicationSchema                                  = 1625;
    public static int ErrConflictFnParse                                       = 1626;
    public static int ErrExceptionsWrite                                       = 1627;
    public static int ErrTooLongTableComment                                   = 1628;
    public static int ErrTooLongFieldComment                                   = 1629;
    public static int ErrFuncInexistentNameCollision                           = 1630;
    public static int ErrDatabaseName                                          = 1631;
    public static int ErrTableName                                             = 1632;
    public static int ErrPartitionName                                         = 1633;
    public static int ErrSubpartitionName                                      = 1634;
    public static int ErrTemporaryName                                         = 1635;
    public static int ErrRenamedName                                           = 1636;
    public static int ErrTooManyConcurrentTrxs                                 = 1637;
    public static int WarnNonASCIISeparatorNotImplemented                      = 1638;
    public static int ErrDebugSyncTimeout                                      = 1639;
    public static int ErrDebugSyncHitLimit                                     = 1640;
    public static int ErrDupSignalSet                                          = 1641;
    public static int ErrSignalWarn                                            = 1642;
    public static int ErrSignalNotFound                                        = 1643;
    public static int ErrSignalException                                       = 1644;
    public static int ErrResignalWithoutActiveHandler                          = 1645;
    public static int ErrSignalBadConditionType                                = 1646;
    public static int WarnCondItemTruncated                                    = 1647;
    public static int ErrCondItemTooLong                                       = 1648;
    public static int ErrUnknownLocale                                         = 1649;
    public static int ErrSlaveIgnoreServerIds                                  = 1650;
    public static int ErrQueryCacheDisabled                                    = 1651;
    public static int ErrSameNamePartitionField                                = 1652;
    public static int ErrPartitionColumnList                                   = 1653;
    public static int ErrWrongTypeColumnValue                                  = 1654;
    public static int ErrTooManyPartitionFuncFields                            = 1655;
    public static int ErrMaxvalueInValuesIn                                    = 1656;
    public static int ErrTooManyValues                                         = 1657;
    public static int ErrRowSinglePartitionField                               = 1658;
    public static int ErrFieldTypeNotAllowedAsPartitionField                   = 1659;
    public static int ErrPartitionFieldsTooLong                                = 1660;
    public static int ErrBinlogRowEngineAndStmtEngine                          = 1661;
    public static int ErrBinlogRowModeAndStmtEngine                            = 1662;
    public static int ErrBinlogUnsafeAndStmtEngine                             = 1663;
    public static int ErrBinlogRowInjectionAndStmtEngine                       = 1664;
    public static int ErrBinlogStmtModeAndRowEngine                            = 1665;
    public static int ErrBinlogRowInjectionAndStmtMode                         = 1666;
    public static int ErrBinlogMultipleEnginesAndSelfLoggingEngine             = 1667;
    public static int ErrBinlogUnsafeLimit                                     = 1668;
    public static int ErrBinlogUnsafeInsertDelayed                             = 1669;
    public static int ErrBinlogUnsafeSystemTable                               = 1670;
    public static int ErrBinlogUnsafeAutoincColumns                            = 1671;
    public static int ErrBinlogUnsafeUdf                                       = 1672;
    public static int ErrBinlogUnsafeSystemVariable                            = 1673;
    public static int ErrBinlogUnsafeSystemFunction                            = 1674;
    public static int ErrBinlogUnsafeNontransAfterTrans                        = 1675;
    public static int ErrMessageAndStatement                                   = 1676;
    public static int ErrSlaveConversionFailed                                 = 1677;
    public static int ErrSlaveCantCreateConversion                             = 1678;
    public static int ErrInsideTransactionPreventsSwitchBinlogFormat           = 1679;
    public static int ErrPathLength                                            = 1680;
    public static int ErrWarnDeprecatedSyntaxNoReplacement                     = 1681;
    public static int ErrWrongNativeTableStructure                             = 1682;
    public static int ErrWrongPerfSchemaUsage                                  = 1683;
    public static int ErrWarnISSkippedTable                                    = 1684;
    public static int ErrInsideTransactionPreventsSwitchBinlogDirect           = 1685;
    public static int ErrStoredFunctionPreventsSwitchBinlogDirect              = 1686;
    public static int ErrSpatialMustHaveGeomCol                                = 1687;
    public static int ErrTooLongIndexComment                                   = 1688;
    public static int ErrLockAborted                                           = 1689;
    public static int ErrDataOutOfRange                                        = 1690;
    public static int ErrWrongSpvarTypeInLimit                                 = 1691;
    public static int ErrBinlogUnsafeMultipleEnginesAndSelfLoggingEngine       = 1692;
    public static int ErrBinlogUnsafeMixedStatement                            = 1693;
    public static int ErrInsideTransactionPreventsSwitchSQLLogBin              = 1694;
    public static int ErrStoredFunctionPreventsSwitchSQLLogBin                 = 1695;
    public static int ErrFailedReadFromParFile                                 = 1696;
    public static int ErrValuesIsNotIntType                                    = 1697;
    public static int ErrAccessDeniedNoPassword                                = 1698;
    public static int ErrSetPasswordAuthPlugin                                 = 1699;
    public static int ErrGrantPluginUserExists                                 = 1700;
    public static int ErrTruncateIllegalForeignKey                             = 1701;
    public static int ErrPluginIsPermanent                                     = 1702;
    public static int ErrSlaveHeartbeatValueOutOfRangeMin                      = 1703;
    public static int ErrSlaveHeartbeatValueOutOfRangeMax                      = 1704;
    public static int ErrStmtCacheFull                                         = 1705;
    public static int ErrMultiUpdateKeyConflict                                = 1706;
    public static int ErrTableNeedsRebuild                                     = 1707;
    public static int WarnOptionBelowLimit                                     = 1708;
    public static int ErrIndexColumnTooLong                                    = 1709;
    public static int ErrErrorInTriggerBody                                    = 1710;
    public static int ErrErrorInUnknownTriggerBody                             = 1711;
    public static int ErrIndexCorrupt                                          = 1712;
    public static int ErrUndoRecordTooBig                                      = 1713;
    public static int ErrBinlogUnsafeInsertIgnoreSelect                        = 1714;
    public static int ErrBinlogUnsafeInsertSelectUpdate                        = 1715;
    public static int ErrBinlogUnsafeReplaceSelect                             = 1716;
    public static int ErrBinlogUnsafeCreateIgnoreSelect                        = 1717;
    public static int ErrBinlogUnsafeCreateReplaceSelect                       = 1718;
    public static int ErrBinlogUnsafeUpdateIgnore                              = 1719;
    public static int ErrPluginNoUninstall                                     = 1720;
    public static int ErrPluginNoInstall                                       = 1721;
    public static int ErrBinlogUnsafeWriteAutoincSelect                        = 1722;
    public static int ErrBinlogUnsafeCreateSelectAutoinc                       = 1723;
    public static int ErrBinlogUnsafeInsertTwoKeys                             = 1724;
    public static int ErrTableInFkCheck                                        = 1725;
    public static int ErrUnsupportedEngine                                     = 1726;
    public static int ErrBinlogUnsafeAutoincNotFirst                           = 1727;
    public static int ErrCannotLoadFromTableV2                                 = 1728;
    public static int ErrMasterDelayValueOutOfRange                            = 1729;
    public static int ErrOnlyFdAndRbrEventsAllowedInBinlogStatement            = 1730;
    public static int ErrPartitionExchangeDifferentOption                      = 1731;
    public static int ErrPartitionExchangePartTable                            = 1732;
    public static int ErrPartitionExchangeTempTable                            = 1733;
    public static int ErrPartitionInsteadOfSubpartition                        = 1734;
    public static int ErrUnknownPartition                                      = 1735;
    public static int ErrTablesDifferentMetadata                               = 1736;
    public static int ErrRowDoesNotMatchPartition                              = 1737;
    public static int ErrBinlogCacheSizeGreaterThanMax                         = 1738;
    public static int ErrWarnIndexNotApplicable                                = 1739;
    public static int ErrPartitionExchangeForeignKey                           = 1740;
    public static int ErrNoSuchKeyValue                                        = 1741;
    public static int ErrRplInfoDataTooLong                                    = 1742;
    public static int ErrNetworkReadEventChecksumFailure                       = 1743;
    public static int ErrBinlogReadEventChecksumFailure                        = 1744;
    public static int ErrBinlogStmtCacheSizeGreaterThanMax                     = 1745;
    public static int ErrCantUpdateTableInCreateTableSelect                    = 1746;
    public static int ErrPartitionClauseOnNonpartitioned                       = 1747;
    public static int ErrRowDoesNotMatchGivenPartitionSet                      = 1748;
    public static int ErrNoSuchPartitionunused                                 = 1749;
    public static int ErrChangeRplInfoRepositoryFailure                        = 1750;
    public static int ErrWarningNotCompleteRollbackWithCreatedTempTable        = 1751;
    public static int ErrWarningNotCompleteRollbackWithDroppedTempTable        = 1752;
    public static int ErrMtsFeatureIsNotSupported                              = 1753;
    public static int ErrMtsUpdatedDBsGreaterMax                               = 1754;
    public static int ErrMtsCantParallel                                       = 1755;
    public static int ErrMtsInconsistentData                                   = 1756;
    public static int ErrFulltextNotSupportedWithPartitioning                  = 1757;
    public static int ErrDaInvalidConditionNumber                              = 1758;
    public static int ErrInsecurePlainText                                     = 1759;
    public static int ErrInsecureChangeMaster                                  = 1760;
    public static int ErrForeignDuplicateKeyWithChildInfo                      = 1761;
    public static int ErrForeignDuplicateKeyWithoutChildInfo                   = 1762;
    public static int ErrSQLthreadWithSecureSlave                              = 1763;
    public static int ErrTableHasNoFt                                          = 1764;
    public static int ErrVariableNotSettableInSfOrTrigger                      = 1765;
    public static int ErrVariableNotSettableInTransaction                      = 1766;
    public static int ErrGtidNextIsNotInGtidNextList                           = 1767;
    public static int ErrCantChangeGtidNextInTransactionWhenGtidNextListIsNull = 1768;
    public static int ErrSetStatementCannotInvokeFunction                      = 1769;
    public static int ErrGtidNextCantBeAutomaticIfGtidNextListIsNonNull        = 1770;
    public static int ErrSkippingLoggedTransaction                             = 1771;
    public static int ErrMalformedGtidSetSpecification                         = 1772;
    public static int ErrMalformedGtidSetEncoding                              = 1773;
    public static int ErrMalformedGtidSpecification                            = 1774;
    public static int ErrGnoExhausted                                          = 1775;
    public static int ErrBadSlaveAutoPosition                                  = 1776;
    public static int ErrAutoPositionRequiresGtidModeOn                        = 1777;
    public static int ErrCantDoImplicitCommitInTrxWhenGtidNextIsSet            = 1778;
    public static int ErrGtidMode2Or3RequiresEnforceGtidConsistencyOn          = 1779;
    public static int ErrGtidModeRequiresBinlog                                = 1780;
    public static int ErrCantSetGtidNextToGtidWhenGtidModeIsOff                = 1781;
    public static int ErrCantSetGtidNextToAnonymousWhenGtidModeIsOn            = 1782;
    public static int ErrCantSetGtidNextListToNonNullWhenGtidModeIsOff         = 1783;
    public static int ErrFoundGtidEventWhenGtidModeIsOff                       = 1784;
    public static int ErrGtidUnsafeNonTransactionalTable                       = 1785;
    public static int ErrGtidUnsafeCreateSelect                                = 1786;
    public static int ErrGtidUnsafeCreateDropTemporaryTableInTransaction       = 1787;
    public static int ErrGtidModeCanOnlyChangeOneStepAtATime                   = 1788;
    public static int ErrMasterHasPurgedRequiredGtids                          = 1789;
    public static int ErrCantSetGtidNextWhenOwningGtid                         = 1790;
    public static int ErrUnknownExplainFormat                                  = 1791;
    public static int ErrCantExecuteInReadOnlyTransaction                      = 1792;
    public static int ErrTooLongTablePartitionComment                          = 1793;
    public static int ErrSlaveConfiguration                                    = 1794;
    public static int ErrInnodbFtLimit                                         = 1795;
    public static int ErrInnodbNoFtTempTable                                   = 1796;
    public static int ErrInnodbFtWrongDocidColumn                              = 1797;
    public static int ErrInnodbFtWrongDocidIndex                               = 1798;
    public static int ErrInnodbOnlineLogTooBig                                 = 1799;
    public static int ErrUnknownAlterAlgorithm                                 = 1800;
    public static int ErrUnknownAlterLock                                      = 1801;
    public static int ErrMtsChangeMasterCantRunWithGaps                        = 1802;
    public static int ErrMtsRecoveryFailure                                    = 1803;
    public static int ErrMtsResetWorkers                                       = 1804;
    public static int ErrColCountDoesntMatchCorruptedV2                        = 1805;
    public static int ErrSlaveSilentRetryTransaction                           = 1806;
    public static int ErrDiscardFkChecksRunning                                = 1807;
    public static int ErrTableSchemaMismatch                                   = 1808;
    public static int ErrTableInSystemTablespace                               = 1809;
    public static int ErrIoRead                                                = 1810;
    public static int ErrIoWrite                                               = 1811;
    public static int ErrTablespaceMissing                                     = 1812;
    public static int ErrTablespaceExists                                      = 1813;
    public static int ErrTablespaceDiscarded                                   = 1814;
    public static int ErrInternal                                              = 1815;
    public static int ErrInnodbImport                                          = 1816;
    public static int ErrInnodbIndexCorrupt                                    = 1817;
    public static int ErrInvalidYearColumnLength                               = 1818;
    public static int ErrNotValidPassword                                      = 1819;
    public static int ErrMustChangePassword                                    = 1820;
    public static int ErrFkNoIndexChild                                        = 1821;
    public static int ErrForeignKeyNoIndexInParent                             = 1822;
    public static int ErrFkFailAddSystem                                       = 1823;
    public static int ErrForeignKeyCannotOpenParent                            = 1824;
    public static int ErrFkIncorrectOption                                     = 1825;
    public static int ErrFkDupName                                             = 1826;
    public static int ErrPasswordFormat                                        = 1827;
    public static int ErrFkColumnCannotDrop                                    = 1828;
    public static int ErrFkColumnCannotDropChild                               = 1829;
    public static int ErrForeignKeyColumnNotNull                               = 1830;
    public static int ErrDupIndex                                              = 1831;
    public static int ErrForeignKeyColumnCannotChange                          = 1832;
    public static int ErrForeignKeyColumnCannotChangeChild                     = 1833;
    public static int ErrFkCannotDeleteParent                                  = 1834;
    public static int ErrMalformedPacket                                       = 1835;
    public static int ErrReadOnlyMode                                          = 1836;
    public static int ErrGtidNextTypeUndefinedGroup                            = 1837;
    public static int ErrVariableNotSettableInSp                               = 1838;
    public static int ErrCantSetGtidPurgedWhenGtidModeIsOff                    = 1839;
    public static int ErrCantSetGtidPurgedWhenGtidExecutedIsNotEmpty           = 1840;
    public static int ErrCantSetGtidPurgedWhenOwnedGtidsIsNotEmpty             = 1841;
    public static int ErrGtidPurgedWasChanged                                  = 1842;
    public static int ErrGtidExecutedWasChanged                                = 1843;
    public static int ErrBinlogStmtModeAndNoReplTables                         = 1844;
    public static int ErrAlterOperationNotSupported                            = 1845;
    public static int ErrAlterOperationNotSupportedReason                      = 1846;
    public static int ErrAlterOperationNotSupportedReasonCopy                  = 1847;
    public static int ErrAlterOperationNotSupportedReasonPartition             = 1848;
    public static int ErrAlterOperationNotSupportedReasonFkRename              = 1849;
    public static int ErrAlterOperationNotSupportedReasonColumnType            = 1850;
    public static int ErrAlterOperationNotSupportedReasonFkCheck               = 1851;
    public static int ErrAlterOperationNotSupportedReasonIgnore                = 1852;
    public static int ErrAlterOperationNotSupportedReasonNopk                  = 1853;
    public static int ErrAlterOperationNotSupportedReasonAutoinc               = 1854;
    public static int ErrAlterOperationNotSupportedReasonHiddenFts             = 1855;
    public static int ErrAlterOperationNotSupportedReasonChangeFts             = 1856;
    public static int ErrAlterOperationNotSupportedReasonFts                   = 1857;
    public static int ErrSQLSlaveSkipCounterNotSettableInGtidMode              = 1858;
    public static int ErrDupUnknownInIndex                                     = 1859;
    public static int ErrIdentCausesTooLongPath                                = 1860;
    public static int ErrAlterOperationNotSupportedReasonNotNull               = 1861;
    public static int ErrMustChangePasswordLogin                               = 1862;
    public static int ErrRowInWrongPartition                                   = 1863;
    public static int ErrErrorLast                                             = 1863;
    public static int ErrMaxExecTimeExceeded                                   = 1907;
    public static int ErrInvalidFieldSize                                      = 3013;
    public static int ErrPasswordExpireAnonymousUser                           = 3016;
    public static int ErrIncorrectType                                         = 3064;
    public static int ErrInvalidJSONData                                       = 3069;
    public static int ErrGeneratedColumnFunctionIsNotAllowed                   = 3102;
    public static int ErrUnsupportedAlterInplaceOnVirtualColumn                = 3103;
    public static int ErrWrongFKOptionForGeneratedColumn                       = 3104;
    public static int ErrBadGeneratedColumn                                    = 3105;
    public static int ErrUnsupportedOnGeneratedColumn                          = 3106;
    public static int ErrGeneratedColumnNonPrior                               = 3107;
    public static int ErrDependentByGeneratedColumn                            = 3108;
    public static int ErrGeneratedColumnRefAutoInc                             = 3109;
    public static int ErrInvalidJSONText                                       = 3140;
    public static int ErrInvalidJSONPath                                       = 3143;
    public static int ErrInvalidTypeForJSON                                    = 3146;
    public static int ErrInvalidJSONPathWildcard                               = 3149;
    public static int ErrInvalidJSONContainsPathType                           = 3150;
    public static int ErrJSONUsedAsKey                                         = 3152;
    public static int ErrJSONDocumentNULLKey                                   = 3158;
    public static int ErrBadUser                                               = 3162;
    public static int ErrUserAlreadyExists                                     = 3163;
    public static int ErrInvalidJSONPathArrayCell                              = 3165;
    public static int ErrInvalidEncryptionOption                               = 3184;
    public static int ErrRoleNotGranted                                        = 3530;
    public static int ErrLockAcquireFailAndNoWaitSet                           = 3572;
    public static int ErrWindowNoSuchWindow                                    = 3579;
    public static int ErrWindowCircularityInWindowGraph                        = 3580;
    public static int ErrWindowNoChildPartitioning                             = 3581;
    public static int ErrWindowNoInherentFrame                                 = 3582;
    public static int ErrWindowNoRedefineOrderBy                               = 3583;
    public static int ErrWindowFrameStartIllegal                               = 3584;
    public static int ErrWindowFrameEndIllegal                                 = 3585;
    public static int ErrWindowFrameIllegal                                    = 3586;
    public static int ErrWindowRangeFrameOrderType                             = 3587;
    public static int ErrWindowRangeFrameTemporalType                          = 3588;
    public static int ErrWindowRangeFrameNumericType                           = 3589;
    public static int ErrWindowRangeBoundNotConstant                           = 3590;
    public static int ErrWindowDuplicateName                                   = 3591;
    public static int ErrWindowIllegalOrderBy                                  = 3592;
    public static int ErrWindowInvalidWindowFuncUse                            = 3593;
    public static int ErrWindowInvalidWindowFuncAliasUse                       = 3594;
    public static int ErrWindowNestedWindowFuncUseInWindowSpec                 = 3595;
    public static int ErrWindowRowsIntervalUse                                 = 3596;
    public static int ErrWindowNoGroupOrderUnused                              = 3597;
    public static int ErrWindowExplainJson                                     = 3598; //nolint: revive
    public static int ErrWindowFunctionIgnoresFrame                            = 3599;
    public static int ErrDataTruncatedFunctionalIndex                          = 3751;
    public static int ErrDataOutOfRangeFunctionalIndex                         = 3752;
    public static int ErrFunctionalIndexOnJsonOrGeometryFunction               = 3753; //nolint: revive
    public static int ErrFunctionalIndexRefAutoIncrement                       = 3754;
    public static int ErrCannotDropColumnFunctionalIndex                       = 3755;
    public static int ErrFunctionalIndexPrimaryKey                             = 3756;
    public static int ErrFunctionalIndexOnLob                                  = 3757;
    public static int ErrFunctionalIndexFunctionIsNotAllowed                   = 3758;
    public static int ErrFulltextFunctionalIndex                               = 3759;
    public static int ErrSpatialFunctionalIndex                                = 3760;
    public static int ErrWrongKeyColumnFunctionalIndex                         = 3761;
    public static int ErrFunctionalIndexOnField                                = 3762;
    public static int ErrFKIncompatibleColumns                                 = 3780;
    public static int ErrFunctionalIndexRowValueIsNotAllowed                   = 3800;
    public static int ErrDependentByFunctionalIndex                            = 3837;
    public static int ErrInvalidJsonValueForFuncIndex                          = 3903;
    public static int ErrJsonValueOutOfRangeForFuncIndex                       = 3904;
    public static int ErrFunctionalIndexDataIsTooLong                          = 3907;
    public static int ErrFunctionalIndexNotApplicable                          = 3909;
    public static int ErrOnlyOneDefaultPartionAllowed         = 4030;
    public static int ErrWrongPartitionTypeExpectedSystemTime = 4113;
    public static int ErrSystemVersioningWrongPartitions      = 4128;
    public static int ErrSequenceRunOut                       = 4135;
    public static int ErrSequenceInvalidData                  = 4136;
    public static int ErrSequenceAccessFail                   = 4137;
    public static int ErrNotSequence                          = 4138;
    public static int ErrUnknownSequence                      = 4139;
    public static int ErrWrongInsertIntoSequence              = 4140;
    public static int ErrSequenceInvalidTableStructure        = 4141;
    public static int ErrWarnOptimizerHintUnsupportedHint = 8061;
    public static int ErrWarnOptimizerHintInvalidToken    = 8062;
    public static int ErrWarnMemoryQuotaOverflow          = 8063;
    public static int ErrWarnOptimizerHintParseError      = 8064;
    public static int ErrWarnOptimizerHintInvalidInteger  = 8065;

    public static int ErrUnsupportedDDLOperation = 8200;
    public static int ErrUnsupportedModifyVec = 8201;
    public static int ErrModifyColumnNotTran = 8202;
    public static int ErrNotFoundDropTable = 8203;
    public static int ErrNotFoundDropSchema = 8204;

    public static int ErrWaitReorgTimeout = 8206;
    public static int ErrInvalidDDLState = 8210;

    public static int ErrCancelledDDLJob = 8214;
}
