/*
 * Copyright 2021 DataCanvas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dingodb.calcite.utils;

import io.dingodb.common.util.Optional;
import io.dingodb.exec.transaction.base.ITransaction;
import io.dingodb.store.api.transaction.data.IsolationLevel;
import io.dingodb.tso.TsoService;
import org.apache.calcite.sql.SqlKind;

public final class VisitUtils {

    private VisitUtils() {
    }

    public static long getScanTs(ITransaction transaction, SqlKind kind, long pointStartTs) {
        if (transaction == null) {
            return 0;
        }
        if (pointStartTs > 0) {
            return pointStartTs;
        }
        long scanTs = Optional.ofNullable(transaction).map(ITransaction::getStartTs).orElse(0L);
        // Use current read
        if (transaction.isPessimistic()
            && IsolationLevel.of(transaction.getIsolationLevel()) == IsolationLevel.SnapshotIsolation
            && (kind == SqlKind.INSERT
            || kind == SqlKind.DELETE
            || kind == SqlKind.UPDATE)) {
            scanTs = TsoService.getDefault().tso();
        }
        if (transaction.isPessimistic()
            && IsolationLevel.of(transaction.getIsolationLevel()) == IsolationLevel.ReadCommitted
            && (kind == SqlKind.SELECT
            || kind == SqlKind.UPDATE)) {
            scanTs = TsoService.getDefault().tso();
        }
        return scanTs;
    }
}
