﻿namespace GarageBuddy.Common.Constants
{
    public static class ControllersAndActionsConstants
    {
        public static class Controllers
        {
            /// <summary>
            /// A string representing the home controller.
            /// </summary>
            public const string Home = "Home";

            /// <summary>
            /// A string representing the user controller.
            /// </summary>
            public const string User = "User";
        }

        public static class Actions
        {
            // Common actions

            /// <summary>
            /// A string representing the index action.
            /// </summary>
            public const string Index = "Index";

            /// <summary>
            /// A string representing the create action.
            /// </summary>
            public const string Create = "Create";

            /// <summary>
            /// A string representing the details action.
            /// </summary>
            public const string Details = "Details";

            /// <summary>
            /// A string representing the edit action.
            /// </summary>
            public const string Edit = "Edit";

            /// <summary>
            /// A string representing the delete action.
            /// </summary>
            public const string Delete = "Delete";

            // User controller actions

            /// <summary>
            /// A string representing the login action.
            /// </summary>
            public const string Login = "Login";

            /// <summary>
            /// A string representing the register action.
            /// </summary>
            public const string Register = "Register";

            /// <summary>
            /// A string representing the logout action.
            /// </summary>
            public const string Logout = "Logout";

            /// <summary>
            /// A string representing the forgot password action.
            /// </summary>
            public const string ForgotPassword = "ForgotPassword";

            // Home controller actions

            /// <summary>
            /// A string representing the error action.
            /// </summary>
            public const string Error = "Error";
        }
    }
}
