# 中文自然语言处理

中文自然语言处理相关的开放任务，数据集, 以及当前最佳结果

## 任务列表

- [Co-reference Resolution](docs/co-reference_resolution.md) 
- [Dialogue State Management](docs/dialogue_state_management.md)
- [Emotion Classification](docs/emotion_classification.md)
- [Entity Linking](docs/entity_linking.md)
- [Entity Tagging](docs/entity_tagging.md)
- [Language Modeling](docs/language_modeling.md) 
- [Machine Translation](docs/machine_translation.md)
- [Multi-task Learning](docs/multi-task_learning.md)
- [Part-of-Speech (POS) Tagging](docs/pos_tagging.md)
- [Question Answering](docs/question_answering.md)
- [Relation Extraction](docs/relation_extraction.md)
- [Sentiment Analysis](docs/sentiment_analysis.md)
- [Simplified/Traditional Conversion](docs/simplified_traditional_Chinese_conversion.md)
- [Spell Correction](docs/spell_correction.md)
- [Text Summarization](docs/text_summarization.md)
- [Topic Classification](docs/topic_classification.md)
- [Transliteration](docs/transliteration.md)
- [Word Embedding](docs/word_embedding.md)
- [Word Segmentation](docs/word_segmentation.md)

### 其他语言

对于跟踪英语和其他语言自然语言处理领域的进展, [NLP-progress](http://nlpprogress.com/) 是一个非常好的项目, 它包括了大部分自然语言处理任务以及每个任务相关的开放任务，数据集, 以及当前最佳结果.

## 新闻!

我们将在今年的WMT2021上举办`Triangular MT: Using English to improve Russian-to-Chinese machine translation`中俄双向机器翻译挑战。WMT 2021将于2021年11月10-11号举行。

任务详细介绍请参考 http://www.statmt.org/wmt21/triangular-mt-task.html 

欢迎踊跃参加！

重要时间节点

- Apr 5, 2021:  Release of training and development resources 
- Apr 5, 2021:  Release of the baseline system
- Jul 12, 2021: Release of test data
- Jul 19, 2021: Official submissions due by web upload
- Jul 20, 2021: Release of the official results
- Aug 5, 2021:  System description paper due
- Sep 5, 2021:  Review feedback
- Sep 15, 2021: Camera-ready papers due
- Nov 10-11, 2021: Workshop 

## 参与贡献

想要参与贡献? 请遵循[贡献指南](contribute.md)

## 联系我们

**建议? 修改? 请发邮件到[chinesenlp.xyz@gmail.com](mailto:chinesenlp.xyz@gmail.com)**

## 备注

本项目由[滴滴人工智能实验室](https://www.didiglobal.com/science/ailabs)所属的自然语言处理团队创建并维护。

<img src="../img/ailabs-logo.png" height="80px"></img>

