# Chinese NLP

Shared tasks, datasets and state-of-the-art results for Chinese Natural Language Processing (NLP)

## Table of Tasks

- [Co-reference Resolution](docs/co-reference_resolution.md) 
- [Constituency Parsing](docs/constituency_parsing.md)
- [Dialogue State Management](docs/dialogue_state_management.md)
- [Emotion Classification](docs/emotion_classification.md)
- [Entity Linking](docs/entity_linking.md)
- [Entity Tagging](docs/entity_tagging.md)
- [Language Modeling](docs/language_modeling.md) 
- [Machine Translation](docs/machine_translation.md)
- [Multi-task Learning](docs/multi-task_learning.md)
- [Part-of-Speech (POS) Tagging](docs/pos_tagging.md)
- [Question Answering](docs/question_answering.md)
- [Relation Extraction](docs/relation_extraction.md)
- [Sentiment Analysis](docs/sentiment_analysis.md)
- [Simplified/Traditional Conversion](docs/simplified_traditional_Chinese_conversion.md)
- [Spell Correction](docs/spell_correction.md)
- [Text Summarization](docs/text_summarization.md)
- [Topic Classification](docs/topic_classification.md)
- [Transliteration](docs/transliteration.md)
- [Word Embedding](docs/word_embedding.md)
- [Word Segmentation](docs/word_segmentation.md)

### Besides Chinese NLP

To track more progress in Natural Language Processing (NLP) in English and other languages, you can check [NLP-progress](http://nlpprogress.com/), which includes the datasets and the current state-of-the-art for the most common NLP tasks.

## What's new!

We have a new shared task at this year's WMT titled "Triangular MT: Using English to improve Russian-to-Chinese machine translation". We would encourage you to participate in this shared task.

More details of the shared task is present at http://www.statmt.org/wmt21/triangular-mt-task.html 

Please pass on the pointer to any of your colleagues and friends who might be interested in participating. 

Important Dates

- Apr 5, 2021:  Release of training and development resources 
- Apr 5, 2021:  Release of the baseline system
- Jul 12, 2021: Release of test data
- Jul 19, 2021: Official submissions due by web upload
- Jul 20, 2021: Release of the official results
- Aug 5, 2021:  System description paper due
- Sep 5, 2021:  Review feedback
- Sep 15, 2021: Camera-ready papers due
- Nov 10-11, 2021: Workshop 

## Contribute

Want to contribute? Please follow the [Instructions](contribute.md)

## Contact

**Suggestions? Changes? Please send email to [chinesenlp.xyz@gmail.com](mailto:chinesenlp.xyz@gmail.com)**




## Note

This project is initiated and actively maintained by **DiDi NLP team** under [DiDi AI Labs](https://www.didiglobal.com/science/ailabs).

<img src="img/ailabs-logo.png" height="80px"></img>



