//
//  AoECrypto.m
//  AoE
//
//  Created by dingchao on 2019/8/19.
//

#import "AoECryptoUtil.h"
#import "AoEValidJudge.h"
#import <CommonCrypto/CommonCryptor.h>
#import <CommonCrypto/CommonDigest.h>
#import "aoecrypt.h"
#import "aoesign.h"
//#incude <aoesign/aoesign.h>

#define CC_MD5_DIGEST_LENGTH    16          /* digest length in bytes */
#define VERSION 1
#define AOE_DEFAULT_KEY @"0000000000000000"
#define AOE_DEFAULT_IV @"0101010101010101"

@implementation AoECryptoUtil

+ (NSString *)aoe_encryptMD5Data:(NSData *)data {
    unsigned char result[CC_MD5_DIGEST_LENGTH];
    CC_MD5(data.bytes, (CC_LONG)data.length, result);
    
    return [[NSString stringWithFormat:
             @"%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
             result[0], result[1], result[2], result[3],
             result[4], result[5], result[6], result[7],
             result[8], result[9], result[10], result[11],
             result[12], result[13], result[14], result[15]
             ] lowercaseString];
}

+ (NSString *)aoe_encryptStringBase64Data:(NSData *)data {
    return [data base64EncodedStringWithOptions:0];
}

+ (NSData *)aoe_encryptDataBase64Data:(NSData *)data {
    return [data base64EncodedDataWithOptions:0];
}

+ (NSData *)aoe_encryptAES128Data:(NSData *)data key:(NSString *)key iv:(NSData *)iv {
    // 'key' should be 32 bytes for AES256, will be null-padded otherwise
    const int keySize = 16;
    char keyPtr[16 + 1]; // room for terminator (unused)
    bzero( keyPtr, sizeof( keyPtr ) ); // fill with zeroes (for padding)
    
    // fetch key data
    [key getCString:keyPtr maxLength:sizeof( keyPtr ) encoding:NSUTF8StringEncoding];
    
    NSUInteger dataLength = [data length];
    
    //See the doc: For block ciphers, the output size will always be less than or
    //equal to the input size plus the size of one block.
    //That's why we need to add the size of one block here
    size_t bufferSize = dataLength + kCCBlockSizeAES128;
    void *buffer = malloc( bufferSize );
    
    size_t numBytesEncrypted = 0;
    CCCryptorStatus cryptStatus = CCCrypt( kCCEncrypt, kCCAlgorithmAES128, kCCOptionPKCS7Padding,
                                          keyPtr, keySize,
                                          iv ? iv.bytes:NULL,
                                          [data bytes], dataLength, /* input */
                                          buffer, bufferSize, /* output */
                                          &numBytesEncrypted );
    if ( cryptStatus == kCCSuccess ) {
        //the returned NSData takes ownership of the buffer and will free it on deallocation
        return [NSData dataWithBytesNoCopy:buffer length:numBytesEncrypted];
    }
    
    free( buffer ); //free the buffer
    return nil;


}
+ (NSData *)aoe_decryptAES128Data:(NSData *)data key:(NSString *)key iv:(NSData *)iv
{
    // 'key' should be 32 bytes for AES256, will be null-padded otherwise
    const int keySize = 16;
    char keyPtr[17]; // room for terminator (unused)
    bzero( keyPtr, sizeof( keyPtr ) ); // fill with zeroes (for padding)
    
    // fetch key data
    [key getCString:keyPtr maxLength:sizeof( keyPtr ) encoding:NSUTF8StringEncoding];
    
    NSUInteger dataLength = [data length];
    
    //See the doc: For block ciphers, the output size will always be less than or
    //equal to the input size plus the size of one block.
    //That's why we need to add the size of one block here
    size_t bufferSize = dataLength + kCCBlockSizeAES128;
    void *buffer = malloc( bufferSize );
    
    size_t numBytesDecrypted = 0;
    CCCryptorStatus cryptStatus = CCCrypt( kCCDecrypt, kCCAlgorithmAES128, kCCOptionPKCS7Padding,
                                          keyPtr, keySize,
                                          iv ? iv.bytes:NULL,
                                          [data bytes], dataLength, /* input */
                                          buffer, bufferSize, /* output */
                                          &numBytesDecrypted );
    
    if ( cryptStatus == kCCSuccess ) {
        //the returned NSData takes ownership of the buffer and will free it on deallocation
        return [NSData dataWithBytesNoCopy:buffer length:numBytesDecrypted];
    }
    
    free( buffer ); //free the buffer
    return nil;

}

+ (NSData *)aoe_decryptAoEModel:(NSData *)soure
                     encryptKey:(NSString *)key
                         offset:(NSData *)iv
                       saltType:(AoECryptoType)type {
    if (!soure) {
        return nil;
    }
    
    NSData *distData = nil;
    if (AoECryptoTypeForAES128 == type) {
        const char *dencryptDataBytes = NULL;
        int len = dencryptAoeData(soure.bytes, (int)soure.length, &dencryptDataBytes);
        if (len > 0 && len < soure.length) {
            NSData *decryptData = [NSData dataWithBytes:dencryptDataBytes length:len];
            NSString *decryptKey = ([AoEValidJudge isValidString:key] ? key : AOE_DEFAULT_KEY);
            NSData *ivData = iv.length > 0 ? iv : [AOE_DEFAULT_IV dataUsingEncoding:NSUTF8StringEncoding];
            distData = [self aoe_decryptAES128Data:decryptData
                                               key:decryptKey
                                                iv:ivData];
        }
    }
    return distData;
}

+ (NSData *)aoe_encryptAoEModel:(NSData *)soure
                     encryptKey:(NSString *)key
                         offset:(NSData *)iv
                       saltType:(AoECryptoType)type {
    if (!soure) {
        return nil;
    }
    NSData *distData = nil;
    if (AoECryptoTypeForAES128 == type) {
        const char *distDataBytes = NULL;
        const char *headerDataBytes = NULL;
        NSString *encodeKey = ([AoEValidJudge isValidString:key] ? key : AOE_DEFAULT_KEY);
        NSData *ivData = iv.length > 0 ? iv : [AOE_DEFAULT_IV dataUsingEncoding:NSUTF8StringEncoding];
        NSData *encodeData = [self aoe_encryptAES128Data:soure key:encodeKey iv:ivData];
        int headerLen = getAoECryptHeader(soure.bytes, (int)soure.length, VERSION, &headerDataBytes);
        int len = encryptAoeData(encodeData.bytes, (int)encodeData.length, headerDataBytes, &distDataBytes);
        if (len == encodeData.length + headerLen) {
            distData = [NSData dataWithBytes:distDataBytes length:len];
        }
    }
    return distData;
}

+ (NSString *)aoe_encryptAoEReqParams:(NSDictionary <NSString *,NSString *> *)params
                           encryptKey:(NSString *)key {
    dictFake *fakes = createDictFake((int)params.allKeys.count);
    int index = 0;
    for (NSString *paramskey in params.allKeys) {
        NSString *valueStr = [params objectForKey:paramskey];
        if ([valueStr isKindOfClass:[NSNumber class]]) {
            valueStr = ((NSNumber *)valueStr).stringValue;
        }
        addDictEntryFake(fakes, [paramskey cStringUsingEncoding:NSUTF8StringEncoding], [valueStr cStringUsingEncoding:NSUTF8StringEncoding], index);
        index ++;
    }
    const char *distDataBytes = NULL;
    aoe_generalSignDictFake(fakes,[key cStringUsingEncoding:NSUTF8StringEncoding], key.length, 0, (char **)&distDataBytes);
    NSString *sginedStr = @"";
    if (distDataBytes != NULL) {
        sginedStr = [NSString stringWithUTF8String:distDataBytes];
    }
    releaseDictFake(fakes);
    if (distDataBytes != NULL) {
        free((void *)distDataBytes);
    }
    return sginedStr;
}
@end
