import '@dhis2/cypress-commands'
import 'cypress-wait-until'

Cypress.Commands.add('getByDataTest', (selector, ...args) =>
    cy.get(`[data-test="${selector}"]`, ...args)
)
Cypress.Commands.add(
    'findByDataTest',
    {
        prevSubject: true,
    },
    (subject, selector, ...args) =>
        cy.wrap(subject).find(`[data-test="${selector}"]`, ...args)
)

Cypress.Commands.add(
    'containsExact',
    {
        prevSubject: 'optional',
    },
    (subject, selector) =>
        cy.wrap(subject).contains(
            new RegExp(
                `^${selector.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&')}$`, //eslint-disable-line no-useless-escape
                'gm'
            )
        )
)
