[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/Readme/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Open Source Helpers](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)


# ఓపెన్‌సోర్స్‌కు మీ మొదటి సహకారం

వ్యాసాలు చదవడం & చూడటం ట్యుటోరియల్స్ సహాయపడతాయి, కానీ వాస్తవంగా ఆచరణాత్మక వాతావరణంలో నేర్పిస్తున్నదాని కంటే మెరుగైనది ఏమిటి?

మార్గదర్శిని అందించడం మరియు ఈ ప్రాజెక్ట్ ప్రారంభకులకు వారి మొదటి ఓపెన్ సోర్స్ సహకారం అందించే విధానాన్ని సరళీకరించడం మరియు మార్గనిర్దేశం చేయడం లక్ష్యంగా పెట్టుకుంది. మీరు మీ మొదటి ఓపెన్ సోర్స్స హకారం అందించాలని చూస్తున్నట్లయితే, దిగువ దశలను అనుసరించండి.


#### *మీకు ఆదేశ పంక్తితో సౌకర్యంగా లేకపోతే, [ఇక్కడ GUI సాధనాలను ఉపయోగించి ట్యుటోరియల్స్ ఉన్నాయి.](#ఇతర-సాధనాలను-ఉపయోగించి-ట్యుటోరియల్స్)*





మొదటిసారి ఓపెన్ సోర్స్ కొరకు సహకరించాలి అనుకునే ప్రారంభకులకు పద్దతులను సులభతరం చేయడం ఈ ప్రాజెక్ట్ **ముఖ్య ఉద్దేశం**

 మీరు మొదటిసారి ఒపెన్ సోర్స్ ప్రాజెక్ట్ లకొరకు కాంట్రిబ్యూట్ చేయాలి అనుకుంటే కింది సూచనలు పాటించండి.

మీరు `గిట్(git)`వర్షన్ కట్రోల్ సిస్టమ్ తో సౌకర్యవంతంగా లేకపోతే [ఇక్కడ GUI సాధనాలను ఉపయోగించి ట్యుటోరియల్స్ ఉన్నాయి.](#ఇతర-సాధనాలను-ఉపయోగించి-ట్యుటోరియల్స్)*

<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/fork.png" alt="fork this repository" />

మీ కంప్యూటర్ లో `GIT` లేకపోతే, [గిట్ వర్షన్ కంట్రోల్ సిస్టమ్ ను ఇన్స్టాల్ చేయండి](https://help.github.com/articles/set-up-git/).

## ఈ రిపోజిటరీని  ఫోర్క్ చెయ్యండి

ఈ రిపోజిటరీని  ఫోర్క్ చెయ్యండి ఈ పేజీ ఎగువ భాగంలో ఫోర్క్ బటన్ పై క్లిక్ చేయడం ద్వారా క్లిక్ చేయండి.
ఇది మీ ఖాతాలో ఈ రిపోజిటరీ కాపీని సృష్టిస్తుంది.

## ఈ రిపోజిటరీని  క్లోన్ చెయ్యండి

<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/clone.png" alt="clone this repository" />

ఇప్పుడు మీ కంప్యూటరులో ఫోర్క్ రిపోను క్లోన్ చేయండి. మీ GitHub ఖాతాకు వెళ్లండి, ఫోర్క్డ్ రెపోని తెరిచి, క్లోన్ బటన్పై క్లిక్ చేసి, ఆపై * కాపీ * క్లిప్బోర్డ్కు క్లిక్ చేయండి.

టెర్మినల్ తెరిచి కింది git ఆదేశాన్ని అమలు చేయండి:
```
git clone "మీరు ఇప్పుడే కాపీ చేసిన url"
```
ఇక్కడ "మీరు ఇప్పుడే కాపీ చేసిన url" (కోట్ మార్కులు లేకుండా) ఈ రిపోజిటరీకి URL (ఈ ప్రాజెక్టు మీ ఫోర్క్). Url ను పొందడానికి మునుపటి దశలను చూడండి.
<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/copy-to-clipboard.png" alt="copy URL to clipboard" />

ఉదాహరణకి:
```bash
git clone https://github.com/this-is-you/first-contributions.git
```
ఇక్కడ 'this-is-you' మీ GitHub ప్రొఫైల్ నేమ్. ఇక్కడ మీరు `first-contribution` రిపోజిటరీ  యొక్క కంటెంట్లను మీ GitHub అకౌంట్ లో మీ కంప్యూటర్కు కాపీ చేస్తున్నారు.

## నూతన బ్రాంచ్ ను సృష్టించండి

మీ కంప్యూటర్‌లోని రిపోజిటరీ డైరెక్టరీకి మార్చండి (మీరు ఇప్పటికే అక్కడ లేకపోతే):

```bash
cd first-contributions
```
ఇప్పుడు 'git checkout' కమాండ్ ను  ఉపయోగించి ఒక బ్రాంచ్ ను సృష్టించండి:


ఉదాహరణకి:
```bash
git checkout -b add-alonzo-church
```
(బ్రాంచ్ యొక్క పేరు దానిలో పదం * add * ను కలిగి ఉండవలసిన అవసరం లేదు.

## అవసరమైన మార్పులు - చేర్పులు చేసి, ఆ మార్పులను నిరూపించండి.

టెక్స్ట్ ఎడిటర్లో ఇప్పుడు ఓపెన్ `Contributors.md` ఫైల్లో, **మీ పేరుని జోడించండి. ఫైల్ ప్రారంభంలో లేదా ముగింపులో జోడించవద్దు. మధ్యలో ఎక్కడైనా ఉంచండి. ఇప్పుడు, ఫైల్ను సేవ్ చేయండి.**
<img align="right" width="450" src="https://firstcontributions.github.io/assets/Readme/git-status.png" alt="git status" />


మీరు ప్రాజెక్ట్ డైరెక్టరీకి వెళ్లి `git status` కమాండ్ ని ఆదేశిస్తే, **మార్పులు-చేర్పులు ఉన్నాయి** అని మీరు చూస్తారు.

`Git add ` కమాండ్ ను ఉపయోగించి మీరు సృష్టించిన బ్రాంచ్లో ఈ మార్పులను జోడించండి.

`Git add` కమాండ్ను ఉపయోగించి మీరు సృష్టించిన బ్రాంచ్లో ఈ మార్పులను జోడించండి:
```bash
git add Contributors.md
```

ఇప్పుడు ఆ మార్పులను 'git commit' ఆదేశం ఉపయోగించి కట్టుకోండి:
```bash
git commit -m "Add <your-name> to Contributors list"
```
`<your-name>` ని తొలగించి  మీ పేరును కలపండి.

## GitHubకి మార్పులను పుష్ చేయండి

కమాండ్ ఉపయోగించి మీ మార్పులను పంపండి `git push`:
```bash
git push origin <add-your-branch-name>
```
మీరు ముందుగా సృష్టించిన బ్రాంచీ పేరుతో `<add-your-branch-name>` ను జోడించుము.
<details>
<summary> <strong>GitHubలోకి  నెట్టేటప్పుడు మీకు ఏవైనా లోపాలు వస్తే, ఇక్కడ క్లిక్ చేయండి:</strong> </summary>

- ### ప్రమాణీకరణ లోపం
     <pre>remote: Support for password authentication was removed on August 13, 2021. Please use a personal access token instead.
  remote: Please see https://github.blog/2020-12-15-token-authentication-requirements-for-git-operations/ for more information.
  fatal: Authentication failed for 'https://github.com/<your-username>/first-contributions.git/'</pre>
  మీ ఖాతాకు SSH కీని రూపొందించడం మరియు కాన్ఫిగర్ చేయడంపై [GitHub's tutorial](https://docs.github.com/en/authentication/connecting-to-github-with-ssh/adding-a-new-ssh-key-to-your-github-account) వెళ్లండి.

</details>

## సమీక్ష కోసం మీ మార్పులను సమర్పించండి

మీరు GitHub లో మీ రిపోజిటరీకి వెళ్లినట్లయితే, మీరు 'Compare & pull request' బటన్ను చూస్తారు. ఆ బటన్పై క్లిక్ చేయండి.

<img style="float: right;" src="https://firstcontributions.github.io/assets/Readme/compare-and-pull.png" alt="create a pull request" />

ఇప్పుడు పుల్ అభ్యర్థనను సమర్పించండి.

<img style="float: right;" src="https://firstcontributions.github.io/assets/Readme/submit-pull-request.png" alt="submit pull request" />

  నేను  మీ అన్ని మర్పులను ఈ ప్రాజెక్ట్ యొక్క ప్రధాన విభాగానికి విలీనం`merge to main branch` చేస్తాను. 
మార్పులు విలీనం`merge` అయిన తర్వాత మీరు ఒక నోటిఫికేషన్ ఈమెయిల్ పొందుతారు.

## ఇక్కడ నుండి ఎక్కడికి వెళ్లాలి?

అభినందనలు! మీరు స్టాండర్డ్ _fork -> clone -> edit -> PR_  వర్క్ ఫ్లో ను పూర్తి చేసారు.

[వెబ్ యాప్‌కి](https://firstcontributions.github.io/#social-share) వెళ్లడం ద్వారా మీ సహకారాన్ని జరుపుకోండి మరియు మీ స్నేహితులు మరియు అనుచరులతో భాగస్వామ్యం చేయండి.

మీకు ఏదైనా సహాయం అవసరమైతే లేదా ఏవైనా ప్రశ్నలు ఉంటే మీరు మా స్లాక్ టీమ్‌లో చేరవచ్చు.[స్లాక్ జట్టులో చేరండి](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)

ఇక, ఇప్పుడు మీరు ఇతర ప్రాజెక్టులకు తోడ్పడటం ప్రారంభించండి. మీరు ప్రారంభించగల సులభమైన సమస్యలతో ప్రాజెక్టుల జాబితాను మేము రెడీ చేసాము. [వెబ్ ప్రాజెక్టుల జాబితాలు](https://firstcontributions.github.io/#project-list) ను చూడండి.

### [అదనపు విషయం](../additional-material/git_workflow_scenarios/additional-material.md)


## ఇతర సాధనాలను ఉపయోగించి ట్యుటోరియల్స్

| <a href="../gui-tool-tutorials/github-desktop-tutorial.md"><img alt="GitHub Desktop" src="https://desktop.github.com/images/desktop-icon.svg" width="100"></a> | <a href="../gui-tool-tutorials/github-windows-vs2017-tutorial.md"><img alt="Visual Studio 2017" src="https://upload.wikimedia.org/wikipedia/commons/c/cd/Visual_Studio_2017_Logo.svg" width="100"></a> | <a href="../gui-tool-tutorials/gitkraken-tutorial.md"><img alt="GitKraken" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-icon.png" width="100"></a> | <a href="../gui-tool-tutorials/github-windows-vs-code-tutorial.md"><img alt="VS Code" src="https://upload.wikimedia.org/wikipedia/commons/2/2d/Visual_Studio_Code_1.18_icon.svg" width=100></a> | <a href="../gui-tool-tutorials/sourcetree-macos-tutorial.md"><img alt="Sourcetree App" src="https://wac-cdn.atlassian.com/dam/jcr:81b15cde-be2e-4f4a-8af7-9436f4a1b431/Sourcetree-icon-blue.svg" width=100></a> | <a href="../gui-tool-tutorials/github-windows-intellij-tutorial.md"><img alt="IntelliJ IDEA" src="https://upload.wikimedia.org/wikipedia/commons/thumb/9/9c/IntelliJ_IDEA_Icon.svg/512px-IntelliJ_IDEA_Icon.svg.png" width=100></a> |
| --- | --- | --- | --- | --- | --- |
| [GitHub Desktop](../gui-tool-tutorials/github-desktop-tutorial.md) | [Visual Studio 2017](../gui-tool-tutorials/github-windows-vs2017-tutorial.md) | [GitKraken](../gui-tool-tutorials/gitkraken-tutorial.md) | [Visual Studio Code](../gui-tool-tutorials/github-windows-vs-code-tutorial.md) | [Atlassian Sourcetree](../gui-tool-tutorials/sourcetree-macos-tutorial.md) | [IntelliJ IDEA](../gui-tool-tutorials/github-windows-intellij-tutorial.md) |
