[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/Readme/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Open Source Helpers](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)


# ആദ്യ സംഭാവനകൾ (First Contributions)

ആദ്യമായി ഒരു കാര്യം ചെയ്യുക എന്നുള്ളത് വളരെ ബുദ്ധിമുട്ടാണ്. പ്രത്യേകിച്ച്, മറ്റു പലരുടെയും ഒപ്പം ജോലി ചെയ്യുമ്പോൾ തെറ്റ് വരുന്നത് അത്ര സുഖകരമായ കാര്യം അല്ല. സ്വതന്ത്ര സോഫ്റ്റ്‌വെയറിലേക്ക് ആദ്യമായി സംഭാവന ചെയ്യുന്നവർക്ക് അതിനെ പറ്റി പഠിക്കാനും പങ്കാളി ആകുവാനും വേണ്ടി കുറച്ച്‌ കൂടെ എളുപ്പമായ എന്തെങ്കിലും ഉണ്ടാക്കണമെന്നായിരുന്നു ഞങ്ങളുടെ ആഗ്രഹം.

ലേഖനങ്ങൾ വായിക്കുന്നതും വീഡിയോ കാണുന്നതും ഒക്കെ സഹായകരമാണ്. പക്ഷേ ചെയ്ത് തന്നെ പഠിക്കുന്നതല്ലേ ഏറ്റവും നല്ലത്? ഈ പ്രൊജക്റ്റ് ഇതിനെ പറ്റി പരിചയം ഇല്ലാത്ത ഒരാൾക്ക് ആദ്യത്തെ സംഭാവന നല്കാൻ ഉള്ള ഒരു വഴികാട്ടി ആണ്. നിങ്ങളും നിങ്ങളുടെ ആദ്യ സംഭാവന നൽകാൻ ആഗ്രഹിക്കുന്നു എങ്കിൽ താഴെ പറയുന്നത് പോലെ ചെയ്യുക.

#### *താങ്കൾക്ക് കമാൻഡ് ലൈൻ ഉപയോഗിച്ച്‌ പരിചയം ഇല്ലെങ്കിൽ, [GUI ഉപയോഗിച്ച് ചെയ്യാൻ ഉള്ള നിർദേശങ്ങൾ ഇവിടെ ലഭ്യമാണ്](#മറ്റു-ഉപകരണങ്ങൾ-ഉപയോഗിച്ച്-ചെയ്യുന്നതിനെ-പറ്റിയുള്ള-ലേഖനങ്ങൾ)*.

<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/fork.png" alt="fork this repository" />

താങ്കളുടെ കമ്പ്യൂട്ടറിൽ ഗിറ്റ് (git) ഇല്ലെങ്കിൽ, [ഇൻസ്റ്റാൾ ചെയ്യുക](https://help.github.com/articles/set-up-git/).

## ഈ റെപ്പോസിറ്ററി ഫോർക്ക് (fork) ചെയ്യുക

ഈ പേജിന്റെ ഏറ്റവും മുകളിൽ ഉള്ള ഫോർക്ക് ബട്ടൺ ഉപയോഗിച്ച് ഈ റെപ്പോസിറ്ററി ഫോർക്ക് ചെയ്യുക. ഇങ്ങനെ ചെയ്യുമ്പോൾ നിങ്ങളുടെ അക്കൗണ്ടിൽ ഈ റെപ്പോസിറ്ററിയുടെ ഒരു പകർപ്പ് സൃഷ്ടിക്കപ്പെടുന്നു.

## ഈ റെപ്പോസിറ്ററി ക്ലോൺ (clone) ചെയ്യുക

<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/clone.png" alt="clone this repository" />

ഇനി ഫോർക്ക് ചെയ്ത റെപ്പോസിറ്ററി നിങ്ങളുടെ കമ്പ്യൂട്ടറിലേക്ക് ക്ലോൺ ചെയ്യുക. നിങ്ങളുടെ ഗിറ്റ്ഹബ് (GitHub) അക്കൗണ്ട് എടുത്ത് അതിൽ ഫോർക്ക് ചെയ്ത റെപ്പോസിറ്ററി തുറക്കുക. എന്നിട്ട് മുകളിൽ ക്ലോൺ ബട്ടണിലെ *കോപ്പി ടു ക്ലിപ്പ് ബോർഡ് (Copy to clipboard)* എന്ന ഐക്കൺ ക്ലിക്ക് ചെയ്യുക.

എന്നിട്ട് ഒരു ടെർമിനൽ എടുത്ത് താഴെ പറയുന്ന ഗിറ്റ് കമാൻഡ് റൺ ചെയ്യുക:

```
git clone <നിങ്ങളുടെ-ലിങ്ക്>
```

ഇതിൽ `<നിങ്ങളുടെ-ലിങ്ക്>` എന്ന് പറയുന്നത് താങ്കളുടെ (ഫോർക്ക് ചെയ്ത) റെപ്പോസിറ്ററി ലിങ്ക് ആണ്. ലിങ്ക് എങ്ങനെ കോപ്പി ചെയ്യാം എന്നറിയാൻ ഇതിനു മുൻപ് ഉള്ള നിർദേശം നോക്കുക.

<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/copy-to-clipboard.png" alt="copy URL to clipboard" />

ഉദാഹരണം:

```
git clone https://github.com/<താങ്കൾ>/first-contributions.git
```

ഇതിൽ `<താങ്കൾ>` എന്നതിന് പകരം നിങ്ങളുടെ ഗിറ്റ്ഹബ് യൂസർനെയിം കൊടുക്കുക. ഇപ്പോൾ നിങ്ങൾ ചെയ്യുന്നത് നിങ്ങളുടെ ഗിറ്റ്ഹബിലെ ഫസ്റ്റ്-കോണ്ട്രിബൂഷൻസ് (first-contributions) റെപ്പോസിറ്ററിയിൽ ഉള്ളവ നിങ്ങളുടെ കമ്പ്യൂട്ടറിലേക്ക് കോപ്പി ചെയ്യുകയാണ്.

## ഒരു ശാഖ (ബ്രാഞ്ച്, Branch) ഉണ്ടാക്കുക 

നിങ്ങളുടെ റെപ്പോസിറ്ററിയിലേക്ക് കടക്കുക:

```
cd first-contributions
```

എന്നിട്ട് `git checkout` എന്ന കമാൻഡ് ഉപയോഗിച്ച് ഒരു ബ്രാഞ്ച് ഉണ്ടാക്കുക:

```
git checkout -b <നിങ്ങളുടെ-പുതിയ-ബ്രാഞ്ചിന്റെ-പേര്>
```

ഉദാഹരണം:

```
git checkout -b add-alonzo-church
```

(ബ്രാഞ്ചിന്റെ പേരിൽ add എന്ന് ഉണ്ടാകണം എന്ന് നിർബന്ധം ഇല്ല. പക്ഷെ നിങ്ങളുടെ ഉദ്ദേശം നിങ്ങളുടെ പേര് ഇതിൽ ഉൾപ്പെടുത്തണം എന്നത് ആണെന്നതിനാൽ അത് കൊടുക്കുന്നതാണ് നല്ലത്.)

## ആവശ്യത്തിനുള്ള വ്യത്യാസങ്ങൾ വരുത്തി അവ കമ്മിറ്റ് (commit) ചെയ്യുക 

ഇനി `Contributors.md` എന്ന ഫയൽ ഒരു എഡിറ്റർ ഉപയോഗിച്ച് തുറന്നതിനു ശേഷം താങ്കളുടെ പേര് അതിൽ ഉൾപ്പെടുത്തുക. അങ്ങനെ ചെയ്യുമ്പോൾ തുടക്കത്തിലോ അവസാനത്തിലോ അല്ലാതെ ഇടയിൽ എവിടെയെങ്കിലും ഉൾപെടുത്തുക. എന്നിട്ട് ആ ഫയൽ സേവ് ചെയ്യുക.

<img align="right" width="450" src="https://firstcontributions.github.io/assets/Readme/git-status.png" alt="git status" />

താങ്കളുടെ പ്രൊജക്റ്റ് ഡയറക്ടറിയിൽ ചെന്ന് `git status` എന്ന കമാൻഡ് അടിച്ചു നോക്കിയാൽ താങ്കൾ വരുത്തിയ വ്യത്യാസങ്ങൾ കാണാൻ സാധിക്കും.

ഈ വ്യത്യാസങ്ങൾ `git add` കമാൻഡ് ഉപയോഗിച്ച്‌ നിങ്ങളുടെ ബ്രാഞ്ചിലേക്ക് ചേർക്കുക:

```
git add Contributors.md
```

ഇനി നിങ്ങൾ ഉണ്ടാക്കിയ വ്യത്യാസങ്ങൾ `git commit` കമാൻഡ് ഉപയോഗിച്ച് കമ്മിറ്റ് ചെയ്യുക:

```
git commit -m "Add <താങ്കളുടെ-പേര്> to Contributors list"
```

ഇതിൽ `<താങ്കളുടെ-പേര്>` എന്ന സ്ഥാനത്ത് താങ്കളുടെ ശരിയായ പേര് കൊടുക്കുക.

## വ്യത്യാസങ്ങൾ ഗിറ്റ്ഹബിലേക്ക് ചേർക്കുക (push)

`git push` കമാൻഡ് ഉപയോഗിച്ച് വ്യത്യാസങ്ങൾ ഗിറ്റ്ഹബിലേക്ക് പുഷ് ചെയ്യുക:


```
git push origin <താങ്കളുടെ-ബ്രാഞ്ചിന്റെ-പേര്>
```

ഇതിൽ <താങ്കളുടെ-ബ്രാഞ്ചിന്റെ-പേര്> എന്നതിന് പകരം താങ്കൾ നേരത്തെ ഉണ്ടാക്കിയ ബ്രാഞ്ചിന്റെ പേര് കൊടുക്കുക.

## നിങ്ങളുടെ വ്യത്യാസങ്ങൾ പരിശോധനക്കായി (review) സമർപ്പിക്കുക 

നിങ്ങൾ ഇപ്പോൾ നിങ്ങളുടെ ഗിറ്റ്ഹബ് റെപ്പോസിറ്ററിയിൽ പോയി നോക്കിയാൽ അവിടെ `Compare & pull request` എന്ന ഒരു ബട്ടൺ കാണാം. അതിൽ അമർത്തുക.

<img style="float: right;" src="https://firstcontributions.github.io/assets/Readme/compare-and-pull.png" alt="create a pull request" />

ഇനി പുൾ റിക്വസ്റ്റ് (pull request) കൊടുക്കുക.

<img style="float: right;" src="https://firstcontributions.github.io/assets/Readme/submit-pull-request.png" alt="submit pull request" />

വൈകാതെ തന്നെ ഞാൻ താങ്കളുടെ വ്യത്യാസങ്ങൾ പ്രധാന ബ്രാഞ്ചിലേക്ക്  ചേർക്കുന്നതായിരിക്കും. അപ്പോൾ താങ്കൾക്ക് ഒരു ഇമെയിൽ അറിയിപ്പ് ലഭിക്കും.

## ഇവിടെ നിന്ന് ഇനി എങ്ങോട്ട്?

അഭിനന്ദനങ്ങൾ! താങ്കൾ താങ്കളുടെ ആദ്യത്തെ _fork -> clone -> edit -> PR_ പടികൾ വിജയകരമായി പൂർത്തിയാക്കിയിരുന്നു. ഒരു സംഭാവകൻ എന്ന നിലക്ക് ഇത് താങ്കൾക്ക് ഇടയ്ക്കിടെ ചെയ്യേണ്ടി വരുന്ന ഒരു കാര്യം ആണ്!

താങ്കളുടെ സംഭാവന സുഹൃത്തുക്കളും പിൻഗാമികളുമായി (followers) പങ്കിട്ട് ആഘോഷിക്കുവാനായി ഈ [വെബ് ആപ്പ് എടുക്കുക](https://firstcontributions.github.io/#social-share).

താങ്കൾക്ക് എന്തെങ്കിലും സഹായം വേണമെങ്കിൽ, അല്ലെങ്കിൽ എന്തെങ്കിലും ചോദ്യങ്ങൾ ഉണ്ടെങ്കിൽ ഞങ്ങളുടെ [slack team-ൽ ചേരുവാനായി റിക്വസ്റ്റ് അയക്കുക](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA).

ഇനി താങ്കൾക്ക് മറ്റുള്ള പ്രൊജെക്ടുകളിൽ സംഭാവന ചെയ്യുവാൻ സാധിക്കും. താങ്കൾക്ക് വേഗം തുടങ്ങുവാൻ വേണ്ടി ഞങ്ങൾ എളുപ്പത്തിൽ തീർക്കാവുന്ന പ്രശ്നങ്ങൾ (issues) ഉള്ള പ്രോജക്ടുകളുടെ ഒരു ലിസ്റ്റ് ഉണ്ടാക്കിയിട്ടുണ്ട്. അത് ഇവിടെ കാണുക: [പ്രോജക്ടുകളുടെ ലിസ്റ്റ്](https://firstcontributions.github.io/#project-list).

### [കൂടുതൽ വായിക്കുക](../additional-material/git_workflow_scenarios/additional-material.md)


## മറ്റു ഉപകരണങ്ങൾ ഉപയോഗിച്ച് ചെയ്യുന്നതിനെ പറ്റിയുള്ള ലേഖനങ്ങൾ

| <a href="../gui-tool-tutorials/github-desktop-tutorial.md"><img alt="GitHub Desktop" src="https://desktop.github.com/images/desktop-icon.svg" width="100"></a> | <a href="../gui-tool-tutorials/github-windows-vs2017-tutorial.md"><img alt="Visual Studio 2017" src="https://upload.wikimedia.org/wikipedia/commons/c/cd/Visual_Studio_2017_Logo.svg" width="100"></a> | <a href="../gui-tool-tutorials/gitkraken-tutorial.md"><img alt="GitKraken" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-icon.png" width="100"></a> | <a href="../gui-tool-tutorials/github-windows-vs-code-tutorial.md"><img alt="VS Code" src="https://upload.wikimedia.org/wikipedia/commons/2/2d/Visual_Studio_Code_1.18_icon.svg" width=100></a> | <a href="../gui-tool-tutorials/sourcetree-macos-tutorial.md"><img alt="Sourcetree App" src="https://wac-cdn.atlassian.com/dam/jcr:81b15cde-be2e-4f4a-8af7-9436f4a1b431/Sourcetree-icon-blue.svg" width=100></a> | <a href="../gui-tool-tutorials/github-windows-intellij-tutorial.md"><img alt="IntelliJ IDEA" src="https://upload.wikimedia.org/wikipedia/commons/thumb/9/9c/IntelliJ_IDEA_Icon.svg/512px-IntelliJ_IDEA_Icon.svg.png" width=100></a> |
| --- | --- | --- | --- | --- | --- |
| [GitHub Desktop](../gui-tool-tutorials/github-desktop-tutorial.md) | [Visual Studio 2017](../gui-tool-tutorials/github-windows-vs2017-tutorial.md) | [GitKraken](../gui-tool-tutorials/gitkraken-tutorial.md) | [Visual Studio Code](../gui-tool-tutorials/github-windows-vs-code-tutorial.md) | [Atlassian Sourcetree](../gui-tool-tutorials/sourcetree-macos-tutorial.md) | [IntelliJ IDEA](../gui-tool-tutorials/github-windows-intellij-tutorial.md) |
