[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Open Source Helpers](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)


# Primeiras Contribuições

|<img alt="Visual Studio 2017" src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/61/Visual_Studio_2017_logo_and_wordmark.svg/2000px-Visual_Studio_2017_logo_and_wordmark.svg.png" width="200">|Visual Studio 2017 Edition|
|---|---|

É difícil. Sempre é difícil fazer algo pela primeira vez. Especialmente quando você está colaborando, cometer erros não é confortável. Mas o open sourece tem tudo a ver com colaboração e trabalho em equipe. Nós queremos simplificar a maneira de aprendizagem aos novos contribuidores de open source e ajudar em sua primeira contribuição.

Lendo artigos e olhando tutoriais podem ajudar, mas o que é melhor do que realmente fazer as coisas sem estragar nada.
Esse projeto visa em providenciar uma orientação e simplificar a maneira dos novatos a conseguirem a sua primeira contribuição. 
Lembre-se, quanto mais relaxado melhor será o aprendizado. Se você está procurando em fazer a sua primeira contribuição, siga esses passos abaixo. Nós prometemos a você que vai ser divertido.



## Git Kraken

Baixe [GitKraken](https://www.gitkraken.com), Instale e abra.

Provavelmente aparecerá um "Bem-vindo ao GitKraken" com um espaço para entrar na sua conta do GitHub e permitir que o GitKraken possa ter o acesso dela. 


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-login.png" alt="login to GitHub" />

(opcional) Vá para Aqruivos -> Preferências e ajuste o diretório do seu projeto para a raiz de seus repositórios locais.


## Faça um Fork deste repositório

Para fazer um Fork deste repositório, basta clicar no botão de fork no topo da página.
<img align="right" width="300" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/fork.png" alt="fork this repository" />
Isso criará uma cópia do repositório na sua conta GitHub.


## Clone o seu repositório

No GitKraken, vá até Arquivo -> Clone Repositório.


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-clone.png" alt="clone this repository" />


Selecione GitHub.com no painel direito. De baixo do nome de usuário, deverá aparecer "first-contributions".  Clique nesse repositório e confirme na parte inferior do painel, se aparece o local do diretório onde você quer clonar.

Quando estiver tudo certo com o diretório, clique em "Clone o repositório!"


## Crie uma Branch

Clique o botão branch na barra de ferramentas. 

Nomeie a sua branch "add-seu-nome", for example: "add-william-sutton"

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-branch.png" alt="name your branch" />


## Faça mudanças necessárias e faça um commit nelas 

Agora abra o arquivo `Contributors.md` em um editor de texto e adicione o seu nome, em seguida salve-o.

Se você estiver com o repositório aberto no GitKraken, haverá mudanças.
Revise e faça um Stage nessas mudanças selecionando o commit mais recente marcado com "// WIP" e com número de arquivos modificados e o tipo de mudança.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-edit.png" alt="edit some file(s)" />

Revise esses arquivos que foram modificados e decida o que colocar no Stage. O Stage é importante, pois informa o Git extamente quais arquivos modificados você quer mandar no commit.


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-stage.png" alt="stage your changes" />


Quando escrever uma boa mensagem no commit ("Add <seu-nome> para a lista de Contribuidores" parece bom e descritivo) e satisfeito com as suas mudanças, você pode apertar no "Stage todas as mudanças" para fazer o Stage em todas as alterações ou "Stage Arquivo" para cada arquivo modificado individualmente.


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-commit.png" alt="clone this repository" />


Se você mudar de ideia, você pode fazer um Unstage (processo reverso do Stage) das sua modificações ou discartar todas elas juntas.
CUIDADO: A palavra discartar fala por si só, ou seja, é uma operação destrutiva. Só faça isso, se você não quer nenhuma mundança no repositório que estiver trabalhando.

Aperte commit.

Parabéns, você acabou de fazer um commit de todas as suas mudanças na sua branch local do seu Fork. Em diante!


## Faça um Push nas suas modificações para o GitHub

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-push.png" alt="push your changes" />

Na barra de ferramentas, clique no botão Push.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-origin.png" alt="origin or branch" />

Se você quer enviar as mudanças direto para branch master, você pode enviar para a branch de origem. Caso contrário, selecione uma branch apropriada para mandar.  


## Envie as suas mudanças para revisão

No seu repositório do GitHub você vai ver um botão escrito: `Compare & pull request`, que fica ao lado da notificação da nova branch. Clique nesse botão.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/compare-and-pull.png" alt="create a pull request" />

Agora envie esse Pull Request.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/submit-pull-request.png" alt="submit pull request" />

Logo irei mesclar todas as suas mudanças na branch master do projeto. Você receberá uma notificação pelo e-mail quando as alterações forem mescladas.

## Onde eu posso ir a partir daqui?

Parabéns! Você completou o fluxo de trabalho básico _fork -> clone -> edit -> PR_, onde você encontrará muito como contribuidor.

Celebre a sua contribuição e compartilhe com seus amigos e seguidores no [web app](https://firstcontributions.github.io/#social-share).

Caso precise de ajuda ou tenha alguma pergunta, você pode se juntar à nossa equipe Slack. [Join slack team](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA).


### [Material Adicional](../additional-material/git_workflow_scenarios/additional-material.md)


## Tutoriais usando outras ferramentas
[Voltar para página principal](https://github.com/firstcontributions/first-contributions#tutorials-using-other-tools)
