[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Open Source Helpers](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)


# Première Contribution

|<img alt="GitKraken" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-icon.png" width="200">|GitKraken Edition|
|---|---|

C'est difficile. C'est toujours difficile, quand on fait quelque chose pour la première fois. Surtout lorsque vous collaborez, faire des erreurs n'est pas une chose confortable. Mais l'open source concerne avant tout la collaboration et le travail en équipe. 
Nous voulions simplifier la manière dont les nouveaux contributeurs open source apprennent et contribuent pour la première fois.

Lire des articles et regarder des tutoriels peut aider, mais quoi de mieux que de vraiment faire les choses sans tout gâcher. Ce projet vise à fournir des conseils et à simplifier la manière dont les novices font leur première contribution. 
Rappelez-vous, plus vous êtes détendu, mieux vous apprenez. Si vous cherchez à faire votre première contribution, suivez simplement les étapes simples ci-dessous. Nous vous promettons que ce sera amusant

## Git Kraken

Télécharger [GitKraken](https://www.gitkraken.com), Installer et l'ouvrir.


Vous devriez lire "Welcome to GitKraken" - Enregistrer vous via Github en cliquant sur "Sign in with GitHub" et autoriser GitKraken à accéder à votre compte GitHub account.


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-login.png" alt="login to GitHub" />

(optionnel) Allez dans Fichier (File) -> Préférences (Preferences) et définissez votre répertoire de projet à la racine de vos dépôts locaux.


## Forker ce dépôt

Forker ce dépôt en cliquant sur le bouton Fork en haut de cette page.
<img align="right" width="300" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/fork.png" alt="dupliquez ce dépôt" />
Cela créera une copie de ce dépôt dans votre compte.

## Cloner le dépôt

Dans GitKraken, aller à File -> Clone Repo.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-clone.png" alt="clone this repository" />

Selectionner GitHub.com dans le panneau de droite. Sous votre username, vous devriez voir first-contributions apparaître. Cliquer sur ce dépôt et vérifier le chemin complet vers le dossier en bas du panneau d'affichage.

Une fois que vous êtes satisfait du chemin, cliquez sur "Clone the repo!".


## Créer une branche

Cliquez sur le bouton "branche" dans la barre d'outils.

Nommez votre branche "add-your-name", par exemple : "add-william-sutton".

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-branch.png" alt="name your branch" />


## Effectuez et validez des modifications.

Ouvrez maintenant le fichier Contributors.md dans un éditeur de texte et ajoutez-y votre nom, puis enregistrez le fichier.

Si vous avez le dépôt ouvert dans GitKraken, vous verrez qu'il y a des modifications. Examinez et mettez en scène ces modifications en sélectionnant le dernier commit marqué par "// WIP" et le nombre de fichiers modifiés ainsi que le type de modification.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-edit.png" alt="edit some file(s)" />

Examinez les fichiers qui ont été modifiés et décidez de ceux que vous souhaitez "stage". "Staging" est important pour indiquer à git exactement quelles modifications de fichier vous souhaitez associer à ce commit.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-stage.png" alt="stage your changes" />

Once you have a good commit message ("Add <your-name> to Contributors list" sounds nice and descriptive) and are happy with your changes, you can hit "Stage all changes" to stage everything that is modified or "Stage File" to stage an individual file.

Lorsque vous avez un bon message de commit ("Add <your-name> to Contributors list" semble joli et descriptif) et que vous êtes satisfait de vos modifications, 
vous pouvez cliquer sur "Stage all changes" pour "stage" tout ce qui est modifié ou "Stage File" pour ajouter un fichier individuel.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-commit.png" alt="clone this repository" />

Si vous changez d'avis, vous pouvez "unstage" ces modifications, ou vous pouvez les supprimer complètement.
ATTENTION : Comme le mot supprimer l'indique, c'est une opération destructrice. Faites-le seulement si vous ne voulez aucune modification(s) du dépôt dans lequel vous vous trouvez.

Appuyez sur "commit".

Félicitations, vous avez validé toutes les modifications dans votre copie locale de votre branche de votre fork de first-contributions. En avant !


## Push changes to GitHub

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-push.png" alt="push your changes" />

Cliquez sur le bouton Push dans la barre d'outils.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-origin.png" alt="origin or branch" />

Soumettez les modifications sur la branche origin si vous souhaitez que les modifications se reflètent directement dans la branche master, sinon sélectionnez la branche appropriée que vous souhaitez pousser (push).


## Soumettez vos modifications pour revision (review)

Si vous allez sur votre dépôt sur GitHub, vous verrez le bouton Compare & pull request. Cliquez sur ce bouton.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/compare-and-pull.png" alt="create a pull request" />

Maintenant, soumettez la pull request.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/submit-pull-request.png" alt="submit pull request" />

Bientôt, je fusionnerai toutes vos modifications dans la branche master de ce projet. Vous recevrez un e-mail de notification une fois les modifications fusionnées (merge).

## Que faire ensuite ?

Félicitations ! Vous venez de terminer le workflow standard fork -> clone -> edit -> PR que vous rencontrerez souvent en tant que contributeur !

Célébrez votre contribution et partagez-la avec vos amis et abonnés en vous rendant sur l'application [web](https://firstcontributions.github.io/#social-share).

Vous pouvez rejoindre notre équipe Slack si vous avez besoin d'aide ou si vous avez des questions. [Rejoignez l'équipe Slack](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA).


### [Autre-Materiel](../additional-material/git_workflow_scenarios/additional-material.md)


## Tutoriels avec d'autres outils
[Back to main page](https://github.com/firstcontributions/first-contributions#tutorials-using-other-tools)
