[![Amor por el Código Abierto](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![Licencia: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Ayudantes de Código Abierto](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)


# Primeras Contribuciones

|<img alt="GitKraken" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-icon.png" width="200">|GitKraken Edition|
|---|---|

Es difícil. Siempre es difícil cuando se hace algo por primera vez. Especialmente cuando se colabora, cometer errores no es algo agradable. Pero el código abierto trata sobre la colaboración y el trabajo en conjunto. Queríamos simplificar la manera en que los contribuyentes de código abierto aprenden y contribuyen por primera vez.

Leer artículos y ver tutoriales puede ayudar, pero ¿qué es mejor que hacer las cosas sin estropear nada?. Este proyecto tiene como objetivo proporcionar orientación y simplificar la manera en que los novatos hacen su primera contribución. Recuerda que cuando más relajado estés, mejor aprenderás. Si buscas hacer tu primera contribución sólo sigue los simples pasos a continuación. Te lo prometemos, será divertido.

## Git Kraken

Descarga [GitKraken](https://www.gitkraken.com), Instálalo y ábrelo.

Deberías ver el diálogo modal "Welcome to GitKraken" - Regístrate con Github y permite el acceso a Gitkraken a tu cuenta de GitHub.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-login.png" alt="login to GitHub" />

(opcional) Dirígete a File -> Preferences y configura el directorio de tu proyecto en la raíz de tus repositorios locales. 


## Bifurca (Fork) este repositorio

Bifurca este repositorio clickeando en el botón fork en la parte superior derecha de esta página.

<img align="right" width="300" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/fork.png" alt="fork this repository" />
Esto creará una copia de este repositorio en su cuenta.


## Clona el repositorio

En GitKraken, ve a File -> Clone Repo.


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-clone.png" alt="clone this repository" />


Selecciona GitHub.com  en el panel derecho. Bajo tu nombre de usuario, deberías ver first-contributions. Haz click en ese repositorio y verifica la ruta completa mostrada al final del panel.

Una vez estés satisfecho con la ruta, clickea "Clone the repo!".

## Crear una rama (*branch*)

Clickea el botón *branch* de la barra de herramientas.

Nombra tu rama "add-your-name", por ejemplo: "add-william-sutton"

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-branch.png" alt="name your branch" />


## Haz los cambios necesarios y confirma (*Commit*) esos cambios

Ahora abre el archivo `Contributors.md` en un editor de texto y agrégale tu nombre, luego guarda el archivo.

Si tienes el repositorio abierto en GitKraken deberías ver que hay cambios. Revisa y prepara esos cambios seleccionando la confirmación (*commit*) más reciente marcada con "// WIP" y el número de archivos cambiados y el tipo de cambio.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-edit.png" alt="edit some file(s)" />

Revisa los archivos que han sido cambiados y decide cuáles deseas preparar para confirmar (*stage*). La preparación es importante para decirle a git exactamente que archivos deseas asociar con esta confirmación (*commit*).


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-stage.png" alt="stage your changes" />

Una vez tengas un buen mensaje de confirmación (*commit*) ("Add <your-name> to Contributors list" suena agradable y descriptivo) y estés feliz con tus cambios, puedes clickear "Stage all changes" para preparar todo lo modificado o "Stage File" para preparar un archivo individual.


<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-commit.png" alt="clone this repository" />

Si cambias de idea, puedes olvidar (*unstage*) esos cambios, o puedes descartárlos todos.
ADVERTENCIA: Como lo implica la palabra descartar, esta es una operación destructiva. Hazlo solo si no quieres ningún cambio(s) desde cualquier repositorio en el que te encuentres.

Clickea en *commit*.

Felicidades, has confirmado (*committed*) todos los cambios a la copia local de la rama de tu bifurcación (*fork*) de first-contributions.¡Adelante!.

## Sube (*push*) los cambios a GitHub

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-push.png" alt="push your changes" />

Haz click en el botón *Push* en la barra de herramientas.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/gk-origin.png" alt="origin or branch" />

Envía los cambios en la rama origen si quieres que los cambios se reflejen en la rama maestra directamente, sino selecciona la rama apropiada a la cual quieres hacer el push.

## Envía tus cambios para revisión

Si vas a tu repositorio en github, verás el botón `Compare & pull request`. Haz click en él.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/compare-and-pull.png" alt="create a pull request" />

Ahora confirma el pull request.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/gitkraken-tutorial/submit-pull-request.png" alt="submit pull request" />

Pronto estaré fusionando todos sus cambios en la rama master de este proyecto. Recibirás una notificación por correo electrónico cuando los cambios hayan sido fusionados.

## ¿Cuáles son los siguientes pasos?

¡Enhorabuena! ¡Has completado el flujo de trabajo _fork -> clone -> edit -> PR_ que encontrarás habitualmente como contribuidor!

Celebra tu contribución y compártela con tus amigos y seguidores yendo a [App web](https://firstcontributions.github.io/#social-share).

También podrías unirte a nuestro equipo de Slack en caso de que necesites ayuda o tengas alguna pregunta. [Únete a nuestro equipo de Slack](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA).


### [Material adicional](../additional-material/git_workflow_scenarios/additional-material.md)


## Tutoriales con otras herramientas
[Regresar a la página principal](https://github.com/firstcontributions/first-contributions#tutorials-using-other-tools)
