[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/Readme/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Open Source Helpers](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)

# ആദ്യ സംഭാവനകൾ (First Contributions)

| <img alt="Visual Studio Code" src="https://upload.wikimedia.org/wikipedia/commons/2/2d/Visual_Studio_Code_1.18_icon.svg" width="40"> | Visual Studio Code |
| ------------------------------------------------------------------------------------------------------------------------------------ | ------------------ |

ആദ്യമായി ഒരു കാര്യം ചെയ്യുക എന്നുള്ളത് വളരെ ബുദ്ധിമുട്ടാണ്. പ്രത്യേകിച്ച്, മറ്റു പലരുടെയും ഒപ്പം ജോലി ചെയ്യുമ്പോൾ തെറ്റ് വരുന്നത് അത്ര സുഖകരമായ കാര്യം അല്ല. സ്വതന്ത്ര സോഫ്റ്റ്‌വെയറിലേക്ക് ആദ്യമായി സംഭാവന ചെയ്യുന്നവർക്ക് അതിനെ പറ്റി പഠിക്കാനും പങ്കാളിയാകുവാനും വേണ്ടി കുറച്ച്‌കൂടെ എളുപ്പമായ എന്തെങ്കിലും ഉണ്ടാക്കണമെന്നായിരുന്നു ഞങ്ങളുടെ ആഗ്രഹം.

ലേഖനങ്ങൾ വായിക്കുന്നതും വീഡിയോകൾ കാണുന്നതും ഒക്കെ സഹായകരമാണ്. പക്ഷേ ചെയ്ത് തന്നെ പഠിക്കുന്നതല്ലേ ഏറ്റവും നല്ലത്? ഈ പ്രൊജക്റ്റ് ഇതിനെ പറ്റി പരിചയം ഇല്ലാത്ത ഒരാൾക്ക് ആദ്യത്തെ സംഭാവന നല്കാൻ ഉള്ള ഒരു വഴികാട്ടി ആണ്. നിങ്ങൾ എത്രത്തോളം സ്വസ്‌ഥമായിരിക്കുന്നുവോ അത്രയും നന്നായി പഠിക്കുമെന്ന് ഓർക്കുക. നിങ്ങളും നിങ്ങളുടെ ആദ്യ സംഭാവന നൽകാൻ ആഗ്രഹിക്കുന്നുവെങ്കിൽ, താഴെ പറയുന്നത് പോലെ ചെയ്യുക. ഞങ്ങൾ നിങ്ങൾക്ക് വാഗ്ദാനം ചെയ്യുന്നു, ഇത് രസകരമായിരിക്കും.

നിങ്ങളുടെ മെകമ്പ്യൂട്ടറിൽ വിഷ്വൽ സ്റ്റുഡിയോ കോഡ് ഇല്ലെങ്കിൽ, [ഇത് ഇൻസ്റ്റാൾ ചെയ്യുക](https://code.visualstudio.com/download).

**അറിയിപ്പ്:** ഈ പരിശീലനപദ്ധതി ഒരു Windows 10 മെഷീനിൽ വിഷ്വൽ സ്റ്റുഡിയോ കോഡ് (പതിപ്പ് 1.27.2) ഉപയോഗിച്ചാണ് നിർമ്മിച്ചിരിക്കുന്നത്. ഈ ട്യൂട്ടോറിയലിൽ ഞങ്ങൾ ചില കീബോർഡ് കുറുക്കുവഴികൾ ഉപയോഗിക്കുന്നതായിരിക്കും. മറ്റ് ഓപ്പറേറ്റിംഗ് സിസ്റ്റങ്ങളിലും (macOS/Linux) കീബോർഡ് ഭാഷയിലും (UK, DE, മുതലായവ) ഇവ വ്യത്യാസമായിരിക്കാം. കമാൻഡ് പാലറ്റിൽ "shortcut" തിരഞ്ഞുകൊണ്ട് നിങ്ങൾക്ക് കുറുക്കുവഴികളുടെ പട്ടികയിലൂടെ കടന്നുപോകാം.

## ഈ റെപ്പോസിറ്ററി ഫോർക്ക് (fork) ചെയ്യുക

<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/fork.png" alt="fork this repository" />

ഈ പേജിന്റെ ഏറ്റവും മുകളിൽ ഉള്ള ഫോർക്ക് ബട്ടൺ ഉപയോഗിച്ച് ഈ റെപ്പോസിറ്ററി ഫോർക്ക് ചെയ്യുക. ഇങ്ങനെ ചെയ്യുമ്പോൾ നിങ്ങളുടെ അക്കൗണ്ടിൽ ഈ റെപ്പോസിറ്ററിയുടെ ഒരു പകർപ്പ് സൃഷ്ടിക്കപ്പെടുന്നു.

GitHub നിങ്ങളുടെ റിപ്പോയും നിങ്ങൾ ഫോർക്ക് ചെയ്ത റിപ്പോയും തമ്മിലുള്ള ബന്ധത്തിന്റെ ട്രാക്ക് സൂക്ഷിക്കുന്നു. നിങ്ങളുടെ റിപ്പോ ഒരു പ്രവർത്തന പകർപ്പായി നിങ്ങൾക്ക് ചിന്തിക്കാം.

മിക്ക ഉയർന്ന തലത്തിലുള്ള GitHub റിപ്പോകൾക്കും (അതായത് മറ്റേതെങ്കിലും റിപ്പോയിൽ നിന്നും ഫോർക്ക് ചെയ്യാത്തവ) നേരിട്ട് മാറ്റങ്ങൾ വരുത്താൻ കഴിയുന്ന ഒരു ചെറിയ കോർ സംഘം ഉണ്ട്. മറ്റെല്ലാ സംഭാവകരും റിപ്പോ ഫോർക്ക് ചെയ്യുകയും ഫോർക്കിൽ മാറ്റങ്ങൾ വരുത്തുകയും വേണം, തുടർന്ന് അവരുടെ മാറ്റങ്ങൾ ഈ ഉയർന്ന തലത്തിലുള്ള റിപ്പോയിലേക്ക് വീണ്ടും ലയിപ്പിക്കുന്നതിനുവേണ്ടി ഒരു പുൾ അഭ്യർത്ഥന(pull request) സൃഷ്ടിക്കണം. ഉയർന്ന തലത്തിലുള്ള റിപ്പോ അഡ്‌മിനിസ്‌ട്രേറ്റർക്ക് മാറ്റങ്ങൾ ഇഷ്‌ടപ്പെട്ടാൽ അവ ലയിപ്പിക്കുകയും നിങ്ങൾക്ക് തൽക്ഷണം പ്രശസ്തി ലഭിക്കുകയും ചെയ്യും! 

## ഈ റെപ്പോസിറ്ററി ക്ലോൺ (clone) ചെയ്യുക
<img align="right" width="300" src="https://firstcontributions.github.io/assets/Readme/clone.png" alt="clone this repository" />

നിങ്ങളുടെ മെഷീനിലേക്ക് നിങ്ങളുടെ റിപ്പോ ക്ലോൺ ചെയ്യുക എന്നതാണ് അടുത്ത ഘട്ടം, അതുവഴി നിങ്ങൾക്ക് മാറ്റങ്ങൾ വരുത്താൻ ആരംഭിക്കാം. VS കോഡിന് നിങ്ങളുടെ റിപ്പോയുടെ URL ആവശ്യമാണ്, അതിനാൽ കോഡ് ബട്ടണിൽ ക്ലിക്കുചെയ്‌ത് "copy to clipboard" ഐക്കണിൽ ക്ലിക്കുചെയ്യുക.

**സൂക്ഷിക്കുക:** പുതിയ സംഭാവകർ പലപ്പോഴും ചെയ്യുന്ന ഒരു തെറ്റ് എന്തെന്നാൽ, നിങ്ങളുടെ റിപ്പോ ക്ലോൺ ചെയ്യുന്നതിനുപകരം നിങ്ങൾ _ഫോർക്ക് ചെയ്യാൻ ഉപയോഗിച്ച റിപ്പോ_ ക്ലോൺ ചെയ്യുക എന്നതാണ്. നിങ്ങളുടെ ബ്രൗസറിന്റെ address ബാർ പരിശോധിച്ച് നിങ്ങളുടെ റിപ്പോ തന്നെയാണ് ക്ലോൺ ചെയ്യുന്നതെന്ന് ഉറപ്പാക്കുക.

ഇപ്പോൾ വിഷ്വൽ സ്റ്റുഡിയോ കോഡ് തുറക്കുക. വിഎസ് കോഡിന്റെ സ്വാഗത പേജ് പോപ്പ് അപ്പ് ചെയ്യും. താഴെ കാണിച്ചിരിക്കുന്ന ബാർ തുറക്കാൻ അവിടെ നിന്ന് `F1` അമർത്തുക. ടെക്സ്റ്റ് ഫീൽഡിൽ ഇതിനകം തന്നെ `>` ചിഹ്നമുണ്ടെന്ന് ശ്രദ്ധിക്കുക. മറ്റൊരു മാർഗ്ഗം `CTRL-P` അമർത്തിക്കൊണ്ട് നിങ്ങൾ ഇൻപുട്ട് പ്രോംപ്റ്റിലേക്ക് പോയിട്ട്, `>`  ടൈപ്പ് ചെയ്യുന്നതാണ്.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-clone.png" alt="Clone Popup (Command Popup)" />
ഈ ചിത്രത്തിൽ ചില അവ്യക്തമായ കമാൻഡുകൾ താഴെ ലിസ്റ്റ് ചെയ്തിരിക്കുന്നത് നിങ്ങൾ ശ്രദ്ധിച്ചേക്കാം. ഞാൻ അടുത്തിടെ ഉപയോഗിച്ച കമാൻഡുകൾ ഇവയാണ്. അതുകൊണ്ട് അവരെ കാര്യമാക്കേണ്ട.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-clone1.png" alt="Clone repo" />

അടുത്തതായി `git clone` എന്ന് ടൈപ്പ് ചെയ്യുക.
'Git: Clone' എന്ന എൻട്രി തിരഞ്ഞെടുത്ത് 'Enter' അമർത്തുക.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-clone2.png" alt="Paste Repository URL in" />

നിങ്ങളുടെ റിപ്പോസിറ്ററിയുടെ URL പേസ്റ്റ് ചെയ്യുക, `Enter` അമർത്തുക. ഇത് ഒരു ഫയൽ എക്സ്പ്ലോറർ തുറക്കും, അവിടെ നിങ്ങൾക്ക് Git റിപ്പോസിറ്ററി എവിടെ സൂക്ഷിക്കണമെന്ന് തിരഞ്ഞെടുക്കാം.

**അറിയിപ്പ്**: ഇത് ഫോർക്ക്ഡ് റിപ്പോസിറ്ററി ആണെന്നും ഒറിജിനൽ അല്ലെന്നും ഉറപ്പാക്കുക, അല്ലാത്തപക്ഷം ഇത് പ്രവർത്തിക്കില്ല.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-clone3.png" alt="Status popup" />

വിഷ്വൽ സ്റ്റുഡിയോ കോഡിന്റെ ചുവടെ വലതുവശത്ത് നിങ്ങൾ ഒരു സ്റ്റാറ്റസ് പോപ്പ്അപ്പ് കാണും. ഇത് പൂർത്തിയായ ശേഷം, ഡയലോഗിലെ ബട്ടണുകൾ ഉപയോഗിച്ച് നിങ്ങൾക്ക് ക്ലോൺ ചെയ്ത റിപ്പോസിറ്ററി (ഇപ്പോൾ നിങ്ങളുടെ മെഷീനിലെ ഒരു ഫോൾഡർ) തുറക്കാൻ കഴിയും.

## ഒരു ശാഖ (ബ്രാഞ്ച്, Branch) ഉണ്ടാക്കുക 

`F1` അമർത്തി കമാൻഡ് പാലറ്റ് വീണ്ടും തുറക്കുക. `git branch` എന്ന് ടൈപ്പ് ചെയ്ത് അവിടെ നിന്ന് `create branch` എന്ന കമാൻഡ് തിരഞ്ഞെടുക്കുക. അടുത്ത ഘട്ടത്തിൽ നിങ്ങളുടെ പുതിയ ബ്രാഞ്ചിന്റെ പേര് ടൈപ്പ് ചെയ്യുക, ഉദാഹരണത്തിന് `add-david-kroell`. Enter അമർത്തുക, ബ്രാഞ്ച് സൃഷ്ടിക്കപ്പെടും. ബ്രാഞ്ചും ഇതിനകം ചെക്ക് ഔട്ട് ആയി. [ചെക്ക്ഔട്ട് എന്നാൽ എന്താണ് അർത്ഥമാക്കുന്നത്?](https://www.git-scm.com/docs/git-checkout)

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-branch.png" alt="Branches Command Palette" />

## ആവശ്യമായ മാറ്റങ്ങൾ വരുത്തുക

`Contributors.md` തുറന്ന് ഫയലിൽ എവിടെയും നിങ്ങളുടെ പേര് ചേർക്കുക. ഈ ഫയലിൽ <a href="https://en.wikipedia.org/wiki/Markdown">മാർക്ക്ഡൗൺ</a> വാക്യഘടനയുടെ ഉടമസ്ഥാവകാശമുള്ള GFM (GitHub Flavored Markdown) അടങ്ങിയിരിക്കുന്നു.

നിങ്ങൾക്ക് വാക്യഘടന ശരിയാണെന്ന് ഉറപ്പാക്കാൻ മറ്റ് സംഭാവകരുടെ ലൈനുകളിൽ ഒന്ന് പകർത്തി അത് നിങ്ങളുടെ പേരിനൊപ്പം പരിഷ്‌ക്കരിക്കുക. മാറ്റം രജിസ്റ്റർ ചെയ്യുന്നതിനായി ഫയൽ save ചെയ്യുക.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-changes.png" alt="Add your name" />

## GitHub-ലേക്ക് മാറ്റങ്ങൾ commit ചെയ്ത ശേഷം push ചെയ്യുക

വിഎസ് കോഡിന്റെ ഇടതുവശത്ത് 5 ഐക്കണുകൾ പ്രദർശിപ്പിച്ചിരിക്കുന്ന ഒരു മെനുവാണ്.version control/Source Control ഐക്കൺ തിരഞ്ഞെടുക്കുക.
(കുറുക്കുവഴി: Ctrl + Shift + G)

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-commit.png" alt="Commit changes" />

അവസാന കമ്മിറ്റിന് ശേഷം മാറ്റിയ എല്ലാ ഫയലുകളും file explorer പ്രദർശിപ്പിക്കുന്നു. ഫയലിന്റെ പേരിനു മുകളിൽ കഴ്‌സർ ഹോവർ ചെയ്ത ശേഷം `+` (പ്ലസ്) ക്ലിക്ക് ചെയ്യുന്നതിലൂടെ ഫയലുകൾ staged ആയി മാറുന്നു.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-commit1.png" alt="Stashed Files">

എക്സ്പ്ലോററിന് മുകളിലുള്ള വരിയിൽ എന്തെങ്കിലും ടൈപ്പ് ചെയ്ത് ചെക്ക്മാർക്ക് അമർത്തുക. മാറ്റങ്ങൾ ഇപ്പോൾ നിങ്ങളുടെ പ്രാദേശിക പകർപ്പിൽ committed ആയി. ഇപ്പോൾ മാറ്റങ്ങൾ GitHub-ലേക്ക് തിരികെ മാറ്റേണ്ടതുണ്ട്.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-push.png" alt="Stashed Files">

 മെനു തുറക്കാൻ മൂന്ന് കുത്തുകളുള്ള ഐക്കൺ ഉപയോഗിക്കുക, തുടർന്ന് നിങ്ങൾ `പബ്ലിഷ് ബ്രാഞ്ച്` ഓപ്‌ഷൻ അമർത്തുക. നിങ്ങളുടെ GitHub ക്രെഡൻഷ്യലുകൾ ഉൾപ്പെടുത്തുന്നതിന് ഇത് ഒരു ഡയലോഗ് തുറക്കും.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-windows-vs-code-tutorial/vscode-2018-08-gh-auth.png" alt="Stashed Files">

## നിങ്ങളുടെ മാറ്റങ്ങൾ അവലോകനത്തിനായി സമർപ്പിക്കുക

ഈ സമയത്ത് നിങ്ങൾ നിങ്ങളുടെ മാറ്റം പൂർത്തിയാക്കി, പക്ഷേ അത് ഇപ്പോഴും നിങ്ങളുടെ റിപ്പോയിൽ മാത്രമേ വസിക്കുന്നുള്ളൂ. നിങ്ങളുടെ മാറ്റം ലയിപ്പിക്കുന്നതിന് ഉയർന്ന തലത്തിലുള്ള റിപ്പോയുടെ അഡ്മിനിസ്ട്രേറ്റർക്ക് ഒരു അഭ്യർത്ഥന സമർപ്പിക്കുന്നത് എങ്ങനെയെന്ന് ഈ ഘട്ടം നിങ്ങളെ കാണിക്കും.

GitHub-ലെ നിങ്ങളുടെ റിപ്പോയിൽ പുതിയ ബ്രാഞ്ച് notification അടുത്തുള്ള `Compare & pull request` ബട്ടൺ നിങ്ങൾ കാണും. ആ ബട്ടണിൽ ക്ലിക്ക് ചെയ്യുക.

<img src="https://firstcontributions.github.io/assets/Readme/compare-and-pull.png" alt="create a pull request" />

ഇപ്പോൾ പുൾ റിക്വസ്റ്റ് സമർപ്പിക്കുക.

<img src="https://firstcontributions.github.io/assets/Readme/submit-pull-request.png" alt="submit pull request" />

ഉടൻ തന്നെ നിങ്ങളുടെ എല്ലാ മാറ്റങ്ങളും ഈ പ്രോജക്റ്റിന്റെ മാസ്റ്റർ ബ്രാഞ്ചിലേക്ക് ഞാൻ ലയിപ്പിക്കും. മാറ്റങ്ങൾ ലയിച്ചുകഴിഞ്ഞാൽ നിങ്ങൾക്ക് ഒരു അറിയിപ്പ് ഇമെയിൽ ലഭിക്കും.

## ഇവിടെ നിന്ന് എങ്ങോട്ട് പോകണം?

അഭിനന്ദനങ്ങൾ! ഒരു സംഭാവകൻ എന്ന നിലയിൽ നിങ്ങൾ പലപ്പോഴും അഭിമുഖീകരിക്കുന്ന സ്റ്റാൻഡേർഡ്  _fork -> clone -> edit -> PR_ വർക്ക്ഫ്ലോ നിങ്ങൾ ഇപ്പോൾ പൂർത്തിയാക്കി!

[വെബ് ആപ്പ്](https://firstcontributions.github.io#social-share) എന്നതിലേക്ക് പോയി നിങ്ങളുടെ സംഭാവനകൾ ആഘോഷിക്കുകയും സുഹൃത്തുക്കളുമായും പിന്തുടരുന്നവരുമായും അത് പങ്കിടുകയും ചെയ്യുക.

നിങ്ങൾക്ക് എന്തെങ്കിലും സഹായം ആവശ്യമുണ്ടെങ്കിൽ അല്ലെങ്കിൽ എന്തെങ്കിലും ചോദ്യങ്ങൾ ഉണ്ടെങ്കിൽ ഞങ്ങളുടെ സ്ലാക്ക് ടീമിൽ ചേരാം. [സ്ലാക്ക് ടീമിൽ ചേരുക](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA).


### [അധിക മെറ്റീരിയൽ](../additional-material/git_workflow_scenarios/additional-material.md)

## മറ്റ് ടൂളുകൾ ഉപയോഗിച്ചുള്ള ട്യൂട്ടോറിയലുകൾ
[പ്രധാന പേജിലേക്ക് മടങ്ങുക](https://github.com/firstcontributions/first-contributions#tutorials-using-other-tools)












