[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Open Source Helpers](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)

# First Contributions

| <img alt="GitHub Desktop" src="https://desktop.github.com/images/desktop-icon.svg" width="200"> | GitHub Desktop Edition |
| ----------------------------------------------------------------------------------------------- | ---------------------- |

É difícil. É sempre difícil fazer algo pela primeira vez. Especialmente quando se está colaborando, cometer erros não é algo agradável. Mas _open source_ (código aberto) se trata de colaboração e de trabalharmos juntos. Queremos simplificar a forma com que novos colaboradores _open source_ aprendem e contribuem pela primeira vez.

Ler artigos e ver tutoriais pode ajudar, mas o que é melhor do que realmente pôr a mão na massa em um ambiente prático? Este projeto visa guiar e simplificar a forma com que os novatos fazem a sua primeira contribuição. Se quiser fazer a sua primeira contribuição, siga os passos abaixo.

Se você nao tem o Github desktop na sua máquina, [instale aqui](https://desktop.github.com/).

Se você está usando uma versão do Github desktop antes da 1.0, [consulte este tutorial](github-desktop-old-version-tutorial.md).

<img align="right" width="300" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/fork.png" alt="fork este repositório" />

## Fork este repositório

Fork este repositório clicando no botão fork na parte superior direita dessa página.
Isso vai criar uma cópia desse repositório na sua conta.

## Clone este repositório

Agora clone esse repositório na sua máquina.

IMPORTANTE: NÃO CLONE O REPOSITÓRIO ORIGINAL. Vá para o seu fork e clone.

Para clonar esse repositório, clique em "Clone or Download" e então clique em "Open in Desktop".

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-clonetodesktop.png" alt="clone este repositório" />

Uma janela pop up vai aparecer. Clique em "Open GitHubDesktop.exe".

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-open-githubdesktop.png" alt="clone este repositório" />

Depois de clicar em "Open GitHubDesktop.exe" os arquivos serão baixados para o seu computador.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-downloaded.png" alt="clone este repositório" />

Agora você copiou os arquivos do repositório first-contributions no github para o seu computador.

## Criando uma branch (ramo)

Agora crie uma branch clicando na aba "Current branch" que fica no topo, depois clique em "New branch":

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-create-branch.png" alt="criar uma branch" />

Nomeie sua branch como <add-your-name>. Por exemplo, "add-james-smith"

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-create-branch-name.png" alt="nomeie sua branch" />

Clique em `Create branch`

## Faça as mudanças necessárias e commit essas mudanças

Agora abra o arquivo `Contributors.md` em um editor de texto, vá para o final do arquivo e adicione seu nome, depois salve o arquivo.

Exemplo: Se o seu nome for James Smith, Deve ficar parecido com isso.

\[James Smith](https://github.com/jamessmith)

Você pode ver as alterações feitas em Contributors.md no Github Desktop.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-status.png" alt="checar mudanças" />

Agora faça commit dessas alterações:

Escreva a mensagem "Add `<your-name>` to Contributors list" no campo _sumary_

Substitua `<your-name>` pelo seu nome.

Clique no botão que diz `Commit to add-your-name`.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-commit1.png" alt="commit suas alterações" />

Na parte inferior, você pode ver que o commit foi criado com sucesso.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-commit2.png" alt="commit suas alterações" />

## Faça o push das mudanças no github

Clique em File -> Options e depois em sign-in to Github.com. Digite seu username e senha do Github.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-sign-in.png" alt="log-in no Github" />

Clique no botão `Publish` na parte superior direita.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/dt1-publish1.png" alt="push suas alterações" />

## Envie suas alterações para review

Se você for até seu repositório no github, verá o botão `Compare & pull request`. Clique nesse botão

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/compare-and-pull.png" alt="criando um pull request" />

Agora envie o pull request.

<img src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-tutorial/submit-pull-request.png" alt="enviando o pull request" />

Em breve estarei mesclando todas as suas alterações na branch Master do projeto. Você vai receber um email de notificação assim que as alterações forem integradas.

## Qual o próximo passo?

Parabéns! Você acabou de completar o fluxo _fork -> clone -> edit -> PR_ que encontrará diversas vezes como contribuidor!

Comemore sua contribuição e compartilhe com seus amigos e seguidores acessando o [web app](https://firstcontributions.github.io#social-share).

Você pode entrar na nossa equipe no Slack caso precise de alguma ajuda ou tenha alguma dúvida. [Entre no Slack](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA).

### [Material adicional](../additional-material/git_workflow_senarios/additional-material.md)

## Tutoriais usando outras ferramentas

[Voltar a página principal](https://github.com/firstcontributions/first-contributions#tutorials-using-other-tools)
