[![Open Source Love](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)](https://github.com/ellerbrock/open-source-badges/)
[<img align="right" width="150" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/join-slack-team.png">](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA)
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT)
[![Open Source Helpers](https://www.codetriage.com/roshanjossey/first-contributions/badges/users.svg)](https://www.codetriage.com/roshanjossey/first-contributions)


# First Contributions

|<img alt="GitHub Desktop" src="https://desktop.github.com/images/desktop-icon.svg" width="200">|GitHub Desktop Edition|
|---|---|

It's hard. It's always hard the first time you do something. Especially when you are collaborating, making mistakes isn't a comfortable thing. But open source is all about collaboration & working together. We wanted to simplify the way new open-source contributors learn & contribute for the first time.

Reading articles & watching tutorials can help, but what comes better than actually doing the stuff without messing up anything. This project aims at providing guidance & simplifying the way rookies make their first contribution. Remember the more relaxed you are, the better you learn. If you are looking for making your first contribution just follow the simple steps below. We promise you, it will be fun.

<img align="right" width="300" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/fork.png" alt="fork this repository" />

If you don't have GitHub Desktop on your machine, [install it](https://desktop.github.com/).

## Fork this repository

Fork this repo by clicking on the fork button on the top of this page.
This will create of copy of this repository in your account.

## Clone the repository

Now clone this repo to your machine.

Open the GitHub Desktop app and click on the `+` on the top left.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-clone1.png" alt="clone this repository" />

If it is not already selected, click on `Clone`. Then choose first-contributions and then click on `Clone first-contributions`

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-clone2.png" alt="clone this repository" />

Choose the directory on your machine you would like to clone first-contributions into

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-clone3.png" alt="clone this repository" />

Now you have copied the contents of the first-contributions repository in github to your computer.

## Create a branch

Now create a branch by clicking on the branch icon at the top left:

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-branch1.png" alt="make a branch" />

Name your branch add-your-name. For example, add-crawleya

Click on `Create new branch`

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-branch2.png" alt="name your branch" />

## Make necessary changes and commit those changes

Now open `Contributors.md` file in a text editor and add your name to it, then save the file.

You can see that there are changes to Contributors.md and they have been added.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-status.png" alt="check status" />

Now commit those changes:

Write the message "Add `<your-name>` to Contributors list" in the *summary* field

Replace `<your-name>` with your name

Click on the button that says `Commit to add-your-name`

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-commit1.png" alt="commit your changes" />

At the bottom, you can see that the commit has been created.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-commit2.png" alt="commit your changes" />

## Push changes to github

Click the `Publish` button on the top right.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/dt-publish1.png" alt="push your changes" />

## Submit your changes for review

If you go to your repository on github, you'll see  `Compare & pull request` button. click on that button.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/compare-and-pull.png" alt="create a pull request" />

Now submit the pull request.

<img style="float: right;" src="https://firstcontributions.github.io/assets/gui-tool-tutorials/github-desktop-old-version-tutorial/submit-pull-request.png" alt="submit pull request" />

Soon I'll be merging all your changes into the master branch of this project. You will get a notification email once the changes have been merged.

## Where to go from here?

Congrats!  You just completed the standard _fork -> clone -> edit -> PR_ workflow that you'll encounter often as a contributor!

Celebrate your contribution and share it with your friends and followers by going to [web app](https://firstcontributions.github.io#social-share).

You could join our slack team in case you need any help or have any questions. [Join slack team](https://join.slack.com/t/firstcontributors/shared_invite/zt-1hg51qkgm-Xc7HxhsiPYNN3ofX2_I8FA).


### [Additional material](../additional-material/git_workflow_senarios/additional-material.md)


## Tutorials Using Other Tools
[Back to main page](https://github.com/firstcontributions/first-contributions#tutorials-using-other-tools)
