# Видалення файлу з-під GIT контролю

Іноді може виникнути необхідність видалити файл з-під GIT контролю, але зберегти його на комп'ютері. Це може бути досягнуто за допомогою наступної команди:

`` Git rm <файл> --cached``

## Що ж сталося?

GIT більш не контролює зміни у віддаленому файлі. З точки зору GIT'а, його немає, але якщо ви спробуєте локалізувати цей файл в файловій системі, то ви побачите, що він все ще на місці.

Зауважте, що в наведеній вище комманде використовується ключ `--cached`. Якби ми не додали цей ключ, GIT знищив би файл не тільки зі сховищ, але також і з файлової системи.

Якщо ви зробите Комміт за допомогою команди `git commit -m" Видалити file1.js "` і потім запущено його в віддалений репозиторій командою `git push origin master`, файл буде стертий також і з віддаленого сховища.

## Додаткова інформація

- Якщо ви хочете видалити більше одного файлу, це можна зробити, перерахувавши всі файли в одній команді:

    `Git rm file1.js file2.js file3.js --cached`

- Ви можете використовувати шаблон (*) для видалення файлів з близькими іменами, наприклад, якщо ви хочете видалити всі .txt файли з локального сховища, наберіть:

    `Git rm * .txt --cached`
