# Información Adicional

Aquí asumimos que ya has dominado las instrucciones básicas. La información adicional contiene algunos detalles sobre comandos de Git que son necesarios en situaciones más complejas.

### [Corrección en Commits](corrigiendo-un-commit.es.md)
Este documento contiene información sobre cómo corregir un commit en un repositorio remoto.
> Esto es necesario en casos en los que deseas modificar un commit que hiciste anteriormente.

### [Configuración de Git](configurando-git.es.md)
Este documento ofrece información sobre cómo cambiar la información del usuario y otras configuraciones de Git.
> Será útil si deseas hacer que tu configuración de Git sea más conveniente.

### [Manteniendo tu Fork Sincronizado con este Repositorio](manteniendo-tu-fork-sincronizado-con-este-repositorio.es.md)
Este documento explica cómo mantener sincronizado tu fork con este repositorio. Mantener la sincronización es importante ya que, en la medida en que esperamos, trabajarás en el proyecto no solo por ti mismo, sino con otros colaboradores.
> Sigue estos pasos si tu fork no tiene cambios en la rama master del repositorio.

### [Mover un Commit a una Rama Diferente](moviendo-un-commit-a-una-rama-diferente.es.md)
Este documento proporciona información sobre cómo mover un commit a una rama diferente.
> Sigue los pasos indicados para mover un commit a otra rama.

### [Eliminando un Archivo](eliminando-un-archivo.es.md)
Este documento describe cómo eliminar un archivo de tu repositorio local.
> Familiarízate con estos comandos para entender cómo eliminar un archivo antes de realizar un commit.

### [Eliminando una Rama de tu Repositorio](eliminando-una-rama-de-tu-repositorio.es.md)
Este documento ofrece información sobre cómo eliminar una rama de tu repositorio.
> Utiliza estos comandos solo después de que tu pull request haya sido aceptado.

### [Resolviendo Conflictos de Fusión de Ramas](resolviendo-conflictos-de-fusion-de-ramas.es.md)
Este documento proporciona información sobre cómo resolver conflictos que surgen al fusionar ramas.
> Sigue estos pasos para manejar los conflictos que pueden ser muy incómodos al fusionar ramas.

### [Deshaciendo un Commit](deshaciendo-un-commit.es.md)
Este documento describe cómo deshacer un commit en tu repositorio local. Esta operación es útil cuando necesitas revertir un commit después de que ya haya sido enviado a GitHub (pushed).
> Sigue estos pasos para deshacer un commit.

### [Fusionar Commits (Squashing)](fusionando-commits.es.md)
Este documento describe cómo fusionar commits mediante la rebase interactiva.
> Sigue estas instrucciones si un experto del proyecto te pide que fusiones todos tus commits en uno con un comentario significativo.

### [Deshaciendo un Commit Local](deshaciendo-un-commit-local.es.md)
Este documento proporciona información sobre cómo revertir un commit en tu repositorio local. Necesitarás esta información si decides que has dañado tu repositorio y deseas volver a su estado original.
> Sigue estas instrucciones si deseas deshacer los cambios que hiciste en tu último commit local.

### [Enlaces Útiles](enlaces-utiles-para-aprender-mas.es.md)
Este archivo contiene enlaces a publicaciones de blogs, sitios web útiles, sitios web con listas de recomendaciones y trucos que a menudo hacen nuestra vida más fácil. Tanto para principiantes como para expertos, recomendamos consultarlos según sea necesario. Este archivo contiene una lista de enlaces útiles que seguramente ayudarán a aquellos que dan sus primeros pasos en el código abierto y aquellos que desean expandir sus conocimientos en este campo.
