# Удаление файла из-под GIT контроля

Иногда может возникнуть необходимость удалить файл из-под GIT контроля, но сохранить его на компьютере. Это может быть достигнуто с помощью следующей команды: 

``git rm <файл> --cached``

## Что же произошло?

GIT более не контролирует изменения в удалённом файле. С точки зрения GIT'а, этот файл отсутствует, но если вы попробуете локализовать этот файл в файловой системе, то вы увидите, что он всё еще на месте. 

Заметьте, что в приведенной выше комманде используется ключ `--cached`. Если бы мы не добавили этот ключ, GIT уничтожил бы файл не только из репозитория, но также и из файловой системы. 

Если вы сделаете коммит при помощи команды `git commit -m "Удалить file1.js"` и затем запушите его в удалённый репозиторий командой `git push origin master`, файл будет стёрт также и из удалёного репозитория.

## Дополнительная информация

-  Если вы хотите удалить более одного файла, это можно сделать, перечислив все файлы в одной команде:

    `git rm file1.js file2.js file3.js --cached`

-   Вы можете использовать шаблон (*) для удаления файлов с близкими именами, например, если вы хотите удалить все .txt файлы из локального репозитория, наберите: 

    `git rm *.txt --cached`
