# Перемещение коммита в другую ветку
Что если вы сделали коммит, а затем поняли, что изменили неправильную ветку? 
Как исправить такую ошибку? На этот вопрос отвечает данная инструкция. 

## Перемещение последних коммитов в существующую ветку
Для такого перемещения, наберите:

```git reset HEAD~ --soft``` - Отменяет последний коммит, но сохраняет сделанныые изменения.  
```git stash``` - Сохраняет состояние директории.  

```git checkout <имя правильной ветки>``` - Переключается на другую ветку.   
```git stash pop``` - Возвращает последнее сохраненное состояние.  
```git add .``` - Добавляет индивидуальные файлы.  
```git commit -m "ваш комментарий"``` - Сохраняет и делает коммит изменений.  

Теперь ваши изменения - в правильной ветке.


### Перемещение последних коммитов в новую ветку
Для такого перемещения, наберите:  
```git branch newbranch``` -  Создает новую ветку, сохраняя все коммиты.   
```git reset --hard HEAD~[n]``` - Возвращает ветку master назад на n коммитов. Имейте в виду, что изменения содержащиеся в этих коммитах будут полностью удалены из ветки master.  
```git checkout newbranch``` - Переключается на ветку, которую вы создали. Эта ветка теперь содержит все коммиты.   

Запомните: Любые изменения, которые не были включены в коммит, будут полностью ПОТЕРЯНЫ.
