# Конфигурирование GITа

Когда вы впервые попытались сделать коммит, вы могли увидеть такое сообщение: 

```bash
$ git commit
*** Please tell me who you are. [Пожалуйста, сообщите, кто вы.]

Исполните следующие команды:

git config --global user.email "you@example.com"
git config --global user.name "Your Name"

чтобы идентифицировать пользователя по умолчанию для данной учетной записи.
Опустите ключ --global если вы хотите указать пользователя только для данного репозитория.  
```

Чтобы создать коммит, GIT должен знать кто является его автором. При совместной работе, необходимо знать кем и когда были изменены те или иные части проекта, поэтому GIT предусматривает, что каждый коммит при его создании ассоциируется с именем и емейл адресом пользователя.   

Существует несколько способов, которые позволяют ассоциировать команду `git commit` с вашим емейлом и именем, и здесь мы перечислим некоторые из них.

### Глобальная конфигурация

Информация, сохраненная как часть глобальной конфигурации, относится ко всей системе, т.е. ко всем репозиториям, в которых вы работаете. Это предпочтительный способ, подходящий для большинства из вариантов использования.     

Для сохранения данных в глобальной конфигурации пользуйтесь коммандой `config` в следующей форме: 

`$ git config --global <название переменной> <значение переменной>`

В применении к информации о пользователе, мы исполняем эти команды таким образом:

```
$ git config --global user.email "you@example.com"
$ git config --global user.name "Your Name"
```

### Конфигурация репозитория

Как указывает заголовок, такая конфигурация работает в пределах данного репозитория. Если вы хотите сделать коммит в определенном репозитории, скажем содержащем проект связанный с вашим бизнесом, используя емейл вашей компании, тогда вы можете использовать этот способ конфигурации.

Чтобы изменить конфигурацию на уровне репозитория, следует опустить ключ `--global` в команде `config` таким образом:

`$ git config <название переменной> <значение переменной>`

В применении к информации о пользователе, это выглядит следующим образом: 

```
$ git config user.email "you@alternate.com"
$ git config user.name "Your Name"
```

### Конфигурация в командной строке

Этот способ конфигурации относится только к данной команде. Все команды GIT'а позволяют использовать ключ `-c` перед глаголом идентифицирующим команду для временной установки конфигурационных параметеров.

Для изменения параметров конфигурации, распространяющихся только на данную команду, пользуйтесь следующим форматом команд GIT'a:

`$ git -c <переменная-1>=<значение переменной-1> -c <переменная-2>=<значение переменной-2> <команда>`

Для нашего случая комманда для коммита будет вылядеть так:

`git -c user.name='Your Name' -c user.email='you@example.com' commit -m "Ваш комментарий к коммиту"`

### Замечание о порядке предшествования

Порядок предшествования среди трех упомянутых типов команд конфигурации определяется как  `конфигурация в командной строке > конфигурация репозитория > глобальная конфигурация`. Это означает, что если какая-либо переменная определена, как в глобальной конфигурации, так и в командной строке, то будет использовано значение, присвоенное в командной строке.

## Не только информация о пользователе

До сих пор, обсуждая конфигурацию GIT'а, мы касались лишь информации о пользователе. Однако GIT позволяет конфигурировать еще неслколько параметров. Вот некторые из них:

1.  `core.editor` - указывает название редактора для редактирования комментарий для коммита и т.п.,
2.  `commit.template` - указывает файл, который содержит первоначальный темплат для коммита, 
3.  `color.ui` - логическая переменная, указывающая следует ли испольовать цветные шрифты в сообщениях на терминале GIT'а.

Для простоты мы опустили некоторые  детали. Для более подробного ознакомления обратитесь к  [git-scm.com](https://git-scm.com/book/ru/v1/Введение-Первоначальная-настройка-Git).