# Исправления в коммите

Представьте, что вы сделали коммит в удаленный репозиторий, а потом поняли, что допустили опечатку в комментарии к коммиту или забыли вставить строку в этот последний по времени коммит. Как поступить в такой ситуации? Именно об этом и пойдет речь в этом документе.

## Как изменить комментарий к недавнему коммиту после того, как он был послан на Github (pushed)
Чтобы сделать это, не открывая файл для редактирования, 
*   наберите  ```git commit --amend -m "здесь следует текст нового комментария"```
*   а затем исполните ```git push origin <имя-ветки>``` для того, чтобы послать изменения на Github.

Примечание: Если вы наберете, только ```git commit --amend```, то откроется текстовый редактор и предложит отредактировать комментарий к коммиту. Использование ключа ``-m`` отменяет запуск редактора.
 
## Как сделать изменения в одном коммите

Что если мы забыли сделать небольшое изменение в файле, например, заменить одно слово в коммите, который уже послан в удаленный репозиторий? 

Пусть, для примера, записи в журнале моих коммитов выглядят следующим образом:
```
g56123f создай файл bot file
a2235d  исправлен contributor.md
a5da0d  изменен bot file
```
Допустим, я забыл добавить одно слово в файл bot file

Есть два способа исправить это. Первый заключается в создании нового коммита, содержащего это изменение, например, так: 
```
g56123f создай файл bot file
a2235d  исправлен contributor.md
a5da0d  изменен botfile
b0ca8f  добавлено одно слово в botfile
```
Второй способ состоит в исправлении коммита a5da0d, добавлении этого пропущенного слова и запушивании этих изменений на Github в виде одного коммита.
Второй способ представляется предпочтительным, поскольку дело идёт лишь о незначительном изменении. 

Чтобы добиться этого, мы поступим следующим образом:
*   Изменим файл. В данном случае я изменю файл botfile, добавив к нему слово, которое я пропустил ранее.
*   Далее, проиндексируем этот файл при помощи команды ```git add <имяфайла>```

В обычном случае сразу после индексирования мы делаем ```git commit -m "комментраий к нашему коммиту"```, правильно? Но поскольку в данном случае наша задача - исправить предыдущий коммит, - то вместо этого мы выполним такую команду:

* ```git commit --amend```
 В результате откроется окно текстового редактора, в котором мы имеем возможность сделать изменения в комментарии. Мы можем в самом деле отредактировать комментарий, или оставить его без изменений. 
* Выйдем из редактора
* Запушим наши изменения при помощи команды  ```git push origin <имя-ветки>```

Таким образом, оба исправления окажутся в одном коммите.
