﻿# Informações Adicionais

Nós imaginamos que você já tenha terminado o tutorial básico antes de vir aqui. As informações adicionais te darão algumas informações sobre técnicas mais avançadas de Git.

### [Emendando um commit](../git_workflow_scenarios/amending-a-commit.md)
Esse documento provê informações sobre como emendar um commit no repositório remoto.
> Use isso quando você precisar ajustar um commit que você tenha feito.

### [Configurando o git](../git_workflow_scenarios/configuring-git.md)
Esse documento provê informações sobre como configurar detalhes de usuário e outras opções do git.
> Use isso para melhor controlar as suas configurações do git.

### [Mantendo o seu fork em sincronia com o repositório](../git_workflow_scenarios/keeping-your-fork-synced-with-this-repository.md)
Esse documento provê informações sobre como manter o seu fork atualizado com o repositório base. Isso é importante, já que se espera que você e muitas outras pessoas contribuem com o projeto.
> Siga esses passos se o seu fork não possui as mesmas alterações do repositório pai.

### [Movendo um Commit para um Branch diferente](../git_workflow_scenarios/moving-a-commit-to-a-different-branch.md)
Esse documento provê informações sobre como mover um Commit para outro Branch.
> Siga esses passos para mover um commit para outro branch.

### [Removendo um arquivo](../git_workflow_scenarios/removing-a-file.md)
Esse documento provê informações sobre como remover um arquivo do seu repositório local.
> Siga esses passos para aprender como remover um arquivo do seu repositório local.

### [Removendo um Branch do seu repositório](../git_workflow_scenarios/removing-branch-from-your-repository.md)
Esse documento provê informações sobre como deletar um Branch do seu repositório.
> Apenas siga esses passos após o seu pull request ter sido mesclado.

### [Resolvendo conflitos de Merge](../git_workflow_scenarios/resolving-merge-conflicts.md)
Esse documento provê informações sobre como resolver conflitos de Merge.
> Siga esses passos para resolver conflitos de Merge irritantes.

### [Revertendo um commit](../git_workflow_scenarios/reverting-a-commit.md)
Esse documento provê informações sobre como reverter um commit feito no repositório remoto. Isso é muito útil quando você precisa desfazer um commit que tenha sido publicado no GitHub.
> Siga esses passos se você quiser reverter um commit.

### [Comprimir Commits juntos](../git_workflow_scenarios/squashing-commits.md)
Esse documento provê informações sobre como esmagar commits juntos em um só realizando um rebase.
> Use esses passos se você quiser realizar um PR em um projeto open source e a pessoa que realizou o review pedir para você mesclar todos os commits em um só, com uma mensagem de commit informativa.

### [Desfazendo um commit local](../git_workflow_scenarios/undoing-a-commit.md)
Esse documento provê informações sobre como desfazer um commit no seu repositório local. Isso é o que você precisa fazer quando sente que fez alguma besteira no seu repositório e deseja desfazer.
> Take these steps if you want to undo/reset a local commit.

### [Links úteis](../git_workflow_scenarios/Useful-links-for-further-learning.md)
Esse documento é dedicado a todos os blogs, posts, sites úteis, dicas e truques que fazem a nossa vida mais simples. Seja você um expert ou um iniciante, essa pagina deve servir como um index para todos esses links úteis para ajudar qualquer um que seja novo no mundo de projetos open-source ou alguém que queira prender mais a respeito.
