# Git वातावरण सेट अप गर्दै

पहिलो पटक तपाईंले Git सँग कमिट गर्ने प्रयास गर्नुभयो, तपाईंले निम्न सन्देश देख्न सक्नुहुन्छ:

```bash
$ git commit
*** Please tell me who you are.

Run

git config --global user.email "you@example.com"
git config --global user.name "Your Name"

to set your account's default identity.
config --global to set the identity only in this repository.
```

Git लाई कमिट सिर्जना गर्न को लागी तपाई को हुनुहुन्छ भनेर जान्न आवश्यक छ। जब तपाइँ धेरै व्यक्तिहरूसँग समूहमा काम गर्नुहुन्छ, तपाइँलाई सधैं थाहा हुनुपर्छ कि कसले परियोजनामा ​​​​कुन परिवर्तन गर्यो र उनीहरूले यो कहिले गरे। यस अन्तको लागि, Git सिर्जना गरिएको थियो ताकि कमिटहरू नाम र ईमेलमा बाँधिएका छन्।

त्यहाँ 'git कमिट' आदेशमा तपाईंको नाम र इमेल प्रदान गर्ने धेरै तरिकाहरू छन्, र हामी ती मध्ये केहीलाई निम्न लाइनहरूमा जानेछौं।

### ग्लोबल कन्फिगरेसन

जब हामीले ग्लोबल कन्फिगरेसन (ग्लोबल कन्फिगरेसन) मा केहि बचत गर्छौं, यो सेटिङ तपाईंले काम गर्ने सबै भण्डारहरूमा उपलब्ध हुन्छ। यो विधि सिफारिस गरिएको छ र अधिकतर अवस्थामा काम गर्दछ।

ग्लोबल कन्फिगरेसनमा केहि बचत गर्न, 'config' आदेश प्रयोग गर्नुहोस्:

`$ git config --global <variable name> <value>`

प्रयोगकर्ता डेटा को मामला मा:

```
$ git config --global user.email "you@example.com"
$ git config --global user.name "Your Name"
```

### भण्डार कन्फिगरेसन

नामले नै हामीलाई बताउँछ, यी कन्फिगरेसनहरू केवल एउटा भण्डारमा सीमित छन्। यदि तपाइँ एक विशेष भण्डारमा प्रतिबद्ध गर्न चाहनुहुन्छ भने, तपाइँको कामको इ-मेलको साथ कार्य परियोजना भन्नुहोस्, त्यसपछि हामी यो विधि प्रयोग गर्दछौं।

भण्डार कन्फिगरेसनमा केहि बचत गर्न, `config` आदेश प्रयोग गर्नुहोस् र `--global` झण्डा छोड्नुहोस्:


`$ git config <variable name> <value>`

प्रयोगकर्ता डेटा को मामला मा:

```
$ git config user.email "you@alternate.com"
$ git config user.name "Your Name"
```

### कमाण्ड लाइन कन्फिगरेसन

यी कन्फिगरेसनहरू हालको आदेश रेखामा मात्र सीमित छन्। सबै Git आदेशहरूले आदेश क्रियाको अगाडि `-c` उपसर्ग स्वीकार गर्दछ। यसले अस्थायी कन्फिगरेसन सिर्जना गर्दछ।

आदेश रेखा कन्फिगरेसनमा केहि बचत गर्न:

`$ git -c <variable-1>=<value> -c <variable-2>=<value> <command>`

हाम्रो उदाहरणमा, हामी कमिट आदेशलाई यसरी प्रयोग गर्नेछौं:

`git -c user.name='Your Name' -c user.email='you@example.com' commit -m "Your commit message"`

### फाइदाको बारेमा

माथि उल्लिखित विधिहरू बीच प्रयोगको क्रम निम्नानुसार छ `command-line > repository > global`. यसको मतलब यदि चर कमाण्ड लाइन र ग्लोबलमा भण्डार गरिएको छ भने, कमाण्ड लाइन कन्फिगरेसनमा मान प्रयोग गरिनेछ।

## साथै

अहिलेसम्म हामीले प्रयोगकर्ता सेटिङहरूमा मात्र काम गरेका छौं, तर त्यहाँ केही अन्य कन्फिगरेसनहरू छन्। ती मध्ये केही हुन्: 

1.  `core.editor` - टिप्पणी लेख्न प्रयोग गर्न पाठ सम्पादक निर्दिष्ट गर्न, आदि।
2.  `commit.template` - प्रारम्भिक कमिट टेम्प्लेटको रूपमा प्रयोग गर्न प्रणालीमा फाइल निर्दिष्ट गर्न 
3.  `color.ui` - Git को आउटपुटमा रङहरू प्रयोग गर्न बुलियन मान निर्दिष्ट गर्न।

हामीले सजिलै बुझ्नको लागि केही विवरणहरू सरलीकृत गरेका छौं। तपाईं मा थप पढ्न सक्नुहुन्छ [git-scm.com](https://git-scm.com/book/en/v2/Customizing-Git-Git-Configuration).
