## 커밋 되돌리기

커밋을 되돌리려면 이전 커밋에서 수행 된 모든 변경 사항을 취소하는 새로운 커밋을 만드는 것입니다. 그것은 git에서 ```CTRL + Z ``` 를 실행하는 것과 같습니다.

원격 저장소에 푸시하는 모든 커밋에는 SHA(Secure Hash Algorithm)라고 하는 고유한 알파벳 키가 있으므로 git에서 되돌리기가 쉬워집니다. 즉, SHA를 사용하는 한 언제든지 커밋을 되돌릴 수 있습니다. 하지만 그렇게 하면, 당신의 저장소가 엉망이 되지 않도록 조심스럽게 순서대로 배열해야 합니다.

실행 취소하려는 특정 커밋의 SHA를 선택하려면 지금까지 작성한 모든 커밋의 로그가 도움이 될 것입니다.
이를 위해 다음 명령을 실행합니다:
```git log --oneline ```
```git log``` 명령만 실행하면 SHA(긴 형식)을 얻을 수 있지만 ```--oneline ``` 플래그를 사용하면 보다 가독성이 좋은(한줄) 방식으로 표시할 수 있습니다.

이 명령을 실행할 때 표시되는 첫번째 7개의 문자는 축약 커밋 해시라고 합니다.

예를 들어, 이 저장소에서 ```git log --oneline ``` 을 실행하면 다음과 같은 결과를 얻을 수 있습니다:
For example, here is what I get when I run ```git log --oneline ``` on this repository:
```
389004d added spacing in title
c1b9fc1 Merge branch 'master' into tutorials
77eaafd added tutorial for reverting a commit
```

따라서 ```git log --oneline``` 을 사용하면 SHA의 처음 7개의 문자와 함께 저장소에서 작성한 모든 커밋 목록을 가져올 수 있습니다.

이제 "added spacing in title"에 대한 커밋을 취소하고 싶다고 가정하고, 다음 단계를 수행하겠습니다.

*   커밋의 SHA를 복사합니다. 여기서는 ```389004d``` 입니다.
*   그리고 나서 ```git revert 389004d``` 명령을 싱행합니다.

이렇게 하면 텍스트 편집기가 열리고 커밋 메시지를 편집하라는 메시지가 표시됩니다. 커밋 메시지를 `Revert` 라는 단어로 시작하는 기본 git 메시지로 남겨두거나 원하는대로 메시지를 작성할 수도 있습니다.

*   다음으로, 텍스트 편집기를 저장하고 닫습니다.
*   커맨드 라인으로 돌아갑니다.
*   ```git push origin <branch-name>``` 을 실행하여 되돌린 변경사항을 Github에 푸시하십시오.

그리고 바로 변경사항이 원상태로 돌아갈 것입니다. 이 경우에 저장소가 ```c1b9fc1``` 의 상태로 되돌아갑니다.
