# 추가 정보

여러분이 여기에 오기 전에 기본실습 과정을 이미 완료했다고 가정합니다. 이 문서는 고급 Git 기술에 대한 추가적인 정보를 제공합니다.

### [커밋 수정하기](amending-a-commit.ko.md)
이 문서는 원격 저장소의 커밋을 수정하는 방법에 대한 정보를 제공합니다. 커밋을 수정하는 것은 당신의 현재 브랜치 내 가장 최근의 커밋을 변경하는 한 방법입니다. 이는 커밋 메세지를 수정해야 하거나 커밋에 변경사항을 포함하지 않은 경우에 유용합니다. 당신은 원격 저장소에 커밋을 푸시하기 전까지 커밋을 계속해서 수정할 수 있습니다.
> 당신이 만든 커밋을 수정해야 할 경우 사용하십시오.

### [git 설정하기](configuring-git.md)
이 문서는 git에서 사용자 정보 및 기타 옵션을 구성하는 방법에 대한 정보를 제공합니다.
> git 설정을 더 잘 다루려면 이 단계를 수행하십시오.

### [여러분이 포크한 저장소와 싱크상태 유지하기](keeping-your-fork-synced-with-this-repository.ko.md)
이 문서는 포크 된 저장소를 기본 저장소로 최신 상태로 유지하는 방법에 대한 정보를 제공합니다. 여러분과 다른 많은 사람들이 프로젝트에 기여하기를 바랍니다.
> 포크 된 상위 저장소가 변경되지 않은 경우 다음 단계를 수행하십시오.

### [커밋을 다른 브랜치로 이동하기](moving-a-commit-to-a-different-branch.ko.md)
이 문서는 커밋을 다른 브랜치로 이동하는 방법에 대한 정보를 제공합니다.
> 이 단계를 수행하여 커밋을 다른 브랜치로 이동하십시오.

### [파일 삭제하기](removing-a-file.ko.md)
이 문서는 로컬 저장소에서 파일을 지우는 방법에 대한 정보를 제공합니다.
> 커밋 전에 파일을 삭제하는 방법을 배우려면 다음의 과정을 수행하십시오.

### [여러분의 저장소에서 브랜치 삭제하기](removing-branch-from-your-repository.ko.md)
이 문서는 저장소에서 브랜치를 삭제하는 방법에 대한 정보를 제공합니다.
> PR(pull request) 요청이 병합 된 후에 본 단계를 수행하십시오.

### [병합 충돌 해결하기](resolving-merge-conflicts.ko.md)
이 문서는 병합 충돌을 해결하는 방법에 대한 정보를 제공합니다.
> 이 단계를 수행하여 곤란한 병합 충돌을 해결하십시오.

### [커밋 되돌리기](reverting-a-commit.ko.md)
이 문서는 원격 저장소에서 커밋을 되돌리는 방법에 대한 정보를 제공합니다. 이미 Github에 푸시 된 커밋을 되돌리려는 경우 유용합니다.
> 커밋을 되돌리려면 이 단계를 수행하십시오.

### [스쿼시 커밋하기](../squashing-commits.md)
이 문서는 대화형 리베이스로 커밋을 스쿼시하는 방법에 대한 정보를 제공합니다.
> 오픈 소스 프로젝트에서 PR을 보낼 때 리뷰어가 모든 커밋을 하나로 스쿼시하도록 요청하는 경우 유익한 커밋 메시지와 함께 이것을 사용하십시오.

### [로컬 커밋 되돌리기](undoing-a-commit.ko.md)
이 문서는 로컬 저장소에서 커밋을 실행 취소하는 방법에 대한 정보를 제공합니다. 로컬 저장소가 엉망이라고 느껴 당신이 로컬 저장소를 리셋하고자 할 때 당신이 해야 할 일입니다.
> 로컬 커밋을 취소하려면 이 단계를 수행하십시오.

### [유용한 링크](../Useful-links-for-further-learning.md)
이 문서는 모든 블로그 게시물, 유용한 사이트, 유용한 정보 및 웹 사이트에 대한 내용을 담고 있습니다. 우리가 모든 필요를 위해 참조하는 것은 초심자 또는 전문가 일 것입니다. 이 페이지는 오픈 소스 도메인을 처음 접하거나 더 많은 것을 배우고자 하는 사람들을 돕는 지표 역할을 해야 합니다.

### [.gitignore 파일 생성하기](creating-a-gitignore-file.ko.md)
이 문서는 .gitignore 파일의 역할, 사용 이유 및 .gitignore 파일 생성 방법을 설명합니다. 이 파일은 거의 모든 git 프로젝트에 사용됩니다. 이는 필요한 파일만 git에 커밋하도록 돕습니다.

### [크리덴셜 저장하기](storing-credentials.ko.md)
이 문서는 저장소들의 크리덴셜을 저장하는 방법을 설명합니다. 이는 보안 관련 문제가 될 수 있으므로, 당신의 직장/ 학업 에 알맞은 보안 정책을 따르십시오.