Here's the corrected README.md file with improved grammar:

# गिट से एक फाइल को हटाना
कभी-कभी, आपको किसी फ़ाइल को Git से हटाने की आवश्यकता होती है, लेकिन आप नहीं चाहते कि यह आपके कंप्यूटर से हटा दिया जाए। आप निम्नलिखित कमांड का उपयोग करके इसे प्राप्त कर सकते हैं:

``git rm <file> --cached``

## इसका क्या मतलब है?
Git अब हटाई गई फ़ाइल में किए गए परिवर्तनों का ट्रैकिंग नहीं करेगा। जैसा कि Git को पता होगा, आपने इस फ़ाइल को हटा दिया है। यदि आपने अपने फ़ाइल सिस्टम में फ़ाइल का पता लगाने का प्रयास किया हो, तो आप देखेंगे कि यह अभी भी वहीं है।

यह ध्यान दें कि ऊपर के उदाहरण में, ``--cached`` फ़्लैग का प्रयोग किया गया है। अगर हमने इस ध्वज को नहीं जोड़ा होता, तो Git न केवल रेपोसिटरी से, बल्कि आपके फ़ाइल सिस्टम से भी फ़ाइल को हटा देता।

यदि आप ``git commit -m "Remove file1.js"`` के साथ इस परिवर्तन को करते हैं और फिर ``git push origin master`` का उपयोग करके दूरस्थ रेपोसिटरी में पुश करते हैं, तो दूरस्थ रेपोसिटरी में फ़ाइल को हटा दिया जाएगा।

## अतिरिक्त विशेषताएँ
- यदि आपको एक से अधिक फ़ाइलों को हटाना है, तो आप उन सभी को एक ही कमांड में शामिल कर सकते हैं:

``git rm file1.js file2.js file3.js --cached``

- आप वाइल्डकार्ड (*) का उपयोग करके समान प्रकार की फ़ाइलों को हटाने के लिए उपयोग कर सकते हैं। उदाहरण के लिए, यदि आप अपने स्थानीय भंडार से सभी .txt फ़ाइलों को हटाना चाहते हैं:

``git rm *.txt --cached``