# Διαμόρφωση του git

Την πρώτη φορά που προσπαθήσατε να κάνετε commit χρησιμοποιώντας το git, πιθανόν να είδατε ένα παραθυράκι παρόμοιο με αυτό:

```bash
$ git commit
*** Παρακαλώ πείτε μου ποιός είστε.

Εκτελέστε

git config --global user.email "you@example.com"
git config --global user.name "Your Name"

για να ορίσετε την προεπιλεγμένη ταυτότητα του λογαριασμού σας.
Παραλείψτε την επιλογή --global για να ορίσετε την ταυτότητα μόνο σε αυτό το αποθετήριο.
```

Το git χρειάζεται να γνωρίζει ποιός είστε κάθε φορά που δημιουργείτε ένα commit. Όταν εργάζεστε συνεργατικά, πρέπει να μπορείτε να δείτε ποιος έχει τροποποιήσει ποια μέρη του έργου και πότε. Επομένως, το git έχει σχεδιαστεί έτσι ώστε να δημιουργεί commits που συσχετίζονται με ένα όνομα και ένα email.

Υπάρχουν πολλοί τρόποι για να παρέχετε το email και το όνομά σας στην εντολή `git commit`, και θα δούμε μερικούς από αυτούς παρακάτω.

### Παγκόσμια Διαμόρφωση

Όταν αποθηκεύετε κάτι στην παγκόσμια διαμόρφωση (global config), είναι προσβάσιμο σε όλα τα αποθετήρια στα οποία εργάζεστε. Αυτός είναι ο προτιμώμενος τρόπος και λειτουργεί για τις περισσότερες περιπτώσεις.

Για να αποθηκεύσετε κάτι στην παγκόσμια διαμόρφωση, χρησιμοποιείτε την εντολή `config` ως εξής:

`$ git config --global <όνομα_μεταβλητής> <τιμή>`

Στην περίπτωση των στοιχείων του χρήστη, το εκτελούμε ως εξής:

```
$ git config --global user.email "you@example.com"
$ git config --global user.name "Your Name"
```

### Διαμόρφωση Αποθετηρίου

Όπως υποδηλώνει το όνομά τους, αυτές οι διαμορφώσεις εφαρμόζονται στο τρέχον αποθετήριο. Αν θέλετε να κάνετε commit σε ένα συγκεκριμένο αποθετήριο, για παράδειγμα, ένα έργο που σχετίζεται με την εργασία σας, μπορείτε να χρησιμοποιήσετε αυτήν τη μέθοδο.

Για να αποθηκεύσετε κάτι στη διαμόρφωση αποθετηρίου, χρησιμοποιείτε την εντολή `config` αφήνοντας έξω τη σημαία `--global`, όπως εξής:

`$ git config <όνομα_μεταβλητής> <τιμή>`

Στην περίπτωση των στοιχείων του χρήστη, το εκτελούμε ως εξής:

```
$ git config user.email "you@alternate.com"
$ git config user.name "Your Name"
```

### Διαμόρφωση Μέσω Γρα

μμής Εντολών

Αυτού του τύπου διαμορφώσεις ισχύουν μόνο για την τρέχουσα εντολή. Όλες οι εντολές git δέχονται ορίσματα `-c` πριν το ρήμα δράσης για να ορίσουν προσωρινά δεδομένα διαμόρφωσης.

Για να αποθηκεύσετε κάτι στη διαμόρφωση μέσω γραμμής εντολών, εκτελέστε την εντολή σας ως εξής:

`$ git -c <μεταβλητή-1>=<τιμή> -c <μεταβλητή-2>=<τιμή> <εντολή>`

Στο παράδειγμά μας, θα εκτελούσαμε την εντολή commit ως εξής:

`git -c user.name='Your Name' -c user.email='you@example.com' commit -m "Your commit message"`

### Σημείωση για την Προτεραιότητα

Ανάμεσα στις τρεις μεθόδους που περιγράφηκαν εδώ, η προτεραιότητα είναι `command-line > repository > global`. Αυτό σημαίνει ότι, αν μια μεταβλητή έχει διαμορφωθεί τόσο μέσω γραμμής εντολών όσο και παγκοσμίως, η τιμή που δόθηκε μέσω γραμμής εντολών θα χρησιμοποιηθεί για τη λειτουργία.

## Εκτός από τα Στοιχεία του Χρήστη

Μέχρι στιγμής ασχοληθήκαμε μόνο με τα στοιχεία του χρήστη κατά τη διαμόρφωση. Ωστόσο, υπάρχουν πολλές άλλες διαθέσιμες επιλογές διαμόρφωσης. Ορισμένες από αυτές είναι:

1. `core.editor` - για να καθορίσετε το όνομα του επεξεργαστή που χρησιμοποιείται για τη σύνταξη μηνυμάτων commit κ.λπ.
2. `commit.template` - για να καθορίσετε ένα αρχείο στο σύστημα ως πρότυπο αρχικού commit.
3. `color.ui` - για να καθορίσετε μια λογική τιμή για τη χρήση χρωμάτων στην έξοδο του git.

Απλοποιήσαμε κάποιες λεπτομέρειες για ευκολία κατανόησης. Για περισσότερες πληροφορίες, επισκεφθείτε το [git-scm.com](https://git-scm.com/book/en/v2/Customizing-Git-Git-Configuration).