# اصلاح یک کامیت

چه کار باید بکنی اگر یک تغییر را به مخزن کامیت کردی ولی بعدا متوجه شدی که پیام کامیت مشکل داشته و یا فراموش کردی یک خط به آخرین کامیتت اضافه کنی.
چجوری میشود این را اصلاح کرد؟
این موضوعی است که در این آموزش به آن پرداخته میشود.

## تغییر دادن پیام یک کامیت که اخیرا به گیت هاب ارسال کردی
برای این کار بدون باز کردن  فایلی:

1.تایپ کنید:

```
git commit --amend -m "پیام جدید برای این کامیت"
```

2.دستور
  
```
git push origin <نام-شاخه>
```

را اجرا کنید تا تغییرات در مخزن ثبت شوند

<br/>

نکته: اگر فقط تایپ کنی
```git commit --amend```، ویرایشگر متنت باز خواهد شد و درخواست تغییر پیام کامیت را خواهد داشت.
اضافه کردن ```m-``` از این پیشگیری می کند.

## اصلاح کردن یک کامیت

حالا اگر فراموش کرده باشی که یک تغییر کوچک مثل اضافه کردن یک کلمه به یک فایل را انجام بدی، و قبلا تغییرات را ثبت و به مخزن ارسال کرده باشی، چیکار باید انجام بدی؟

مثلا این لاگ (log) کامیت هاست:
```
g56123f create botfile 
a2235d updated contributor.md
a5da0d modified  botfile
```

برای مثال فراموش کردی که یک کلمه به (botfile) اضافه کنی.

از دو روش  میشود این کار را انجام داد.

راه اول این است که یک کامیت جدید ایجاد کرد که شامل این تغییرات هست:
```
g56123f create botfile 
a2235d updated contributor.md
a5da0d modified  botfile
b0ca8f added single word to botfile
```

 راه دوم این است که کامیت (a5da0d) را اصلاح کنی، کلمه جدید را اضافه کنی و به عنوان "یک" کامیت به مخزن ارسال کنی.
این راه به نسبت بهتر است برای اینکه فقط یک تغییر کوچک است.

برای این کار به ترتیب:

1.فایل را اصلاح کن. در این مثال فایل (botfile) را اصلاح میکنیم تا کلمه جدید  را اضافه کنیم.

2.فایل را به تغییرات اضافه کنید:

```
git add <اسم-فایل>
```

معمولا بعد از اضافه کردن تغییرات، با دستور 

```
git commit -m "our commit message"
```

تغییرات را ثبت میکنیم، ولی به خاطر اینکه می خواهیم کامیت قبلی را اصلاح کنیم، این دستور را اجرا کنیم:

```
git commit --amend
```
با اجرای این دستور ویرایشگر متن باز خواهد شد و تا پیام کامیت را تغییر بدی

ویرایشگر متن را ببند
تغییرات رو به مخزن ارسال کن..
```
git push origin <اسم-شاخه>
```

تمام شد. الان هر دو تغییر در یک کامیت ثبت شده اند.